/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.ResultadoAlteracaoBoletoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.ResultadoCancelamentoBoletoDTO;
import java.time.LocalDate;
import org.apache.commons.lang3.NotImplementedException;

public interface IntegracaoBoletoRegistrado {
    public CodigoBarrasDTO generateBoleto(Bloqueto var1, ParametroCNAB240 var2);

    public ParametroCNAB240 getParametroCnab240ByBanco();

    public TipoCodigoBarras getTipoCodigoBarras();

    default public ResultadoCancelamentoBoletoDTO cancelarBoleto(Bloqueto boleto) {
        throw new NotImplementedException(String.format("N\u00e3o existe integra\u00e7\u00e3o para cancelamento de boleto para o banco %d.", boleto.getModeloBloqueto().getConvenio().getBanco().getId()));
    }

    default public void beforeGenerateBoleto(Bloqueto boleto) {
    }

    default public void afterGenerateBoleto(Bloqueto boleto, CodigoBarrasDTO dto) {
        boleto.setDvNossoNumero(dto.getDvNossoNumero());
        boleto.setCodigoBarrasFormatado(dto.getCodigoBarrasFormatado());
        boleto.setRegistroOnline(Boolean.TRUE);
    }

    default public ResultadoAlteracaoBoletoDTO updateVencimentoBoleto(Bloqueto boleto, LocalDate vencimento) {
        throw new NotImplementedException(String.format("N\u00e3o existe integra\u00e7\u00e3o para altera\u00e7\u00e3o de vencimento para o banco %d.", boleto.getModeloBloqueto().getConvenio().getBanco().getId()));
    }
}

