/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.peticao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticao;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItem;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItemDetalhe;
import br.com.elotech.tributos.domain.documento.peticao.SituacaoLotePeticao;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.DocumentoTipoService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.service.documento.peticao.LotePeticaoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class GeraPeticaoService {
    private final LotePeticaoService lotePeticaoService;
    private final ContextService contextService;
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final DocumentoTipoService documentoTipoService;
    private final DocumentoService documentoService;
    private final DebitoParcelaService debitoParcelaService;

    public GeraPeticaoService(LotePeticaoService lotePeticaoService, ContextService contextService, EntidadeTributacaoService entidadeTributacaoService, DocumentoTipoService documentoTipoService, DocumentoService documentoService, DebitoParcelaService debitoParcelaService) {
        this.lotePeticaoService = lotePeticaoService;
        this.contextService = contextService;
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.documentoTipoService = documentoTipoService;
        this.documentoService = documentoService;
        this.debitoParcelaService = debitoParcelaService;
    }

    public LotePeticao gerarPeticoesLote(Long idLotePeticao) {
        LocalDate dataGeracao = LocalDate.now();
        LotePeticao lotePeticao = (LotePeticao)this.lotePeticaoService.findById((Serializable)idLotePeticao).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar lote de peti\u00e7\u00e3o com o id %d", idLotePeticao)));
        if (!SituacaoLotePeticao.SIMULACAO_GERADA.equals((Object)lotePeticao.getSituacao())) {
            throw new EloValidationException(String.format("O lote com o id %d possui situa\u00e7\u00e3o diferente de Simula\u00e7\u00e3o Gerada.", idLotePeticao));
        }
        List itensValidos = this.lotePeticaoService.getItensValidos(idLotePeticao);
        if (itensValidos.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel emitir as peti\u00e7\u00f5es por que todas as CDAS j\u00e1 est\u00e3o vinculados com as peti\u00e7\u00f5es");
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidade, exercicio);
        DocumentoTipo tipoDocumento = this.documentoTipoService.findById(TipoDocumentoEnum.PETICAO_DIVIDA_ATIVA.getCodigo());
        lotePeticao.getItens().forEach(lotePeticaoItem -> {
            Documento peticaoGerada = this.gerarPeticao(lotePeticaoItem, entidade, exercicio, entidadeTributacao, tipoDocumento, dataGeracao);
            lotePeticaoItem.setDocumento(peticaoGerada);
            this.documentoService.save((EloEntity)peticaoGerada, null);
            if (lotePeticao.getAjuizarDebitos().booleanValue()) {
                this.ajuizarDebitos(peticaoGerada, dataGeracao);
            }
        });
        lotePeticao.setSituacao(SituacaoLotePeticao.PETICAO_GERADA);
        lotePeticao.setDataGeracao(dataGeracao);
        lotePeticao.setUsuarioGeracao(SecurityUtils.getUserAise());
        return (LotePeticao)this.lotePeticaoService.save((EloEntity)lotePeticao, null);
    }

    private void ajuizarDebitos(Documento peticaoGerada, LocalDate dataGeracao) {
        peticaoGerada.getCertidoesDividaAtivaPeticao().forEach(cdaPeticao -> cdaPeticao.getDocumentoItemDividaAtivas().forEach(itemDividaAtiva -> {
            DebitoParcela debitoParcela = (DebitoParcela)this.debitoParcelaService.findByDebitoParcela(peticaoGerada.getEntidade(), itemDividaAtiva.getExercicioDebito(), itemDividaAtiva.getTipoCadastro(), itemDividaAtiva.getCadastroGeral(), itemDividaAtiva.getDivida().getDivida(), itemDividaAtiva.getSubDivida(), itemDividaAtiva.getParcela()).orElseThrow(() -> new EloValidationException("N\u00e2o foi poss\u00edvel encontrar a parcela para ser ajuizada"));
            debitoParcela.setSituacaoLegal(SituacaoLegal.JUIZO);
            debitoParcela.setDataSituacao(dataGeracao);
            debitoParcela.setDataAjuizamento(dataGeracao);
            this.debitoParcelaService.save((EloEntity)debitoParcela, null);
        }));
    }

    private Documento gerarPeticao(LotePeticaoItem lotePeticaoItem, Long entidade, Long exercicio, EntidadeTributacao entidadeTributacao, DocumentoTipo tipoDocumento, LocalDate dataGeracao) {
        Documento documento = new Documento();
        documento.setEntidade(entidade);
        documento.setExercicio(exercicio);
        documento.setDocumentoTipo(tipoDocumento);
        documento.setTipoDocumento(tipoDocumento.getId());
        documento.setEntidadeTributacao(entidadeTributacao);
        documento.setDataEmissao(dataGeracao);
        documento.setPessoa(lotePeticaoItem.getPessoa());
        documento.setCnpjCpf(lotePeticaoItem.getPessoa().getCnpjCpf());
        documento.setUsuario(SecurityUtils.getUserAise());
        documento.setSituacao(SituacaoDocumento.aberto());
        if (!lotePeticaoItem.hasPeticoesCadastrosDiferentes().booleanValue()) {
            Documento cda = ((LotePeticaoItemDetalhe)lotePeticaoItem.getDetalhes().get(0)).getDocumento();
            documento.setTipoCadastro(cda.getTipoCadastro());
            documento.setCadastroGeral(cda.getCadastroGeral());
            documento.setCodigoCadastroGeral(cda.getCodigoCadastroGeral());
        }
        documento.setCertidoesDividaAtivaPeticao(lotePeticaoItem.getDetalhes().stream().map(LotePeticaoItemDetalhe::getDocumento).collect(Collectors.toList()));
        return documento;
    }
}

