/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.domain.protesto.GeracaoProtestoErro;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.LoteCdaItemDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.repository.GeracaoProtestoErroRepository;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemRepository;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoteCdaService
extends CrudService<LoteCda, Long> {
    private final Logger logger = LoggerFactory.getLogger(LoteCdaService.class);
    private final DebitoRepository debitoRepository;
    private final ContextService contextService;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final LoteCdaRepository loteCdaRepository;
    private final LoteCdaItemRepository loteCdaItemRepository;
    private final LoteCdaItemService loteCdaItemService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final ResolversHandler resolversHandler;
    private final ProtestoService protestoService;
    private final DocumentoService documentoService;
    private final GeracaoProtestoErroRepository geracaoProtestoErroRepository;
    private final NotificacaoService notificacaoService;
    private final ParametroGeralService parametroGeralService;

    protected void beforeSave(LoteCda entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setChildrenId();
    }

    public void calcularAcrescimosGeracaoCda(LocalDate dataReferencia, List<LoteCdaItem> itens, Long entidade) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        itens.forEach(cda -> cda.getItemDetalhes().forEach(itemDetalhe -> {
            AcrescimoDTO acrescimo = AcrescimoDTO.of((LoteCdaItemDetalhe)itemDetalhe, (Long)formaPagamento.getId());
            acrescimo.setEntidade(entidade);
            acrescimo.setDataReferencia(dataReferencia);
            acrescimo.setCalculaValorDesconto(Boolean.FALSE);
            this.calculoAcrescimoService.calculaAcrescimos(acrescimo, Optional.empty());
            itemDetalhe.setValor(acrescimo.getValor());
            itemDetalhe.setValorMulta(acrescimo.getValorMulta());
            itemDetalhe.setValorJuros(acrescimo.getValorJuros());
            itemDetalhe.setValorCorrecao(acrescimo.getValorCorrecao());
        }));
    }

    public LoteCdaResumoDTO getResumo(Long id) {
        return (LoteCdaResumoDTO)this.loteCdaRepository.getResumo(id).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o lote com id: %d", id)));
    }

    public Page<LoteCdaItem> searchItens(Long id, String search, Pageable pageable) {
        String idClause = String.format("lote.id==%d", id);
        String searchWithIdClause = search.isEmpty() ? idClause : String.format("(%s) and (%s)", idClause, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), LoteCdaItem.class, (String)searchWithIdClause);
        return this.loteCdaItemRepository.findAll(specification, pageable);
    }

    public LoteCda gerarLoteSimulacao(String filtro) {
        this.validateDebitosNotFound(filtro);
        LoteCda loteCda = new LoteCda();
        loteCda.setDataSimulacao(LocalDate.now());
        loteCda.setSituacao(SituacaoLoteCda.GERANDO_SIMULACAO);
        loteCda.setUsuario(SecurityUtils.getUserAise());
        loteCda.setFiltro(filtro);
        return (LoteCda)this.loteCdaRepository.save((Object)loteCda);
    }

    private void validateDebitosNotFound(String filtro) {
        Long entidade = this.contextService.getEntidadePrincipal();
        if (this.debitoRepository.findDebitosGeracaoCDA(filtro, entidade).isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado nenhum d\u00e9bito para gerar uma certid\u00e3o de d\u00edvida ativa, verifique se os d\u00e9bitos j\u00e1 est\u00e3o inclusos em outras CDA's.");
        }
    }

    public boolean isCdasEmpty(Long idLote) {
        return ((LoteCda)this.loteCdaRepository.findOne((Object)idLote)).getItens().isEmpty();
    }

    public LoteCda getToGeracaoProtesto(Long idLote) {
        LoteCda loteCda = (LoteCda)this.loteCdaRepository.findById((Object)idLote).orElseThrow(() -> new EloValidationException(String.format("Lote de CDA com id: %d n\u00e3o foi encontrado!", idLote)));
        this.validateAllCdasCanceladas(loteCda);
        return loteCda;
    }

    private void validateAllCdasCanceladas(LoteCda loteCda) {
        if (loteCda.areAllCdasCancelados()) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel protestar o lote de CDA %d pois todas as CDA's do lote est\u00e3o canceladas", loteCda.getId()));
        }
    }

    public List<BigDecimal> getDebitoParcelaTributoInvalidoFromLoteCda(Long id) {
        if (Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_MAIS_DE_UMA_CDA_POR_DEBITO, ModuloEnum.MODULO_TRIBUTARIO.getValue()))) {
            return this.loteCdaRepository.findDebitoParcelaTributoInvalidoFromLoteCdaPermiteMaisDeUmaCDA(id);
        }
        if (Boolean.FALSE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_MAIS_DE_UMA_CDA_POR_DEBITO, ModuloEnum.MODULO_TRIBUTARIO.getValue()))) {
            return this.loteCdaRepository.findDebitoParcelaTributoInvalidoFromLoteCda(id);
        }
        return Collections.emptyList();
    }

    protected void beforeDelete(LoteCda entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (!this.canDelete(entity)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover lote com situa\u00e7\u00e3o igual a %s", entity.getSituacao().getDescricao()));
        }
    }

    private boolean canDelete(LoteCda lote) {
        return SituacaoLoteCda.ERRO_SIMULACAO.equals((Object)lote.getSituacao()) || SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)lote.getSituacao());
    }

    @Async
    @Transactional
    public void printCDALoteAgrupado(Long idLoteCda, String search, Sort sort, Integer totalCdas) {
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaImpressaoAgrupadaLoteCDA(idLoteCda);
        Long tarefa = execucao.getTarefaAssincrona().getId();
        UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
        Optional notificacaoId = this.notificacaoService.send("Iniciada gera\u00e7\u00e3o de PDF de CDA em lote", String.format("Iniciada a gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        this.groupArquivosLoteCDA(idLoteCda, search, sort, execucao, tarefa, userSecurityDTO, totalCdas, notificacaoId);
    }

    private void groupArquivosLoteCDA(Long idLoteCda, String search, Sort sort, TarefaAssincronaExecucao execucao, Long tarefa, UserSecurityDTO userSecurityDTO, Integer totalCdas, Optional<UUID> notificacaoId) {
        LoteCda loteCda = (LoteCda)this.getEm().getReference(LoteCda.class, (Object)idLoteCda);
        if (Objects.isNull(loteCda)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Lote CDA de id %d.", idLoteCda));
        }
        try {
            this.logger.info("Iniciando o agrupamento dos arquivos de Lote CDA");
            Page loteCdaItens = this.loteCdaItemService.findLoteCdaItem(loteCda.getId(), search, sort, totalCdas);
            ArquivoNovoRequest arquivoNovoRequest = this.getArquivoNovoRequest(loteCda.getId(), loteCdaItens);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            loteCda.setIdArquivoImpressao(arquivo.getId());
            loteCda.setDataImpressao(arquivo.getDataCriacao().toLocalDate());
            loteCda.setUsuarioImpressao(SecurityUtils.getUserAise());
            this.loteCdaRepository.save((Object)loteCda);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada gera\u00e7\u00e3o de PDF de CDA em lote", String.format("Finalizada com sucesso a gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            this.logger.info("Finalizado o agrupamento dos arquivos de Lote CDA e disponibilizado no S3");
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.logger.error("Erro ao agrupar arquivos de Lote CDA {} ", (Object)e.getMessage(), (Object)e);
            this.notificacaoService.send("Finalizada gera\u00e7\u00e3o de PDF de CDA em lote", String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    private ArquivoNovoRequest getArquivoNovoRequest(Long idLote, Page<LoteCdaItem> loteCdaItens) throws IOException {
        InputStream inputStream = this.mergeArquivosLoteCda(loteCdaItens);
        return this.uploadArquivoAgrupado(idLote, inputStream);
    }

    private ArquivoNovoRequest uploadArquivoAgrupado(Long idLote, InputStream inputStream) {
        String nomeArquivo = String.format("Lote_CDA_Agrupado_Numero_Lote_%d_%s", idLote, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
        return arquivoNovoRequest;
    }

    private InputStream mergeArquivosLoteCda(Page<LoteCdaItem> loteCdaItens) throws IOException {
        PDDocument document = new PDDocument();
        for (LoteCdaItem loteCdaItem : loteCdaItens) {
            PDFMergerUtility pdfMerge = new PDFMergerUtility();
            byte[] arquivoTemp = this.certidaoDividaAtivaService.printCertidaoDividaAtiva(loteCdaItem.getDocumento().getId());
            PDDocument pdfDocument = PDDocument.load((byte[])arquivoTemp);
            pdfMerge.appendDocument(document, pdfDocument);
            pdfDocument.close();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save((OutputStream)byteArrayOutputStream);
        document.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public String getUrlArquivoLoteCDA(String idArquivo) {
        try {
            UUID uuid = UUID.fromString(idArquivo);
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + uuid));
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception exception) {
            throw new EloValidationException("Falha ao fazer o download no arquivo.");
        }
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    public Protesto protestarLoteCda(LoteCdaItemDTO loteCdaItem, JobExecution jobExecution) {
        try {
            Documento documento = this.documentoService.findDocumentoByEntidadeAndExercicioAndTipoDocumentoAndDocumento(loteCdaItem.getEntidadeDocumento(), loteCdaItem.getExercicioDocumento(), loteCdaItem.getTipoDocumento(), loteCdaItem.getDocumento());
            Optional protestoGerado = this.protestoService.findByDocumento(documento);
            if (protestoGerado.isPresent()) {
                return null;
            }
            Long exercicio = this.contextService.getExercicioAtual();
            Protesto protesto = this.certidaoDividaAtivaService.createProtesto(documento.getId(), exercicio);
            protesto.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
            return protesto;
        }
        catch (Exception ex) {
            LoteCdaItem itemLoteCda = (LoteCdaItem)this.loteCdaItemService.findOne((Serializable)loteCdaItem.getIdLoteCdaItem());
            this.createGeracaoProtesotErro(jobExecution, ex, itemLoteCda);
            return null;
        }
    }

    @Transactional
    private void createGeracaoProtesotErro(JobExecution jobExecution, Exception ex, LoteCdaItem itemLoteCda) {
        GeracaoProtestoErro geracaoProtestoErro = new GeracaoProtestoErro();
        geracaoProtestoErro.setErro(ex.getMessage());
        geracaoProtestoErro.setLoteCdaItem(itemLoteCda);
        geracaoProtestoErro.setBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
        geracaoProtestoErro.setAtivo(Boolean.TRUE);
        this.geracaoProtestoErroRepository.save((Object)geracaoProtestoErro);
    }

    public void updateSituacaoLoteProtesto(SituacaoLoteCda situacaoLoteCda, Long idLote) {
        LoteCda loteCda = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
        loteCda.setSituacao(situacaoLoteCda);
        this.loteCdaRepository.save((Object)loteCda);
    }

    @Generated
    public LoteCdaService(DebitoRepository debitoRepository, ContextService contextService, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, LoteCdaRepository loteCdaRepository, LoteCdaItemRepository loteCdaItemRepository, LoteCdaItemService loteCdaItemService, TarefaAssincronaService tarefaAssincronaService, CertidaoDividaAtivaService certidaoDividaAtivaService, ResolversHandler resolversHandler, ProtestoService protestoService, DocumentoService documentoService, GeracaoProtestoErroRepository geracaoProtestoErroRepository, NotificacaoService notificacaoService, ParametroGeralService parametroGeralService) {
        this.debitoRepository = debitoRepository;
        this.contextService = contextService;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.loteCdaRepository = loteCdaRepository;
        this.loteCdaItemRepository = loteCdaItemRepository;
        this.loteCdaItemService = loteCdaItemService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.resolversHandler = resolversHandler;
        this.protestoService = protestoService;
        this.documentoService = documentoService;
        this.geracaoProtestoErroRepository = geracaoProtestoErroRepository;
        this.notificacaoService = notificacaoService;
        this.parametroGeralService = parametroGeralService;
    }
}

