/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.contencioso;

import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import br.com.elotech.tributos.service.contencioso.AcaoExararAbstract;
import br.com.elotech.tributos.service.contencioso.AcaoExararCancelarDebito;
import br.com.elotech.tributos.service.contencioso.AcaoExararManterDebito;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AcaoDeferirParcial
extends AcaoExararAbstract
implements AcaoExararCancelarDebito,
AcaoExararManterDebito {
    protected AcaoDeferirParcial(ContenciosoRepository contenciosoRepository, CancelamentoDebitoService cancelamentoDebitoService, DebitoParcelaService debitoParcelaService, SituacaoParcelaService situacaoParcelaService) {
        super(contenciosoRepository, cancelamentoDebitoService, debitoParcelaService, situacaoParcelaService);
    }

    public Contencioso exararCancelarDebito(ContenciosoDebitosExararDTO dto, Contencioso contencioso) {
        this.validaContenciosoEmAberto(contencioso);
        List contenciosoDebitosDTOSelected = dto.getDebitos().stream().filter(ContenciosoDebitoDTO::isSelected).collect(Collectors.toList());
        this.atualizaStatusDoContenciosoEParcelas(dto, contencioso, contenciosoDebitosDTOSelected);
        this.cancelaParcelaPorTributos(dto, contenciosoDebitosDTOSelected);
        this.encerraContenciosoSeNenhumDebitoAguardaParecer(contencioso);
        return (Contencioso)this.contenciosoRepository.save((Object)contencioso);
    }

    public Contencioso exararManterDebito(ContenciosoDebitosExararDTO dto, Contencioso contencioso) {
        this.validaContenciosoEmAberto(contencioso);
        List contenciosoDebitosDTOSelected = dto.getDebitos().stream().filter(ContenciosoDebitoDTO::isSelected).collect(Collectors.toList());
        this.atualizaStatusDoContenciosoEParcelas(dto, contencioso, contenciosoDebitosDTOSelected);
        this.encerraContenciosoSeNenhumDebitoAguardaParecer(contencioso);
        return (Contencioso)this.contenciosoRepository.save((Object)contencioso);
    }

    private void cancelaParcelaPorTributos(ContenciosoDebitosExararDTO dto, List<ContenciosoDebitoDTO> contenciosoDebitosDTOSelected) {
        CancelamentoTributosFormDTO cancelamentoTributosDTO = CancelamentoTributosFormDTO.from((ContenciosoDebitosExararDTO)dto);
        contenciosoDebitosDTOSelected.stream().flatMap(debitoDTO -> debitoDTO.getParcelasParcial().stream().filter(CancelamentoDebitoTributoDTO::isSelected)).forEach(parcelaParcial -> cancelamentoTributosDTO.getParcelas().add(parcelaParcial));
        if (SituacaoContenciosoDebito.DEFPARCIAL.equals((Object)dto.getParecer())) {
            this.cancelamentoDebitoService.cancelamentoDebitoPorTributo(cancelamentoTributosDTO);
        }
    }
}

