/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.comunicado;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoFiltroNotificacaoComunicado;
import br.com.elotech.tributos.domain.TipoNotificacaoComunicado;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.ComunicadoDto;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SituacaoComunicado;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.simam.NotificacaoComunicadoContribuinteDTO;
import br.com.elotech.tributos.report.loader.ComunicadoParamLoader;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BatchService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ComunicadoService
extends CrudService<Comunicado, ComunicadoId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComunicadoService.class);
    private final ComunicadoRepository comunicadoRepository;
    private final ComunicadoCadastroRepository comunicadoCadastroRepository;
    private final ComunicadoCadastroService comunicadoCadastroService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final ResolversHandler resolversHandler;
    private final NotificacaoService notificacaoService;
    private final BatchService batchService;
    private final AiseRelatorioService aiseRelatorioService;
    private final ComunicadoParamLoader comunicadoParamLoader;

    public Page<ComunicadoDto> search(String search, Pageable pageable) {
        return this.findByRsql(search, pageable).map(ComunicadoDto::from);
    }

    public ComunicadoDto findComunicadoDTOById(ComunicadoId comunicadoId) {
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", comunicadoId.getEntidade(), comunicadoId.getExercicio(), comunicadoId.getIdComunicado()));
        }
        ComunicadoDto comunicadoDTO = ComunicadoDto.from((Comunicado)comunicado);
        BatchJobExecution batchJobExecution = comunicado.getBatchJobExecutionComunicado();
        if (Objects.isNull(batchJobExecution)) {
            return comunicadoDTO;
        }
        JobParameters jobParameters = this.batchService.getJobParametersById(batchJobExecution.getId());
        comunicadoDTO.setJobParameters(jobParameters);
        return comunicadoDTO;
    }

    public void validateEnderecosGlobais(Long entidade, Long exercicio, Long idComunicado) throws Exception {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", entidade, exercicio, idComunicado));
        }
        if (SituacaoComunicado.CANCELADO.equals((Object)comunicado.getSituacao())) {
            throw new EloValidationException("Este comunicado j\u00e1 foi cancelado");
        }
    }

    public Comunicado cancelComunicado(Long entidade, Long exercicio, Long idComunicado) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", entidade, exercicio, idComunicado));
        }
        if (SituacaoComunicado.CANCELADO.equals((Object)comunicado.getSituacao())) {
            throw new EloValidationException("Este comunicado j\u00e1 foi cancelado");
        }
        this.comunicadoCadastroRepository.updateComunicadoCadastrosSituacao(entidade, exercicio, idComunicado, SituacaoComunicadoCadastro.CANCELADO, SituacaoComunicadoCadastro.CANCELADO.getDescricao());
        this.comunicadoRepository.updateComunicadoSituacaoCancelado(entidade, exercicio, idComunicado);
        comunicado.setSituacao(SituacaoComunicado.CANCELADO);
        return comunicado;
    }

    @Async
    @Transactional
    public void printLoteComunicado(Long entidade, Long exercicio, Long idComunicado, String search, Sort sort) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaImpressaoLoteComunicado(comunicadoId.toString());
        Long tarefa = execucao.getTarefaAssincrona().getId();
        UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Iniciada a gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findById((Object)ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado)).orElseThrow(() -> new EloValidationException(String.format("Comunicado com ID %s n\u00e3o encontrado", comunicadoId)));
        List comunicadosCadastro = this.comunicadoCadastroService.findByRsql(entidade, exercicio, idComunicado, search, sort);
        if (TipoFiltroNotificacaoComunicado.CONTRIBUINTE.equals((Object)comunicado.getTipoNotificacao().getTipoFiltro())) {
            this.imprimeLoteComunicadoInformacoesAgrupadas(comunicado, comunicadosCadastro, execucao, tarefa, userSecurityDTO, notificacaoId);
        } else {
            this.groupArquivosLoteComunicado(comunicadosCadastro, comunicadoId, execucao, tarefa, userSecurityDTO, notificacaoId);
        }
    }

    public String getUrlArquivoLoteComunicado(Long entidade, Long exercicio, Long idComunicado) {
        try {
            Comunicado comunicado = (Comunicado)this.comunicadoRepository.findById((Object)ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado)).orElseThrow(() -> new EloValidationException("Comunicado n\u00e3o encontrado"));
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + comunicado.getIdArquivoImpressao()));
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception ex) {
            throw new EloValidationException("Falha ao recuperar URL de download do arquivo." + ex.getMessage());
        }
    }

    public void notificarTodos(NotificacaoComunicadoContribuinteDTO notificacaoDTO) {
        if (Objects.isNull(notificacaoDTO.getIdComunicado())) {
            throw new EloValidationException("O id do comunicado \u00e9 obrigat\u00f3rio");
        }
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findById((Object)ComunicadoId.of((Long)notificacaoDTO.getEntidade(), (Long)notificacaoDTO.getExercicio(), (Long)notificacaoDTO.getIdComunicado())).orElseThrow(() -> new EloValidationException("Comunicado n\u00e3o encontrado"));
        comunicado.getCadastros().forEach(comunicadoCadastro -> {
            if (Objects.nonNull(comunicadoCadastro.getPessoa())) {
                Pessoa pessoa = comunicadoCadastro.getPessoa();
                this.notificacaoService.send("Notifica\u00e7\u00e3o de Comunicado", notificacaoDTO.getMensagem(), pessoa.getCnpjCpf(), Optional.empty(), NotificationStatus.COMPLETED, Boolean.TRUE, "");
            }
        });
    }

    public void notificarPorContribuinte(NotificacaoComunicadoContribuinteDTO notificacaoDTO) {
        if (Objects.isNull(notificacaoDTO.getIdComunicado())) {
            throw new EloValidationException("O id do comunicado \u00e9 obrigat\u00f3rio");
        }
        notificacaoDTO.getSequencias().forEach(sequencia -> {
            try {
                ComunicadoCadastro comunicadoCadastro = (ComunicadoCadastro)this.comunicadoCadastroRepository.findById((Object)ComunicadoCadastroId.of((Long)notificacaoDTO.getEntidade(), (Long)notificacaoDTO.getExercicio(), (Long)notificacaoDTO.getIdComunicado(), (Long)sequencia.getSequencia())).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comunicado Cadastro n\u00e3o encontrado"));
                if (Objects.nonNull(comunicadoCadastro.getPessoa())) {
                    Pessoa pessoa = comunicadoCadastro.getPessoa();
                    this.notificacaoService.send("Notifica\u00e7\u00e3o de Comunicado", notificacaoDTO.getMensagem(), pessoa.getCnpjCpf(), Optional.empty(), NotificationStatus.COMPLETED, Boolean.TRUE, "");
                }
            }
            catch (Exception ex) {
                log.error("Erro ao notificar contribuinte", (Throwable)ex);
            }
        });
    }

    private void groupArquivosLoteComunicado(List<ComunicadoCadastro> comunicadosCadastro, ComunicadoId comunicadoId, TarefaAssincronaExecucao execucao, Long tarefa, UserSecurityDTO userSecurityDTO, Optional<UUID> notificacaoId) {
        if (Objects.isNull(comunicadosCadastro)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Lote de Comunicado de id %s.", comunicadoId.toString()));
        }
        try {
            log.info("Iniciando o agrupamento dos arquivos de Lote de Comunicado");
            ArquivoNovoRequest arquivoNovoRequest = this.getArquivoNovoRequest(comunicadoId.toString(), comunicadosCadastro);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            comunicadosCadastro.forEach(comunicadoCadastro -> {
                comunicadoCadastro.getId().getComunicado().setIdArquivoImpressao(arquivo.getId());
                comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.IMPRESSO);
                comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.IMPRESSO.getDescricao());
            });
            this.comunicadoCadastroRepository.saveAll(comunicadosCadastro);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Finalizada com sucesso a gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            log.info("Finalizado o agrupamento dos arquivos de Lote de Comunicado e disponibilizado no S3");
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.notificacaoService.send("Erro na Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
            log.error("Erro ao agrupar arquivos de Lote de Comunicado {} ", (Object)e.getMessage(), (Object)e);
        }
    }

    private ArquivoNovoRequest getArquivoNovoRequest(String comunicadoId, List<ComunicadoCadastro> comunicadosCadastro) throws IOException {
        InputStream inputStream = this.groupArquivosLoteComunicado(comunicadosCadastro);
        return this.uploadArquivoAgrupado(comunicadoId, inputStream);
    }

    private ArquivoNovoRequest getArquivoNovoRequestAgrupado(Comunicado comunicado) {
        try {
            InputStream inputStream = this.groupLoteComunicadoAgrupado(comunicado);
            return this.uploadArquivoAgrupado(comunicado.getId().toString(), inputStream);
        }
        catch (IOException e) {
            log.error("Erro ao gerar relat\u00f3rio agrupado no m\u00e9todo getArquivoNovoRequestAgrupado", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ArquivoNovoRequest uploadArquivoAgrupado(String comunicadoId, InputStream inputStream) {
        String nomeArquivo = String.format("Comunicado_Lote_%s_%s", comunicadoId, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
    }

    private InputStream groupArquivosLoteComunicado(List<ComunicadoCadastro> comunicadosCadastro) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        try (PDDocument document = new PDDocument();){
            for (ComunicadoCadastro comunicadoCadastro : comunicadosCadastro) {
                PDFMergerUtility pdfMerge = new PDFMergerUtility();
                byte[] arquivoTemp = this.comunicadoCadastroService.print(comunicadoCadastro.getId().getComunicado().getId().getEntidade(), comunicadoCadastro.getId().getComunicado().getId().getExercicio(), comunicadoCadastro.getId().getComunicado().getId().getIdComunicado(), comunicadoCadastro.getId().getSequencia());
                PDDocument pdfDocument = PDDocument.load((byte[])arquivoTemp);
                pdfMerge.appendDocument(document, pdfDocument);
                pdfDocument.close();
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            document.save((OutputStream)byteArrayOutputStream);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private InputStream groupLoteComunicadoAgrupado(Comunicado comunicado) throws IOException {
        PDDocument document = new PDDocument();
        byte[] arquivoTemp = this.printComunicadoAgrupado(comunicado);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(arquivoTemp);
        PDDocument pdfDocument = PDDocument.load((InputStream)inputStream);
        for (int i = 0; i < pdfDocument.getNumberOfPages(); ++i) {
            document.addPage(pdfDocument.getPage(i));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save((OutputStream)byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public TipoFiltroNotificacaoComunicado findTipoFiltroNotificacaoByComunicadoId(ComunicadoId id) {
        return this.comunicadoRepository.findTipoFiltroNotificacaoByComunicadoId(id);
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    private void imprimeLoteComunicadoInformacoesAgrupadas(Comunicado comunicado, List<ComunicadoCadastro> comunicadosCadastro, TarefaAssincronaExecucao execucao, Long tarefa, UserSecurityDTO userSecurityDTO, Optional<UUID> notificacaoId) {
        try {
            log.info("Iniciando o agrupamento dos arquivos de Lote de Comunicado");
            ArquivoNovoRequest arquivoNovoRequest = this.getArquivoNovoRequestAgrupado(comunicado);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            this.updateComunicadosCadastroAsImpresso(comunicadosCadastro);
            this.updateIdArquivoImpressaoPorContribuinte(comunicado, arquivo);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Finalizada com sucesso a gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            log.info("Finalizado o agrupamento dos arquivos de Lote de Comunicado e disponibilizado no S3");
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.notificacaoService.send("Erro na Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
            log.error("Erro ao agrupar arquivos de Lote de Comunicado {} ", (Object)e.getMessage(), (Object)e);
        }
    }

    public byte[] printComunicadoAgrupado(Comunicado comunicado) {
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar o Lote de Comunicado.");
        }
        byte[] file = this.aiseRelatorioService.imprimirRelatorioGenerico(this.buildReportFilters(comunicado));
        if (ArrayUtils.isEmpty((byte[])file)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel imprimir o comunicado.");
        }
        return file;
    }

    private Relatorio getRelatorio(Comunicado comunicado) {
        return Optional.ofNullable(comunicado).map(Comunicado::getTipoNotificacao).map(TipoNotificacaoComunicado::getRelatorio).orElseThrow(() -> new EloValidationException("Comunicado sem relat\u00f3rio informado"));
    }

    private ImprimirRelatorioDTO buildReportFilters(Comunicado comunicado) {
        Relatorio relatorio = this.getRelatorio(comunicado);
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio.getId().getRelatorio());
        dto.setModulo(relatorio.getId().getModulo());
        dto.setTipoRelatorio(TipoRelatorio.fromValue((String)relatorio.getTipoRelatorio().getValue()));
        dto.setFiltro(String.format(" b.exercicio = %d and b.idComunicado = %d ", comunicado.getId().getExercicio(), comunicado.getId().getIdComunicado()));
        dto.setListParametros(this.comunicadoParamLoader.load());
        dto.setSubReports(this.createSubReport(dto.getFiltro()));
        return dto;
    }

    private SubReportDTO createSubReport(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Bloqueto", filtro), new SubReportItemDTO("Setor", filtro)}));
        return subReportDTO;
    }

    private void updateComunicadosCadastroAsImpresso(List<ComunicadoCadastro> comunicadosCadastro) {
        comunicadosCadastro.forEach(comunicadoCadastro -> {
            comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.IMPRESSO);
            comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.IMPRESSO.getDescricao());
        });
        this.comunicadoCadastroRepository.saveAll(comunicadosCadastro);
    }

    private void updateIdArquivoImpressaoPorContribuinte(Comunicado comunicado, Arquivo arquivo) {
        comunicado.setIdArquivoImpressao(arquivo.getId());
        this.comunicadoRepository.save((Object)comunicado);
    }

    @Generated
    public ComunicadoService(ComunicadoRepository comunicadoRepository, ComunicadoCadastroRepository comunicadoCadastroRepository, ComunicadoCadastroService comunicadoCadastroService, TarefaAssincronaService tarefaAssincronaService, ResolversHandler resolversHandler, NotificacaoService notificacaoService, BatchService batchService, AiseRelatorioService aiseRelatorioService, ComunicadoParamLoader comunicadoParamLoader) {
        this.comunicadoRepository = comunicadoRepository;
        this.comunicadoCadastroRepository = comunicadoCadastroRepository;
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.resolversHandler = resolversHandler;
        this.notificacaoService = notificacaoService;
        this.batchService = batchService;
        this.aiseRelatorioService = aiseRelatorioService;
        this.comunicadoParamLoader = comunicadoParamLoader;
    }
}

