/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.comunicado;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.TipoNotificacaoComunicado;
import br.com.elotech.tributos.dto.ComunicadoServiceDTO;
import br.com.elotech.tributos.enums.OrigemComunicado;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.TipoNotificacaoComunicadoService;
import br.com.elotech.tributos.service.comunicado.ValidacaoComunicadoService;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoGeracaoCdaJobStarter {
    private static final String ID_SIMULACAO = "idLoteSimulacao";
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final ContextService contextService;
    @Qualifier(value="comunicadoGeracaoCdaBatchJob")
    private final Job comunicadoGeracaoCdaBatchJob;
    private final ComunicadoRepository comunicadoRepository;
    private final TipoNotificacaoComunicadoService tipoNotificacaoComunicadoService;
    private final ValidacaoComunicadoService validacaoComunicadoService;

    public JobExecution startJob(ComunicadoServiceDTO comunicadoServiceDTO) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.COMUNICADO_GERACAO_CDA.getTipo()).stream().anyMatch(job -> comunicadoServiceDTO.getIdentificador().get(ID_SIMULACAO).equals(Objects.requireNonNull(job.getJobParameters().getLong(ID_SIMULACAO))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        ComunicadoId idComunicado = new ComunicadoId();
        idComunicado.setEntidade(this.contextService.getEntidadePrincipal());
        idComunicado.setExercicio(this.contextService.getExercicioAtual());
        TipoNotificacaoComunicado tipoNotificacao = this.tipoNotificacaoComunicadoService.findById((Serializable)comunicadoServiceDTO.getTipoNotificacao().getId()).orElse(null);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(idComunicado);
        comunicado.setDescricao(comunicadoServiceDTO.getDescricao());
        if (Objects.nonNull(tipoNotificacao)) {
            comunicado.setTipoNotificacao(tipoNotificacao);
            comunicado.setRelatorio(tipoNotificacao.getRelatorio());
        }
        comunicado.setDataValidade(comunicadoServiceDTO.getDataValidade());
        comunicado.setDataGeracao(comunicadoServiceDTO.getDataGeracao());
        comunicado.setUsuario(comunicadoServiceDTO.getUsuario());
        comunicado.setOrigem(OrigemComunicado.GERACAO_CDA);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        this.validacaoComunicadoService.validaParametroComunicadoDuplicado(jobParametersBuilder, comunicadoServiceDTO);
        comunicado = (Comunicado)this.comunicadoRepository.save((Object)comunicado);
        jobParametersBuilder.addLong(ID_SIMULACAO, Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get(ID_SIMULACAO))));
        jobParametersBuilder.addLong("entidade", idComunicado.getEntidade());
        jobParametersBuilder.addLong("idComunicado", comunicado.getId().getIdComunicado());
        jobParametersBuilder.addLong("exercicioComunicado", idComunicado.getExercicio());
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.comunicadoGeracaoCdaBatchJob, jobParametersBuilder.toJobParameters());
    }

    @Generated
    public ComunicadoGeracaoCdaJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, ContextService contextService, Job comunicadoGeracaoCdaBatchJob, ComunicadoRepository comunicadoRepository, TipoNotificacaoComunicadoService tipoNotificacaoComunicadoService, ValidacaoComunicadoService validacaoComunicadoService) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.contextService = contextService;
        this.comunicadoGeracaoCdaBatchJob = comunicadoGeracaoCdaBatchJob;
        this.comunicadoRepository = comunicadoRepository;
        this.tipoNotificacaoComunicadoService = tipoNotificacaoComunicadoService;
        this.validacaoComunicadoService = validacaoComunicadoService;
    }
}

