/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.executors.implementations;

import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.dto.parcelamento.AiseEstornoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroEstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.agendamentorotina.executors.AgendamentoRotinaExecutorImpl;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import br.com.elotech.tributos.service.ws.AiseEstornoParcelamentoService;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class EstornoParcelamentoExecutor
extends AgendamentoRotinaExecutorImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoParcelamentoExecutor.class);
    private final ParcelamentoService parcelamentoService;
    private final AiseEstornoParcelamentoService aiseEstornoParcelamentoService;
    private final List<AgendamentoRotinaNotifier> notifiers;

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.ESTORNO_PARCELAMENTO.equals((Object)agendamentoRotina.getRotina());
    }

    public void execute(AgendamentoRotina agendamentoRotina) {
        FiltroEstornoParcelamentoEmLoteDTO filtro = (FiltroEstornoParcelamentoEmLoteDTO)this.parseFilter(agendamentoRotina.getParametros());
        List estornos = this.parcelamentoService.filtroEstornoParcelamentoEmLote(filtro, (Pageable)PageRequest.of((int)0, (int)999)).map(estorno -> this.buildAiseEstornoParcelamentoDTO(estorno, filtro)).getContent();
        estornos = this.estornarParcelamentoEmLote(estornos);
        this.getNotifier(agendamentoRotina).notify(agendamentoRotina, (Object)estornos);
    }

    public List<AgendamentoRotinaNotifier> getNotifiers() {
        return this.notifiers;
    }

    protected Object parseFilter(Map<String, String> param) {
        FiltroEstornoParcelamentoEmLoteDTO filtros = new FiltroEstornoParcelamentoEmLoteDTO();
        param.forEach((key, value) -> this.setField((Object)filtros, key, value));
        filtros.setDataDoFimDoParcelamento(LocalDate.now());
        return filtros;
    }

    private AiseEstornoParcelamentoDTO buildAiseEstornoParcelamentoDTO(EstornoParcelamentoEmLoteDTO estorno, FiltroEstornoParcelamentoEmLoteDTO filtro) {
        AiseEstornoParcelamentoDTO dto = new AiseEstornoParcelamentoDTO();
        dto.setIdParcelamento(estorno.getIdParcelamento());
        dto.setRetornaOrigem(filtro.getEstornaOrigem());
        dto.setMotivo(filtro.getMotivo());
        return dto;
    }

    public List<AiseEstornoParcelamentoDTO> estornarParcelamentoEmLote(List<AiseEstornoParcelamentoDTO> estornos) {
        return estornos.stream().map(estorno -> {
            try {
                estorno = this.aiseEstornoParcelamentoService.estornarParcelamento(estorno);
            }
            catch (Exception e) {
                log.error("N\u00e3o foi poss\u00edvel estornar o contrato {}. Retorno do WebService: {}", new Object[]{estorno.getIdParcelamento(), e.getMessage(), e});
            }
            return estorno;
        }).collect(Collectors.toList());
    }

    @Generated
    public EstornoParcelamentoExecutor(ParcelamentoService parcelamentoService, AiseEstornoParcelamentoService aiseEstornoParcelamentoService, List<AgendamentoRotinaNotifier> notifiers) {
        this.parcelamentoService = parcelamentoService;
        this.aiseEstornoParcelamentoService = aiseEstornoParcelamentoService;
        this.notifiers = notifiers;
    }
}

