/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo.correcao;

import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoCorrecao;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoException;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculoCorrecaoUtils {
    private CalculoCorrecaoUtils() {
    }

    public static LocalDate novaDataPagamento(FormaCorrecao formaCorrecao, LocalDate dataBaseCalculo, LocalDate dataRerefencia) {
        if (formaCorrecao.getMeses() == 0L || TipoCorrecao.INDICE_MENSAL_ACUMULADO.equals((Object)formaCorrecao.getTipoCorrecao())) {
            return dataRerefencia;
        }
        LocalDate retorno = dataBaseCalculo;
        while (!retorno.plusMonths(formaCorrecao.getMeses()).isAfter(dataRerefencia)) {
            retorno = retorno.plusMonths(formaCorrecao.getMeses());
        }
        if (retorno.getMonthValue() == dataBaseCalculo.getMonthValue()) {
            retorno = retorno.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        }
        return retorno;
    }

    public static ValorIndice getUltimoValorIndice(IndiceComposto indiceComposto, LocalDate dataBaseCalculo, LocalDate dataRerefencia) {
        LocalDate dataLimite = indiceComposto.getDataFinal().isBefore(dataRerefencia) ? indiceComposto.getDataFinal() : dataRerefencia;
        return Optional.ofNullable(indiceComposto.getIndiceCorrecao().getUltimoValorIndiceByData(dataLimite)).orElseThrow(() -> CalculoCorrecaoException.valorIndiceNotDefined((LocalDate)dataBaseCalculo, (IndiceCorrecao)indiceComposto.getIndiceCorrecao()));
    }

    public static ValorIndice getValorByIndiceCorrecao(IndiceComposto indiceComposto, LocalDate dataBaseCalculo) {
        return Optional.ofNullable(indiceComposto.getIndiceCorrecao().getValorIndiceByData(dataBaseCalculo)).orElseThrow(() -> CalculoCorrecaoException.valorIndiceNotDefined((LocalDate)dataBaseCalculo, (IndiceCorrecao)indiceComposto.getIndiceCorrecao()));
    }

    public static LocalDate getDataBaseIndiceMensal(LocalDate dataVencimento, LocalDate dataPagamento, Boolean primeiroDiaProximoMes) {
        LocalDate d1 = primeiroDiaProximoMes != false ? dataVencimento.plusMonths(1L).withDayOfMonth(1) : dataVencimento.plusMonths(1L);
        return d1.plusMonths(1L).isBefore(dataPagamento) ? d1 : dataPagamento;
    }

    public static IndiceComposto getIndiceCompostoByData(FormaCorrecao formaCorrecao, LocalDate dataBaseCalculo) {
        return formaCorrecao.getIndices().stream().filter(indice -> !dataBaseCalculo.isBefore(indice.getDataInicial()) && !dataBaseCalculo.isAfter(indice.getDataFinal())).findFirst().orElseThrow(() -> CalculoCorrecaoException.periodoFormaCorrecaoNotDefined((FormaCorrecao)formaCorrecao, (LocalDate)dataBaseCalculo));
    }

    public static ValorIndice getValorIndice(FormaCorrecao formaCorrecao, IndiceComposto lastIndiceComposto, IndiceComposto indiceComposto, LocalDate dataBaseCalculo) {
        if (Objects.isNull(indiceComposto)) {
            throw CalculoCorrecaoException.periodoFormaCorrecaoNotDefined((FormaCorrecao)formaCorrecao, (LocalDate)dataBaseCalculo);
        }
        if (Objects.nonNull(lastIndiceComposto) && !lastIndiceComposto.equals((Object)indiceComposto) && indiceComposto.getSobreporPeriodo().booleanValue()) {
            return CalculoCorrecaoUtils.getValorByIndiceCorrecao((IndiceComposto)lastIndiceComposto, (LocalDate)dataBaseCalculo);
        }
        return CalculoCorrecaoUtils.getValorByIndiceCorrecao((IndiceComposto)indiceComposto, (LocalDate)dataBaseCalculo);
    }

    public static BigDecimal converteMoeda(BigDecimal valor, LocalDate dataLancamento, LocalDate dataVencimento, FormaCorrecao formaCorrecao) {
        LocalDate dataParaCalculo = formaCorrecao.getTipoCorrecao().equals((Object)TipoCorrecao.DATA_LANCAMENTO) ? dataLancamento : dataVencimento;
        IndiceComposto indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)formaCorrecao, (LocalDate)dataParaCalculo);
        ValorIndice valorIndice = Optional.ofNullable(indiceComposto.getIndiceCorrecao().getUltimoValorIndiceByData(dataParaCalculo)).orElseThrow(() -> CalculoCorrecaoException.valorIndiceNotFound((LocalDate)dataParaCalculo));
        return valor.multiply(valorIndice.getValor());
    }

    public static BigDecimal aplicaCorrecaoMonetaria(MudancaMonetaria mudancaMonetaria, BigDecimal valor, LocalDate dataVencimento, LocalDate dataReferencia) {
        boolean deveAplicarCorrecao;
        boolean bl = deveAplicarCorrecao = mudancaMonetaria.getValorMonetario().compareTo(BigDecimal.ZERO) > 0 && mudancaMonetaria.getData().isAfter(dataVencimento) && mudancaMonetaria.getData().compareTo(dataReferencia) <= 0;
        if (!deveAplicarCorrecao) {
            return valor;
        }
        return valor.divide(mudancaMonetaria.getValorMonetario(), (int)CalculoValoresConstants.DEZESSEIS_CASAS_DECIMAIS, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal converteMoedaOuAplicaMudanca(BigDecimal valor, LocalDate dataVencimento, LocalDate dataReferencia, FormaCorrecao formaCorrecao, List<MudancaMonetaria> mudancasMonetarias) {
        if (formaCorrecao.getConverteMoeda().booleanValue()) {
            return CalculoCorrecaoUtils.converteMoeda((BigDecimal)valor, (LocalDate)dataVencimento, (LocalDate)dataReferencia, (FormaCorrecao)formaCorrecao);
        }
        return mudancasMonetarias.stream().reduce(valor, (valorAtual, mudanca) -> CalculoCorrecaoUtils.aplicaCorrecaoMonetaria((MudancaMonetaria)mudanca, (BigDecimal)valorAtual, (LocalDate)dataVencimento, (LocalDate)dataReferencia), BigDecimal::add);
    }
}

