/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.extractor.AttributeGetterResult;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.LogradouroTestadaExercicio;
import br.com.elotech.tributos.dto.LogradouroBatchUpdateDTO;
import br.com.elotech.tributos.enums.TipoAlteracaoEnum;
import br.com.elotech.tributos.repository.LogradouroTestadaExercicioRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class LogradouroTestadaExercicioService
extends CrudService<LogradouroTestadaExercicio, Long> {
    private final LogradouroTestadaExercicioRepository repository;

    private void updateLogradourosValor(Page<LogradouroTestadaExercicio> logradouroTestadasExercicios, Double valorIPTU, Double valorITBI, Double outrosValores, Double larguraRua) {
        logradouroTestadasExercicios.forEach(logradouroTestadasExercicio -> {
            if (valorIPTU != null) {
                logradouroTestadasExercicio.setValorTerreno(BigDecimal.valueOf(valorIPTU));
            }
            if (valorITBI != null) {
                logradouroTestadasExercicio.setValorTerrenoITBI(BigDecimal.valueOf(valorITBI));
            }
            if (outrosValores != null) {
                logradouroTestadasExercicio.setValorTerrenoOutro(BigDecimal.valueOf(outrosValores));
            }
            if (larguraRua != null) {
                logradouroTestadasExercicio.setLarguraRua(BigDecimal.valueOf(larguraRua));
            }
        });
    }

    private void updateLogradourosPercentual(Page<LogradouroTestadaExercicio> logradouroTestadasExercicios, Double valorIPTU, Double valorITBI, Double outrosValores, Double larguraRua) {
        logradouroTestadasExercicios.forEach(logradouroTestadasExercicio -> {
            if (valorIPTU != null) {
                BigDecimal valorTerreno = logradouroTestadasExercicio.getValorTerreno();
                logradouroTestadasExercicio.setValorTerreno(BigDecimal.valueOf(valorIPTU).divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_EVEN).multiply(valorTerreno).add(valorTerreno));
            }
            if (valorITBI != null) {
                BigDecimal valorTerrenoITBI = logradouroTestadasExercicio.getValorTerrenoITBI();
                logradouroTestadasExercicio.setValorTerrenoITBI(BigDecimal.valueOf(valorITBI).divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_EVEN).multiply(valorTerrenoITBI).add(valorTerrenoITBI));
            }
            if (outrosValores != null) {
                BigDecimal valorOutrosValores = logradouroTestadasExercicio.getValorTerrenoOutro();
                logradouroTestadasExercicio.setValorTerrenoOutro(BigDecimal.valueOf(outrosValores).divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_EVEN).multiply(valorOutrosValores).add(valorOutrosValores));
            }
        });
    }

    public void validateBatchUpdateSearch(String search) {
        List filtroExercicio = RsqlUtils.getFieldValues((String)search, (String)"exercicio");
        if (filtroExercicio.isEmpty()) {
            throw new EloValidationException("\u00c9 necessario filtrar por algum exerc\u00edcio para realizar a edi\u00e7\u00e3o!");
        }
        if (Integer.parseInt(((AttributeGetterResult)filtroExercicio.get(0)).getValue()) < LocalDate.now().getYear() || ((AttributeGetterResult)filtroExercicio.get(0)).getOperator().equals("!=")) {
            throw new EloValidationException("\u00c9 necessario filtrar por algum exerc\u00edcio igual ou maior que o atual!");
        }
    }

    public void batchUpdate(LogradouroBatchUpdateDTO logradouroBatchUpdateDTO, Page<LogradouroTestadaExercicio> logradouroTestadaExercicios) {
        if (Objects.equals(logradouroBatchUpdateDTO.getTipoAlteracao(), TipoAlteracaoEnum.VALOR)) {
            this.updateLogradourosValor(logradouroTestadaExercicios, logradouroBatchUpdateDTO.getValorTerrenoIPTU(), logradouroBatchUpdateDTO.getValorTerrenoITBI(), logradouroBatchUpdateDTO.getOutrosValores(), logradouroBatchUpdateDTO.getLarguraRua());
        } else if (Objects.equals(logradouroBatchUpdateDTO.getTipoAlteracao(), TipoAlteracaoEnum.PERCENTUAL)) {
            this.updateLogradourosPercentual(logradouroTestadaExercicios, logradouroBatchUpdateDTO.getValorTerrenoIPTU(), logradouroBatchUpdateDTO.getValorTerrenoITBI(), logradouroBatchUpdateDTO.getOutrosValores(), logradouroBatchUpdateDTO.getLarguraRua());
        }
        this.repository.saveAll(logradouroTestadaExercicios);
    }

    @Generated
    public LogradouroTestadaExercicioService(LogradouroTestadaExercicioRepository repository) {
        this.repository = repository;
    }
}

