/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.AlvaraLocalizacaoDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AlvaraLocalizacaoService {
    private final DocumentoService documentoService;
    private final ParametroGeralService parametroGeralService;
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final GeraDocumentoService geraDocumentoService;
    private final CadastroGeralRepository cadastroGeralRepository;

    public AlvaraLocalizacaoService(DocumentoService documentoService, ParametroGeralService parametroGeralService, CadastroMobiliarioService cadastroMobiliarioService, GeraDocumentoService geraDocumentoService, PessoaService pessoaService, CadastroGeralRepository cadastroGeralRepository) {
        this.documentoService = documentoService;
        this.parametroGeralService = parametroGeralService;
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.geraDocumentoService = geraDocumentoService;
        this.cadastroGeralRepository = cadastroGeralRepository;
    }

    public AlvaraLocalizacaoDTO getInitialValues(@Valid DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        CadastroMobiliario cadastroMobiliario;
        Boolean isPorContribuinte = documentoSearchInitialValuesDTO.getTipoFiltro().isPorContribuinte();
        AlvaraLocalizacaoDTO valoresIniciais = new AlvaraLocalizacaoDTO();
        valoresIniciais.setPessoa(isPorContribuinte != false ? this.getContribuinteFromRequest(documentoSearchInitialValuesDTO) : this.getPessoaFromRequest(documentoSearchInitialValuesDTO));
        if (documentoSearchInitialValuesDTO.getIdCadastro() != null && Objects.nonNull(cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioService.findOne((Serializable)documentoSearchInitialValuesDTO.getIdCadastro()))) {
            valoresIniciais.setExercicioProcesso(cadastroMobiliario.getExercicioProcessoAbertura());
            valoresIniciais.setIdProcesso(cadastroMobiliario.getIdProcessoAbertura());
        }
        return valoresIniciais;
    }

    private Pessoa getContribuinteFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return documentoSearchInitialValuesDTO.getContribuinte();
    }

    private Pessoa getPessoaFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ((CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoSearchInitialValuesDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoSearchInitialValuesDTO.getIdCadastro())))).getPessoa();
    }

    public DocumentoDTO save(@Valid AlvaraLocalizacaoDTO alvaraLocalizacaoDTO) {
        CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioService.findById((Serializable)alvaraLocalizacaoDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastro mobili\u00e1rio com id %d.", alvaraLocalizacaoDTO.getIdCadastro())));
        SituacaoMobiliario situacaoMobiliario = cadastroMobiliario.getSituacaoAtual();
        if (situacaoMobiliario.getTipoSituacaoMobiliario().isDesatualizado().booleanValue()) {
            throw new EloValidationException(String.format("Cadastro %s: %d est\u00e1 com situa\u00e7\u00e3o \"%s\"!", cadastroMobiliario.getTipoCadastro().getDescricao(), cadastroMobiliario.getCadastroGeral(), situacaoMobiliario.getDescricao()));
        }
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(GeracaoDocumentoDTO.from((AlvaraLocalizacaoDTO)alvaraLocalizacaoDTO, (CadastroGeral)cadastroMobiliario));
        documento.setSituacaoCadastral(cadastroMobiliario.getSituacaoAtual().getDescricao());
        documento.setSubTipo(alvaraLocalizacaoDTO.getTipoAlvara().getValue());
        documento.setProcessoSei(alvaraLocalizacaoDTO.getProcessoSei());
        Documento saved = (Documento)this.documentoService.save((EloEntity)documento, null);
        this.atualizaCadastroMobiliario(cadastroMobiliario, saved);
        return DocumentoDTO.from((Documento)documento);
    }

    private void atualizaCadastroMobiliario(CadastroMobiliario cadastroMobiliario, Documento documento) {
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ATUALIZA_ALVARA_MOBILIARIO).booleanValue()) {
            cadastroMobiliario.setNumeroAlvara(documento.getDocumento());
            cadastroMobiliario.setExercicioAlvara(documento.getExercicio());
            if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ATUALIZA_ALVARA_DATA).booleanValue()) {
                cadastroMobiliario.setDataAlvara(documento.getDataEmissao());
                cadastroMobiliario.setDataValidadeAlvara(documento.getDataValidade());
            }
            this.cadastroMobiliarioService.save((EloEntity)cadastroMobiliario, null);
        }
    }
}

