/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoimply;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.DebitoCotaUnicaService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-imply/cota-unica"})
public class CotaUnicaImplyResource {
    private final DebitoCotaUnicaService debitoCotaUnicaService;
    private final CarneService carneService;
    private final CadastroGeralService cadastroGeralService;

    public CotaUnicaImplyResource(DebitoCotaUnicaService debitoCotaUnicaService, CarneService carneService, CadastroGeralService cadastroGeralService) {
        this.debitoCotaUnicaService = debitoCotaUnicaService;
        this.carneService = carneService;
        this.cadastroGeralService = cadastroGeralService;
    }

    @GetMapping(params={"tipo-cadastro", "cadastro-geral"})
    public ResponseEntity<List<DebitoAgrupadoPorFormaPagamentoDTO>> findAllCotasUnica(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cadastro-geral") Long cadastroGeral) {
        List cotasUnica = this.debitoCotaUnicaService.buscaDebitosAgrupadosPorFormaPagamentoDisponivelWeb(tipoCadastro, cadastroGeral).stream().filter(DebitoAgrupadoPorFormaPagamentoDTO::getIsCotaUnica).collect(Collectors.toList());
        return ResponseEntity.ok(cotasUnica);
    }

    @PostMapping
    public ResponseEntity<BloquetoDTO> gerarCarneCotaUnica(@RequestBody DebitoAgrupadoPorFormaPagamentoDTO params) {
        if (!params.getIsCotaUnica().booleanValue() || !"U".equals(params.getTipoFormaPagamento())) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel gerar carn\u00eas Parcelado ou Restante por esse servi\u00e7o");
        }
        CarneDTO carneDTO = this.carneService.geraCarnePorFormaPagamento(params);
        BloquetoDTO boletoCotaUnica = (BloquetoDTO)carneDTO.getBoletos().get(0);
        CadastroGeral cadastro = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)params.getTipoCadastro()), params.getCadastroGeral()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro %d/%d.", params.getTipoCadastro(), params.getCadastroGeral())));
        boletoCotaUnica.setCadastro(cadastro.toCadastroGeralDTOWithPessoa());
        return ResponseEntity.ok((Object)boletoCotaUnica);
    }
}

