/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.dto.integracaoelogeo.ImobiliarioItbiElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.ProprietarioItbiElogeoDTO;
import br.com.elotech.tributos.service.ImobiliarioItbiService;
import br.com.elotech.tributos.service.VinculoService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/itbi"})
public class ImobiliarioItbiElogeoResource {
    private final ImobiliarioItbiService imobiliarioItbiService;
    private final VinculoService vinculoService;

    public ImobiliarioItbiElogeoResource(ImobiliarioItbiService imobiliarioItbiService, VinculoService vinculoService) {
        this.imobiliarioItbiService = imobiliarioItbiService;
        this.vinculoService = vinculoService;
    }

    @Operation(summary="Retorna uma lista de itbi\u00b4s")
    @GetMapping
    public ResponseEntity<Page<ImobiliarioItbiElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page itbis = this.imobiliarioItbiService.findAll(page).map(arg_0 -> this.entityToElogeoDTO(arg_0));
        return ResponseEntity.ok((Object)itbis);
    }

    @Operation(summary="Retorna um itbi pelo campo IdSequencia")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<ImobiliarioItbiElogeoDTO> findById(@PathVariable Long id) {
        ImobiliarioItbiElogeoDTO imobiliarioItbiElogeoDTO = this.imobiliarioItbiService.findById((Serializable)id).map(arg_0 -> this.entityToElogeoDTO(arg_0)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o ITBI com o id '%d'.", id)));
        return ResponseEntity.ok((Object)imobiliarioItbiElogeoDTO);
    }

    private ImobiliarioItbiElogeoDTO entityToElogeoDTO(ImobiliarioItbi imobiliarioItbi) {
        ImobiliarioItbiElogeoDTO imobiliario = ImobiliarioItbiElogeoDTO.from((ImobiliarioItbi)imobiliarioItbi);
        imobiliarioItbi.getProprietarios().forEach(proprietarioItbi -> {
            Vinculo vinculo = (Vinculo)this.vinculoService.findOne((Serializable)proprietarioItbi.getVinculo());
            imobiliario.getProprietarios().add(ProprietarioItbiElogeoDTO.from((ProprietarioItbi)proprietarioItbi, (Vinculo)vinculo));
        });
        return imobiliario;
    }
}

