/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.ContenciosoResponseDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosResponseDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDTO;
import br.com.elotech.tributos.dto.contencioso.FiltroDebitosContenciosoDTO;
import br.com.elotech.tributos.service.ContenciosoRecalculoService;
import br.com.elotech.tributos.service.ContenciosoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contenciosos"})
public class ContenciosoResource
extends ReadOnlyResource<Contencioso, Long> {
    private final ContenciosoService contenciosoService;
    private final ContenciosoRecalculoService contenciosoRecalculoService;
    private final DebitoService debitoService;
    private final ParcelamentoService parcelamentoService;

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ContenciosoResponseDTO>> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page contencioso = this.contenciosoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)contencioso.map(ContenciosoResponseDTO::of));
    }

    @GetMapping(value={"/{id}/dto"})
    public ResponseEntity<ContenciosoDebitosResponseDTO> findDtoById(@PathVariable Long id) {
        Contencioso contencioso = (Contencioso)this.contenciosoService.findOne((Serializable)id);
        if (Objects.isNull(contencioso)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar contencioso com id %d", id));
        }
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @PostMapping
    public ResponseEntity<ContenciosoDebitosResponseDTO> create(@RequestBody @Valid ContenciosoDebitosResponseDTO contenciosoDebitosResponseDTO) {
        Contencioso contencioso = this.contenciosoService.create(contenciosoDebitosResponseDTO);
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @PostMapping(value={"/{id}/exarar"})
    public ResponseEntity<ContenciosoDebitosExararDTO> exarar(@RequestBody @Valid ContenciosoDebitosExararDTO contenciosoDebitosResponseDTO, @PathVariable Long id) {
        Contencioso contencioso = this.contenciosoService.exarar(contenciosoDebitosResponseDTO, id);
        return ResponseEntity.ok((Object)ContenciosoDebitosExararDTO.of((Contencioso)contencioso));
    }

    @PostMapping(value={"/{id}/exararManterDebito"})
    public ResponseEntity<ContenciosoDebitosResponseDTO> exararManterDebito(@RequestBody @Valid ContenciosoDebitosExararDTO contenciosoDebitosResponseDTO, @PathVariable Long id) {
        Contencioso contencioso = this.contenciosoService.exararManterDebitos(contenciosoDebitosResponseDTO, id);
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<ContenciosoDebitosResponseDTO> put(@RequestBody @Valid ContenciosoDebitosResponseDTO contenciosoDebitosResponseDTO) {
        Contencioso contencioso = this.contenciosoService.create(contenciosoDebitosResponseDTO);
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @GetMapping(value={"/filtrar-debitos"})
    public ResponseEntity<Page<Debito>> search(FiltroDebitosContenciosoDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.debitoService.buscarDebitos(filtro, pageable));
    }

    @PostMapping(value={"/{id}/recalcular"})
    public ResponseEntity<Void> recalcularContencioso(@PathVariable Long id, @RequestBody @Valid ContenciosoRecalculoDTO contenciosoRecalculoDTO) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JsonProcessingException, JobRestartException {
        this.contenciosoRecalculoService.recalcularContencioso(id, contenciosoRecalculoDTO);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/gerar-boletos"})
    public ResponseEntity<String> gerarBoletos(@PathVariable Long id) throws IOException {
        return ResponseEntity.ok((Object)this.contenciosoRecalculoService.gerarBoletos(id));
    }

    @GetMapping(value={"/gerar-boleto/{idDebitoRecalculo}"})
    public ResponseEntity<String> gerarBoleto(@PathVariable Long idDebitoRecalculo) throws IOException {
        return ResponseEntity.ok((Object)this.contenciosoRecalculoService.gerarBoleto(idDebitoRecalculo));
    }

    @PostMapping(value={"/{id}/gerar-cadastro-memoria"})
    public ResponseEntity<Void> generateCadastroMemoriaByIdContencioso(@PathVariable Long id) {
        this.contenciosoService.generateCadastroMemoriaByIdContencioso(id);
        return ResponseEntity.ok().build();
    }

    @Generated
    public ContenciosoResource(ContenciosoService contenciosoService, ContenciosoRecalculoService contenciosoRecalculoService, DebitoService debitoService, ParcelamentoService parcelamentoService) {
        this.contenciosoService = contenciosoService;
        this.contenciosoRecalculoService = contenciosoRecalculoService;
        this.debitoService = debitoService;
        this.parcelamentoService = parcelamentoService;
    }
}

