/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.AvisoCadastro;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.AvisoCadastroDTO;
import br.com.elotech.tributos.dto.TextoAvisoCadastroDTO;
import br.com.elotech.tributos.service.AvisoCadastroService;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aviso-cadastro"})
public class AvisoCadastroResource {
    private final AvisoCadastroService service;

    public AvisoCadastroResource(AvisoCadastroService service) {
        this.service = service;
    }

    @PostMapping
    public ResponseEntity<AvisoCadastro> create(@RequestBody AvisoCadastroDTO dto) {
        AvisoCadastro avisoCadastro = this.service.create(dto);
        return ResponseEntity.ok((Object)avisoCadastro);
    }

    @GetMapping
    public ResponseEntity<Page<AvisoCadastro>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.findAll(search, pageable));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<AvisoCadastro> findById(@PathVariable Long id) {
        AvisoCadastro avisoCadastro = this.service.buscaPorId(id);
        return ResponseEntity.ok((Object)avisoCadastro);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<AvisoCadastro> update(@PathVariable Long id, @RequestBody AvisoCadastroDTO dto) {
        AvisoCadastro avisoCadastro = this.service.update(id, dto);
        return ResponseEntity.ok((Object)avisoCadastro);
    }

    @PutMapping(value={"/status/{id}"})
    public ResponseEntity<AvisoCadastro> statusChange(@PathVariable Long id) {
        AvisoCadastro avisoCadastro = this.service.statusChange(id);
        return ResponseEntity.ok((Object)avisoCadastro);
    }

    @GetMapping(value={"/tipo-cadastro/{tipoCadastro}"})
    public ResponseEntity<List<AvisoCadastro>> findByTipoCadastro(@PathVariable TipoCadastro tipoCadastro) {
        List avisos = this.service.findByTipoCadastroLista(tipoCadastro);
        return ResponseEntity.ok((Object)avisos);
    }

    @GetMapping(value={"/consulta/tipo/{tipoCadastro}/id/{id}"})
    public ResponseEntity<TextoAvisoCadastroDTO> verificaAviso(@PathVariable TipoCadastro tipoCadastro, @PathVariable Long id) {
        TextoAvisoCadastroDTO textoAvisoCadastroDTO = this.service.verificaAviso(tipoCadastro, id);
        if (textoAvisoCadastroDTO == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)textoAvisoCadastroDTO);
    }
}

