/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.NrDisponivel;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.simam.NrCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class NrCreditoCustomRepository {
    public static final String NOT_EXISTS_ATUALIZA_MONETARIA_CRED = "where not exists (select 1 from tceatualizamonecred x where x.nrCredito = soma.nrCredito and x.nrAnoCredito = soma.nrAnoCredito and x.dtatualizacao = :dataLancamento) ";
    public static final String NOT_EXISTS_DEDUCAO_CREDITO = "where not exists (select 1 from tcededucaocredito x where x.nrCredito = soma.nrCredito and x.nrAnoCredito = soma.nrAnoCredito and x.dtdeducao = :dataLancamento) ";
    public static final String NOT_EXISTS_INSCRICAO_CREDITO_DA = "where not exists (select 1 from tceInscCreditoDA x where x.nrCredito = soma.nrCredito and x.nrAnoCredito = soma.nrAnoCredito and x.dtInscricao = :dataLancamento) ";
    public static final String NOT_EXISTS_ARRECADACAO_TIPO_CREDITO = "where not exists (select 1 from tceArrecadacaoTipoCredito x where x.nrCredito = soma.nrCredito and x.nrAnoCredito = soma.nrAnoCredito and ((x.nrAno < :nrAno) or (x.nrAno = :nrAno and x.nrMes = :nrMes))) ";
    public static final String SQL_NRCREDITO = "sql/simam/manutencaoarquivo/atribuirNrCredito.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public List<NrDisponivel> getNrCredito(TipoRegistroSimAm tipoRegistroSimAm, Long idTipoCredito, LocalDate dataLancamento, Long nrAno, Long nrMes) {
        if (Objects.isNull(dataLancamento)) {
            throw new EloValidationException("Data de lan\u00e7amento precisa ser informada");
        }
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idTipoCredito", (Object)idTipoCredito, 2);
        parameters.addValue("dataLancamento", (Object)Date.valueOf(dataLancamento), 91);
        parameters.addValue("anoLancamento", (Object)dataLancamento.getYear(), 2);
        if (tipoRegistroSimAm.equals((Object)TipoRegistroSimAm.ARRECADACAO_TIPO_CREDITO)) {
            parameters.addValue("nrAno", (Object)nrAno, 2);
            parameters.addValue("nrMes", (Object)nrMes, 2);
        }
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_NRCREDITO), this.getNotExists(tipoRegistroSimAm));
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(NrDisponivel.class));
    }

    private String getNotExists(TipoRegistroSimAm tipoRegistroSimAm) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoRegistroSimAm[tipoRegistroSimAm.ordinal()]) {
            case 1: {
                return NOT_EXISTS_ATUALIZA_MONETARIA_CRED;
            }
            case 2: {
                return NOT_EXISTS_DEDUCAO_CREDITO;
            }
            case 3: {
                return NOT_EXISTS_INSCRICAO_CREDITO_DA;
            }
            case 4: {
                return NOT_EXISTS_ARRECADACAO_TIPO_CREDITO;
            }
        }
        throw new EloValidationException("Tipo de registro n\u00e3o suportado para atribui\u00e7\u00e3o de NrCredito.");
    }

    @Generated
    public NrCreditoCustomRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

