/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.relatoriogerencial;

import br.com.elotech.core.utils.FileUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LancamentoArrecadacaoRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    private <T> T executarConsulta(String caminhoSql, Map<String, Object> parametros, String nomeColuna, Class<T> tipoRetorno) {
        String sql = FileUtils.readResourceAsString((String)caminhoSql);
        MapSqlParameterSource paramSource = new MapSqlParameterSource(parametros);
        return (T)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, (rs, rowNum) -> rs.getObject(nomeColuna, tipoRetorno));
    }

    public BigDecimal buscaValorRevisadoAnterior(Long entidade, Long exercicio, Long mesAnalise) {
        HashMap<String, Long> parametros = new HashMap<String, Long>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("MesAnalise", mesAnalise);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/buscavalorrevisaoanterior.sql", parametros, "Revisoes", BigDecimal.class);
    }

    public BigDecimal buscaLancamentoAnual(Long entidade, Long exercicio, LocalDate dataInclusao) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/lancamentoanual.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaArrecadacaoTotal(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculaarrecadacaototal.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaSaldoEmAberto(Long entidade, Long exercicio, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculasaldoemaberto.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaDesconto(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculadesconto.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaArrecadacaoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculaarrecadacaoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaCreditoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculacreditoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaDescontoArrecadacaoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculadescontoarrecadacaoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaDevolucaoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculadevolucaoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public Long calculaArrecadadoAVistaCadastro(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calculaarrecadadoavistacadastro.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaArrecadadoParceladoCadastro(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calculaarrecadadoparceladocadastro.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaLancamentoAnualCadastro(Long entidade, Long exercicio, LocalDate dataInclusao) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calculalancamentoanualcadastro.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaSaldoEmAbertoCadastro(Long entidade, Long exercicio, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataFinal", dataFinal);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calculasaldoemabertocadastro.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaRenunciaCadastro(Long entidade, Long exercicio, LocalDate dataInclusao) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calcularenunciacadastro.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaRenunciaCadastroValorZerado(Long entidade, Long exercicio, LocalDate dataInclusao) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calcularenunciacadastrovalorzerado.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaCancelamentoCadastro(Long entidade, Long exercicio, LocalDate dataInclusao) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calculacancelamentocadastro.sql", parametros, "Qtde", Long.class);
    }

    private Map<String, Object> mapEntidadeExercicio(Long entidade, Long exercicio) {
        return Map.of("Entidade", entidade, "Exercicio", exercicio);
    }

    @Generated
    public LancamentoArrecadacaoRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

