/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.parcelamento.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroEstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoIdDTO;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepositoryCustom;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ParcelamentoRepositoryImpl
implements ParcelamentoRepositoryCustom {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParcelamentoRepositoryImpl.class);
    private static final String DEBITO_ORIGEM = "br/com/elotech/tributos/repository/parcelamento-debito-origem.sql";
    private static final String DEBITO_NOVO = "br/com/elotech/tributos/repository/parcelamento-debito-novo.sql";
    private static final String PARCELAS_DEBITONOVO_POR_IDDEBITO_ORIGEM = "br/com/elotech/tributos/repository/parcelas-debito-novo-por-iddebitoorigem.sql";
    private static final String DEBITO_PARCELAS = "br/com/elotech/tributos/repository/parcelamento-debito-parcelas.sql";
    private static final String PARCELAMENTO_QUITADO = "br/com/elotech/tributos/repository/parcelamento-quitado.sql";
    private static final String PARCELAMENTO_ESTORNO_LOTES = "br/com/elotech/tributos/repository/find-estorno-parcelamento-em-lote.sql";
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoOrigem(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_ORIGEM);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoDTO.class));
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoNovo(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_NOVO);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoDTO.class));
    }

    public List<ParcelamentoDebitoParcelasDTO> findParcelasDebitoNovoPorIdDebitoOrigem(List<Long> idsDebitosOrigem) {
        String sql = FileUtils.readResourceAsString((String)PARCELAS_DEBITONOVO_POR_IDDEBITO_ORIGEM);
        MapSqlParameterSource parameters = new MapSqlParameterSource("ids", idsDebitosOrigem);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoParcelasDTO.class));
    }

    public List<ParcelamentoDebitoParcelasDTO> findParcelamentoDebitoParcelas(Long idParcelamento) {
        return this.findParcelamentoDebitoParcelas(Arrays.asList(idParcelamento));
    }

    public List<ParcelamentoDebitoParcelasDTO> findParcelamentoDebitoParcelas(List<Long> idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_PARCELAS);
        MapSqlParameterSource parameters = new MapSqlParameterSource("ids", idParcelamento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoParcelasDTO.class));
    }

    public Boolean parcelamentoComDebitosQuitados(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)PARCELAMENTO_QUITADO);
        return !this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoIdDTO.class)).isEmpty();
    }

    public Page<EstornoParcelamentoEmLoteDTO> findParcelamentosParaEstornoEmLote(FiltroEstornoParcelamentoEmLoteDTO filtroEstornoParcelamentoEmLoteDTO, Long entidade, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)PARCELAMENTO_ESTORNO_LOTES).replace("$[FiltroDesfazerParcelamento]", filtroEstornoParcelamentoEmLoteDTO.buildFiltroEstornoParcelamentoEmLoteDTO());
        MapSqlParameterSource parametros = filtroEstornoParcelamentoEmLoteDTO.getParameterSource(entidade);
        log.debug("findParcelamentosParaEstornoEmLote - SQL utilizado na busca dos parcelamentos: {}", (Object)sql);
        log.debug("findParcelamentosParaEstornoEmLote - Par\u00e2metros utilizados na busca dos parcelamentos: {}", (Object)parametros.getValues());
        Long total = Optional.ofNullable(this.getTotal(sql, parametros)).orElse(0L);
        String sqlComPaginacao = this.getSqlComPaginacao(sql, pageable);
        List pagedRows = this.namedParameterJdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parametros, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoParcelamentoEmLoteDTO.class));
        return new PageImpl(pagedRows, pageable, total.longValue());
    }

    private Long getTotal(String sql, MapSqlParameterSource params) {
        String sqlCount = String.format("select count(*) as total from (%s) count_query", sql);
        return (Long)this.namedParameterJdbcTemplate.queryForObject(sqlCount, (SqlParameterSource)params, (rs, rowNum) -> rs.getLong("total"));
    }

    private String getSqlComPaginacao(String sql, Pageable pageable) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        return SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
    }

    @Generated
    public ParcelamentoRepositoryImpl(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

