/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.parcelamento;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.ValueBlockDashDTO;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepositoryCustom;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ParcelamentoRepository
extends CrudRepository<Parcelamento, Long>,
ParcelamentoRepositoryCustom,
JpaSpecificationExecutor<Parcelamento> {
    @Query(value="select idParametroParcelamento from Parcelamento p where p.id = :idParcelamento")
    public Optional<Long> findIdParametroParcelamentoByIdParcelamento(@Param(value="idParcelamento") Long var1);

    @Query(value=" select new br.com.elotech.tributos.dto.ValueBlockDashDTO(count(p.id))  from Parcelamento p where p.dataInclusao = :data")
    public ValueBlockDashDTO getQuantidadeContratosGerados(@Param(value="data") LocalDate var1);

    @Query(value="select tp from Parcelamento tp  where tp.id = (select td.idParcelamento from Debito td  inner join td.parcelas tdp  where tdp = :parcela )    and tp.situacao = 4")
    public Optional<Parcelamento> findParcelamentoQuitadoByParcela(@Param(value="parcela") DebitoParcela var1);

    @Query(value="select tp from Parcelamento tp  where tp.situacao = 1 and  tp.id = (select td.idParcelamento from Debito td           inner join td.parcelas tdp           where tdp = :parcela          and not exists(                select 1 from DebitoParcela tdp2                    inner join tdp2.situacaoDebito tsp                     where tdp.id.entidade = tdp2.id.entidade                        and tdp.id.exercicio = tdp2.id.exercicio                        and tdp.id.tipoCadastro = tdp2.id.tipoCadastro                        and tdp.id.divida = tdp2.id.divida                        and tdp.id.subDivida = tdp2.id.subDivida                        and tdp.id.parcela <> tdp2.id.parcela                        and tsp.tipoSituacaoParcela.id = 1                )          )")
    public Optional<Parcelamento> findParcelamentoDisponivelParaQuitacao(@Param(value="parcela") DebitoParcela var1);

    public Parcelamento findByCodigoValidacao(String var1);

    public Optional<Parcelamento> findParcelamentoByNumeroContratoAndAnoContrato(Long var1, Long var2);
}

