/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.AlteracaoVencimentosDTO;
import br.com.elotech.tributos.dto.FiltroAlteracaoVencimentosDTO;
import br.com.elotech.tributos.repository.AlteracaoRepositoryCustom;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AlteracaoVencimentosRepositoryImpl
implements AlteracaoRepositoryCustom {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlteracaoVencimentosRepositoryImpl.class);
    private static final String FIND_VENCIMENTOS_DEBITOS = "br/com/elotech/tributos/repository/find-debitos-para-alteracao-vencimento.sql";
    private static final String ALTERACAO_VENCIMENTOS = "br/com/elotech/tributos/repository/update-alteracao-vencimentos-debitos.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public AlteracaoVencimentosRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Page<AlteracaoVencimentosDTO> findAlteracaoVencimentosDTO(FiltroAlteracaoVencimentosDTO dto, Pageable pageable) {
        String sort = this.getSort(pageable);
        String sql = String.format(FileUtils.readResourceAsString((String)FIND_VENCIMENTOS_DEBITOS), dto.buildFiltro(), sort);
        return this.getMapPageableParametersAndSql(pageable, dto.buildParameters(), sql);
    }

    public void updateVencimentos(FiltroAlteracaoVencimentosDTO filtroAlteracaoVencimentosDTO) {
        String sql = String.format(FileUtils.readResourceAsString((String)ALTERACAO_VENCIMENTOS), filtroAlteracaoVencimentosDTO.buildFiltro());
        this.jdbcTemplate.execute(sql, (SqlParameterSource)filtroAlteracaoVencimentosDTO.buildParameters(), PreparedStatement::executeLargeUpdate);
    }

    private String getSort(Pageable pageable) {
        String pageableSort = pageable.getSort().toString().replace(":", "").replaceAll("(?i)unsorted", "");
        String finalSort = "";
        if (!pageableSort.isEmpty()) {
            finalSort = finalSort.concat(" ORDER BY " + pageableSort);
        }
        return finalSort;
    }

    private Page<AlteracaoVencimentosDTO> getMapPageableParametersAndSql(Pageable pageable, MapSqlParameterSource parameters, String sql) {
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        Long numeroTotal = (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)sql, (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedRecords = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AlteracaoVencimentosDTO.class));
        return new PageImpl(pagedRecords, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }
}

