/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamento;

import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoInfoDTO;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;

public class PagamentoLoteDTO {
    private Long entidade;
    private Long exercicio;
    private Long lote;
    private LocalDate dataLote;
    private LocalDate dataMovimento;
    private LocalDate dataCredito;
    private Long convenio;
    private String descricaoConvenio;
    private String conta;
    private String agencia;
    private Long banco;
    private String descricaoBanco;
    private String tipo;
    private String situacao;
    private Long contaBancaria;
    private String descricaoContaBancaria;
    private String nomeArquivoRetorno;
    private String observacao;
    private Long jobId;
    private BatchStatus jobStatus;
    private List<PagamentoLoteIntegracaoInfoDTO> integracoesInfo;

    public static PagamentoLoteDTO of(PagamentoLote pagamentoLote) {
        PagamentoLoteDTO dto = new PagamentoLoteDTO();
        dto.setEntidade(pagamentoLote.getId().getEntidade());
        dto.setExercicio(pagamentoLote.getId().getExercicio());
        dto.setLote(pagamentoLote.getId().getLote());
        dto.setDataLote(pagamentoLote.getDataLote());
        dto.setDataMovimento(pagamentoLote.getDataMovimento());
        dto.setDataCredito(pagamentoLote.getDataCredito());
        dto.setSituacao(pagamentoLote.getSituacao().getDescricao());
        dto.setObservacao(pagamentoLote.getObservacao());
        dto.setNomeArquivoRetorno(pagamentoLote.getNomeArquivo());
        TipoPagamentoLote tipoPagamento = Optional.ofNullable(pagamentoLote.getTipo()).orElse(TipoPagamentoLote.ARQUIVO);
        dto.setTipo(tipoPagamento.getDescricao());
        if (Objects.nonNull(pagamentoLote.getBatchJobExecution())) {
            dto.jobId = pagamentoLote.getBatchJobExecution().getId();
            dto.jobStatus = pagamentoLote.getBatchJobExecution().getStatus();
        }
        if (Objects.nonNull(pagamentoLote.getConvenio())) {
            dto.setConvenio(pagamentoLote.getConvenio().getConvenio());
            dto.setDescricaoConvenio(pagamentoLote.getConvenio().getDescricao());
        }
        if (Objects.nonNull(pagamentoLote.getContaBancaria())) {
            dto.setConta(pagamentoLote.getContaBancaria().getConta());
            dto.setContaBancaria(pagamentoLote.getContaBancaria().getContaBancaria());
            dto.setDescricaoContaBancaria(pagamentoLote.getContaBancaria().getDescricao());
            dto.setConta(pagamentoLote.getContaBancaria().getConta());
            if (Objects.nonNull(pagamentoLote.getContaBancaria().getAgencia())) {
                dto.setAgencia(pagamentoLote.getContaBancaria().getAgencia().getAgencia());
                dto.setBanco(pagamentoLote.getContaBancaria().getAgencia().getBanco().getId());
                dto.setDescricaoBanco(pagamentoLote.getContaBancaria().getAgencia().getBanco().getDescricao());
            }
        }
        if (Objects.nonNull(pagamentoLote.getLotesIntegracaoContabil())) {
            dto.setIntegracoesInfo(pagamentoLote.getLotesIntegracaoContabil().stream().map(PagamentoLoteIntegracaoInfoDTO::from).collect(Collectors.toList()));
        }
        return dto;
    }

    @Generated
    public PagamentoLoteDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public LocalDate getDataLote() {
        return this.dataLote;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public Long getConvenio() {
        return this.convenio;
    }

    @Generated
    public String getDescricaoConvenio() {
        return this.descricaoConvenio;
    }

    @Generated
    public String getConta() {
        return this.conta;
    }

    @Generated
    public String getAgencia() {
        return this.agencia;
    }

    @Generated
    public Long getBanco() {
        return this.banco;
    }

    @Generated
    public String getDescricaoBanco() {
        return this.descricaoBanco;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public String getDescricaoContaBancaria() {
        return this.descricaoContaBancaria;
    }

    @Generated
    public String getNomeArquivoRetorno() {
        return this.nomeArquivoRetorno;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getJobId() {
        return this.jobId;
    }

    @Generated
    public BatchStatus getJobStatus() {
        return this.jobStatus;
    }

    @Generated
    public List<PagamentoLoteIntegracaoInfoDTO> getIntegracoesInfo() {
        return this.integracoesInfo;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setDataLote(LocalDate dataLote) {
        this.dataLote = dataLote;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setConvenio(Long convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setDescricaoConvenio(String descricaoConvenio) {
        this.descricaoConvenio = descricaoConvenio;
    }

    @Generated
    public void setConta(String conta) {
        this.conta = conta;
    }

    @Generated
    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Generated
    public void setBanco(Long banco) {
        this.banco = banco;
    }

    @Generated
    public void setDescricaoBanco(String descricaoBanco) {
        this.descricaoBanco = descricaoBanco;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setContaBancaria(Long contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setDescricaoContaBancaria(String descricaoContaBancaria) {
        this.descricaoContaBancaria = descricaoContaBancaria;
    }

    @Generated
    public void setNomeArquivoRetorno(String nomeArquivoRetorno) {
        this.nomeArquivoRetorno = nomeArquivoRetorno;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setJobStatus(BatchStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    @Generated
    public void setIntegracoesInfo(List<PagamentoLoteIntegracaoInfoDTO> integracoesInfo) {
        this.integracoesInfo = integracoesInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoLoteDTO)) {
            return false;
        }
        PagamentoLoteDTO other = (PagamentoLoteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Long this$convenio = this.getConvenio();
        Long other$convenio = other.getConvenio();
        if (this$convenio == null ? other$convenio != null : !((Object)this$convenio).equals(other$convenio)) {
            return false;
        }
        Long this$banco = this.getBanco();
        Long other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !((Object)this$banco).equals(other$banco)) {
            return false;
        }
        Long this$contaBancaria = this.getContaBancaria();
        Long other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !((Object)this$contaBancaria).equals(other$contaBancaria)) {
            return false;
        }
        Long this$jobId = this.getJobId();
        Long other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        LocalDate this$dataLote = this.getDataLote();
        LocalDate other$dataLote = other.getDataLote();
        if (this$dataLote == null ? other$dataLote != null : !((Object)this$dataLote).equals(other$dataLote)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataCredito = this.getDataCredito();
        LocalDate other$dataCredito = other.getDataCredito();
        if (this$dataCredito == null ? other$dataCredito != null : !((Object)this$dataCredito).equals(other$dataCredito)) {
            return false;
        }
        String this$descricaoConvenio = this.getDescricaoConvenio();
        String other$descricaoConvenio = other.getDescricaoConvenio();
        if (this$descricaoConvenio == null ? other$descricaoConvenio != null : !this$descricaoConvenio.equals(other$descricaoConvenio)) {
            return false;
        }
        String this$conta = this.getConta();
        String other$conta = other.getConta();
        if (this$conta == null ? other$conta != null : !this$conta.equals(other$conta)) {
            return false;
        }
        String this$agencia = this.getAgencia();
        String other$agencia = other.getAgencia();
        if (this$agencia == null ? other$agencia != null : !this$agencia.equals(other$agencia)) {
            return false;
        }
        String this$descricaoBanco = this.getDescricaoBanco();
        String other$descricaoBanco = other.getDescricaoBanco();
        if (this$descricaoBanco == null ? other$descricaoBanco != null : !this$descricaoBanco.equals(other$descricaoBanco)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$descricaoContaBancaria = this.getDescricaoContaBancaria();
        String other$descricaoContaBancaria = other.getDescricaoContaBancaria();
        if (this$descricaoContaBancaria == null ? other$descricaoContaBancaria != null : !this$descricaoContaBancaria.equals(other$descricaoContaBancaria)) {
            return false;
        }
        String this$nomeArquivoRetorno = this.getNomeArquivoRetorno();
        String other$nomeArquivoRetorno = other.getNomeArquivoRetorno();
        if (this$nomeArquivoRetorno == null ? other$nomeArquivoRetorno != null : !this$nomeArquivoRetorno.equals(other$nomeArquivoRetorno)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        BatchStatus this$jobStatus = this.getJobStatus();
        BatchStatus other$jobStatus = other.getJobStatus();
        if (this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus)) {
            return false;
        }
        List this$integracoesInfo = this.getIntegracoesInfo();
        List other$integracoesInfo = other.getIntegracoesInfo();
        return !(this$integracoesInfo == null ? other$integracoesInfo != null : !((Object)this$integracoesInfo).equals(other$integracoesInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoLoteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Long $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : ((Object)$convenio).hashCode());
        Long $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : ((Object)$banco).hashCode());
        Long $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : ((Object)$contaBancaria).hashCode());
        Long $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        LocalDate $dataLote = this.getDataLote();
        result = result * 59 + ($dataLote == null ? 43 : ((Object)$dataLote).hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataCredito = this.getDataCredito();
        result = result * 59 + ($dataCredito == null ? 43 : ((Object)$dataCredito).hashCode());
        String $descricaoConvenio = this.getDescricaoConvenio();
        result = result * 59 + ($descricaoConvenio == null ? 43 : $descricaoConvenio.hashCode());
        String $conta = this.getConta();
        result = result * 59 + ($conta == null ? 43 : $conta.hashCode());
        String $agencia = this.getAgencia();
        result = result * 59 + ($agencia == null ? 43 : $agencia.hashCode());
        String $descricaoBanco = this.getDescricaoBanco();
        result = result * 59 + ($descricaoBanco == null ? 43 : $descricaoBanco.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $descricaoContaBancaria = this.getDescricaoContaBancaria();
        result = result * 59 + ($descricaoContaBancaria == null ? 43 : $descricaoContaBancaria.hashCode());
        String $nomeArquivoRetorno = this.getNomeArquivoRetorno();
        result = result * 59 + ($nomeArquivoRetorno == null ? 43 : $nomeArquivoRetorno.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        BatchStatus $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
        List $integracoesInfo = this.getIntegracoesInfo();
        result = result * 59 + ($integracoesInfo == null ? 43 : ((Object)$integracoesInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoLoteDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", lote=" + this.getLote() + ", dataLote=" + this.getDataLote() + ", dataMovimento=" + this.getDataMovimento() + ", dataCredito=" + this.getDataCredito() + ", convenio=" + this.getConvenio() + ", descricaoConvenio=" + this.getDescricaoConvenio() + ", conta=" + this.getConta() + ", agencia=" + this.getAgencia() + ", banco=" + this.getBanco() + ", descricaoBanco=" + this.getDescricaoBanco() + ", tipo=" + this.getTipo() + ", situacao=" + this.getSituacao() + ", contaBancaria=" + this.getContaBancaria() + ", descricaoContaBancaria=" + this.getDescricaoContaBancaria() + ", nomeArquivoRetorno=" + this.getNomeArquivoRetorno() + ", observacao=" + this.getObservacao() + ", jobId=" + this.getJobId() + ", jobStatus=" + this.getJobStatus() + ", integracoesInfo=" + this.getIntegracoesInfo() + ")";
    }
}

