/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamento;

import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebito;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class PagamentoDebitoPorTributoDTO {
    private Long idDebito;
    private Long idDebitoParcelatributo;
    private Long idPagamentoBoleto;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long exercicioDebito;
    private Long divida;
    private Long subDivida;
    private Long parcela;
    private String tributo;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorCalculado = BigDecimal.ZERO;
    private BigDecimal valorPago = BigDecimal.ZERO;
    private BigDecimal valorDevolvido = BigDecimal.ZERO;
    private BigDecimal valorADevolver = BigDecimal.ZERO;
    private BigDecimal saldoADevolver = BigDecimal.ZERO;

    public static PagamentoDebitoPorTributoDTO fromWithoutValue(PagamentoDebito pagamentoDebito) {
        PagamentoDebitoPorTributoDTO dto = new PagamentoDebitoPorTributoDTO();
        dto.setIdDebito(pagamentoDebito.getId().getDebitoParcelaTributo().getIdDebito());
        dto.setTipoCadastro(pagamentoDebito.getId().getDebitoParcelaTributo().getTipoCadastro());
        dto.setCadastroGeral(pagamentoDebito.getId().getDebitoParcelaTributo().getCadastroGeral());
        dto.setExercicioDebito(pagamentoDebito.getId().getDebitoParcelaTributo().getExercicio());
        dto.setDivida(pagamentoDebito.getId().getDebitoParcelaTributo().getDivida());
        dto.setSubDivida(pagamentoDebito.getId().getDebitoParcelaTributo().getSubDivida());
        dto.setParcela(pagamentoDebito.getId().getDebitoParcelaTributo().getParcela());
        dto.setTributo(pagamentoDebito.getId().getDebitoParcelaTributo().getTributo());
        dto.setIdDebitoParcelatributo(pagamentoDebito.getId().getDebitoParcelaTributo().getId());
        dto.setIdPagamentoBoleto(pagamentoDebito.getId().getIdPagamentoBoleto());
        return dto;
    }

    public static PagamentoDebitoPorTributoDTO of(PagamentoDebito pagamentoDebito) {
        PagamentoDebitoPorTributoDTO dto = new PagamentoDebitoPorTributoDTO();
        dto.setIdDebito(pagamentoDebito.getId().getDebitoParcelaTributo().getIdDebito());
        dto.setTipoCadastro(pagamentoDebito.getId().getDebitoParcelaTributo().getTipoCadastro());
        dto.setCadastroGeral(pagamentoDebito.getId().getDebitoParcelaTributo().getCadastroGeral());
        dto.setExercicioDebito(pagamentoDebito.getId().getDebitoParcelaTributo().getExercicio());
        dto.setDivida(pagamentoDebito.getId().getDebitoParcelaTributo().getDivida());
        dto.setSubDivida(pagamentoDebito.getId().getDebitoParcelaTributo().getSubDivida());
        dto.setParcela(pagamentoDebito.getId().getDebitoParcelaTributo().getParcela());
        dto.setTributo(pagamentoDebito.getId().getDebitoParcelaTributo().getTributo());
        dto.setValorPrincipal(pagamentoDebito.getValorPrincipal());
        dto.setValorCorrecao(pagamentoDebito.getValorCorrecao());
        dto.setValorJuros(pagamentoDebito.getValorJuros());
        dto.setValorMulta(pagamentoDebito.getValorMulta());
        dto.setValorDesconto(pagamentoDebito.getValorDesconto());
        dto.setValorCalculado(pagamentoDebito.getValorCalculado());
        dto.setValorPago(pagamentoDebito.getValorPago().add(pagamentoDebito.getValorPagoMaior()));
        dto.setValorDevolvido(pagamentoDebito.getValorDevolvido());
        dto.setIdPagamentoBoleto(pagamentoDebito.getId().getIdPagamentoBoleto());
        dto.setIdDebitoParcelatributo(pagamentoDebito.getId().getDebitoParcelaTributo().getId());
        dto.setSaldoADevolver(pagamentoDebito.getValorPago().subtract(Optional.ofNullable(pagamentoDebito.getValorDevolvido()).orElse(BigDecimal.ZERO)));
        dto.setValorADevolver(dto.getSaldoADevolver());
        return dto;
    }

    public static PagamentoDebitoPorTributoDTO of(DevolucaoCreditoDebito devolucaoCreditoDebito) {
        PagamentoDebitoPorTributoDTO dto = new PagamentoDebitoPorTributoDTO();
        dto.setIdDebito(devolucaoCreditoDebito.getDebitoParcelaTributo().getIdDebito());
        dto.setTipoCadastro(devolucaoCreditoDebito.getDebitoParcelaTributo().getTipoCadastro());
        dto.setCadastroGeral(devolucaoCreditoDebito.getDebitoParcelaTributo().getCadastroGeral());
        dto.setExercicioDebito(devolucaoCreditoDebito.getDebitoParcelaTributo().getExercicio());
        dto.setDivida(devolucaoCreditoDebito.getDebitoParcelaTributo().getDivida());
        dto.setSubDivida(devolucaoCreditoDebito.getDebitoParcelaTributo().getSubDivida());
        dto.setParcela(devolucaoCreditoDebito.getDebitoParcelaTributo().getParcela());
        dto.setTributo(devolucaoCreditoDebito.getDebitoParcelaTributo().getTributo());
        dto.setValorPrincipal(devolucaoCreditoDebito.getPagamentoDebito().getValorPrincipal());
        dto.setValorCorrecao(devolucaoCreditoDebito.getPagamentoDebito().getValorCorrecao());
        dto.setValorJuros(devolucaoCreditoDebito.getPagamentoDebito().getValorJuros());
        dto.setValorMulta(devolucaoCreditoDebito.getPagamentoDebito().getValorMulta());
        dto.setValorDesconto(devolucaoCreditoDebito.getPagamentoDebito().getValorDesconto());
        dto.setValorCalculado(devolucaoCreditoDebito.getPagamentoDebito().getValorCalculado());
        dto.setIdPagamentoBoleto(devolucaoCreditoDebito.getPagamentoBoleto().getId());
        dto.setIdDebitoParcelatributo(devolucaoCreditoDebito.getPagamentoDebito().getId().getDebitoParcelaTributo().getId());
        dto.setValorPago(devolucaoCreditoDebito.getPagamentoDebito().getValorPago().add(devolucaoCreditoDebito.getPagamentoDebito().getValorPagoMaior()));
        dto.setValorDevolvido(devolucaoCreditoDebito.getPagamentoDebito().getValorDevolvido());
        dto.setValorADevolver(devolucaoCreditoDebito.getValorDevolvido());
        dto.setSaldoADevolver(devolucaoCreditoDebito.getPagamentoDebito().getValorCalculado().subtract(Optional.ofNullable(devolucaoCreditoDebito.getPagamentoDebito().getValorDevolvido()).orElse(BigDecimal.ZERO)));
        return dto;
    }

    public BigDecimal getValorAcrescimos() {
        return this.valorJuros.add(this.valorMulta).add(this.valorCorrecao);
    }

    @Generated
    public PagamentoDebitoPorTributoDTO() {
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getIdDebitoParcelatributo() {
        return this.idDebitoParcelatributo;
    }

    @Generated
    public Long getIdPagamentoBoleto() {
        return this.idPagamentoBoleto;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorCalculado() {
        return this.valorCalculado;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public BigDecimal getValorDevolvido() {
        return this.valorDevolvido;
    }

    @Generated
    public BigDecimal getValorADevolver() {
        return this.valorADevolver;
    }

    @Generated
    public BigDecimal getSaldoADevolver() {
        return this.saldoADevolver;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setIdDebitoParcelatributo(Long idDebitoParcelatributo) {
        this.idDebitoParcelatributo = idDebitoParcelatributo;
    }

    @Generated
    public void setIdPagamentoBoleto(Long idPagamentoBoleto) {
        this.idPagamentoBoleto = idPagamentoBoleto;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(Long exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorCalculado(BigDecimal valorCalculado) {
        this.valorCalculado = valorCalculado;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setValorDevolvido(BigDecimal valorDevolvido) {
        this.valorDevolvido = valorDevolvido;
    }

    @Generated
    public void setValorADevolver(BigDecimal valorADevolver) {
        this.valorADevolver = valorADevolver;
    }

    @Generated
    public void setSaldoADevolver(BigDecimal saldoADevolver) {
        this.saldoADevolver = saldoADevolver;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoDebitoPorTributoDTO)) {
            return false;
        }
        PagamentoDebitoPorTributoDTO other = (PagamentoDebitoPorTributoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$idDebitoParcelatributo = this.getIdDebitoParcelatributo();
        Long other$idDebitoParcelatributo = other.getIdDebitoParcelatributo();
        if (this$idDebitoParcelatributo == null ? other$idDebitoParcelatributo != null : !((Object)this$idDebitoParcelatributo).equals(other$idDebitoParcelatributo)) {
            return false;
        }
        Long this$idPagamentoBoleto = this.getIdPagamentoBoleto();
        Long other$idPagamentoBoleto = other.getIdPagamentoBoleto();
        if (this$idPagamentoBoleto == null ? other$idPagamentoBoleto != null : !((Object)this$idPagamentoBoleto).equals(other$idPagamentoBoleto)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$exercicioDebito = this.getExercicioDebito();
        Long other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !((Object)this$exercicioDebito).equals(other$exercicioDebito)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        BigDecimal this$valorCalculado = this.getValorCalculado();
        BigDecimal other$valorCalculado = other.getValorCalculado();
        if (this$valorCalculado == null ? other$valorCalculado != null : !((Object)this$valorCalculado).equals(other$valorCalculado)) {
            return false;
        }
        BigDecimal this$valorPago = this.getValorPago();
        BigDecimal other$valorPago = other.getValorPago();
        if (this$valorPago == null ? other$valorPago != null : !((Object)this$valorPago).equals(other$valorPago)) {
            return false;
        }
        BigDecimal this$valorDevolvido = this.getValorDevolvido();
        BigDecimal other$valorDevolvido = other.getValorDevolvido();
        if (this$valorDevolvido == null ? other$valorDevolvido != null : !((Object)this$valorDevolvido).equals(other$valorDevolvido)) {
            return false;
        }
        BigDecimal this$valorADevolver = this.getValorADevolver();
        BigDecimal other$valorADevolver = other.getValorADevolver();
        if (this$valorADevolver == null ? other$valorADevolver != null : !((Object)this$valorADevolver).equals(other$valorADevolver)) {
            return false;
        }
        BigDecimal this$saldoADevolver = this.getSaldoADevolver();
        BigDecimal other$saldoADevolver = other.getSaldoADevolver();
        return !(this$saldoADevolver == null ? other$saldoADevolver != null : !((Object)this$saldoADevolver).equals(other$saldoADevolver));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoDebitoPorTributoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $idDebitoParcelatributo = this.getIdDebitoParcelatributo();
        result = result * 59 + ($idDebitoParcelatributo == null ? 43 : ((Object)$idDebitoParcelatributo).hashCode());
        Long $idPagamentoBoleto = this.getIdPagamentoBoleto();
        result = result * 59 + ($idPagamentoBoleto == null ? 43 : ((Object)$idPagamentoBoleto).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : ((Object)$exercicioDebito).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        BigDecimal $valorCalculado = this.getValorCalculado();
        result = result * 59 + ($valorCalculado == null ? 43 : ((Object)$valorCalculado).hashCode());
        BigDecimal $valorPago = this.getValorPago();
        result = result * 59 + ($valorPago == null ? 43 : ((Object)$valorPago).hashCode());
        BigDecimal $valorDevolvido = this.getValorDevolvido();
        result = result * 59 + ($valorDevolvido == null ? 43 : ((Object)$valorDevolvido).hashCode());
        BigDecimal $valorADevolver = this.getValorADevolver();
        result = result * 59 + ($valorADevolver == null ? 43 : ((Object)$valorADevolver).hashCode());
        BigDecimal $saldoADevolver = this.getSaldoADevolver();
        result = result * 59 + ($saldoADevolver == null ? 43 : ((Object)$saldoADevolver).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoDebitoPorTributoDTO(idDebito=" + this.getIdDebito() + ", idDebitoParcelatributo=" + this.getIdDebitoParcelatributo() + ", idPagamentoBoleto=" + this.getIdPagamentoBoleto() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", tributo=" + this.getTributo() + ", valorPrincipal=" + this.getValorPrincipal() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorDesconto=" + this.getValorDesconto() + ", valorCalculado=" + this.getValorCalculado() + ", valorPago=" + this.getValorPago() + ", valorDevolvido=" + this.getValorDevolvido() + ", valorADevolver=" + this.getValorADevolver() + ", saldoADevolver=" + this.getSaldoADevolver() + ")";
    }
}

