/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoelogeo;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.integracaoelogeo.BairroElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroImobiliarioElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroImobiliarioTestadaElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.ProprietarioElogeoDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class CadastroGeralPostElogeoDTO {
    private Long id;
    private Long codigo;
    private TipoCadastro tipo;
    private String numero;
    private String complemento;
    @NotNull
    private Long cep;
    private String englobado;
    private String correspondenciaLocal;
    @NotNull
    @Valid
    private BairroElogeoDTO bairro;
    @NotNull
    @Valid
    private CadastroImobiliarioElogeoDTO imobiliario;
    @NotNull
    @Valid
    private List<ProprietarioElogeoDTO> proprietarios;

    public List<CadastroImobiliarioTestadaElogeoDTO> getImobiliarioTestadas() {
        return new ArrayList<CadastroImobiliarioTestadaElogeoDTO>(this.getImobiliario().getTestadas());
    }

    public CadastroImobiliario toEntity() {
        CadastroImobiliario cadastroImobiliario = new CadastroImobiliario();
        cadastroImobiliario.setId(this.getId());
        cadastroImobiliario.setCadastroGeral(this.getCodigo());
        cadastroImobiliario.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        cadastroImobiliario.setNumero(this.getNumero());
        cadastroImobiliario.setComplemento(this.getComplemento());
        cadastroImobiliario.setCep(this.getCep());
        Optional.ofNullable(this.getCorrespondenciaLocal()).ifPresent(correspondencia -> cadastroImobiliario.setCorrespondenciaLocal(BooleanToStringUtils.getStringAsBoolean((String)correspondencia)));
        cadastroImobiliario.setTipoLote(this.getImobiliario().getTipoLote());
        cadastroImobiliario.setTipoImovel(this.getImobiliario().getTipoImovel());
        cadastroImobiliario.setLoteLocalizacao(this.getImobiliario().getLote());
        cadastroImobiliario.setUnidadeLocalizacao(this.getImobiliario().getUnidade());
        cadastroImobiliario.setDistritoFiscalizacao(this.getImobiliario().getDistritoFiscal());
        cadastroImobiliario.setSetorFiscalizacao(this.getImobiliario().getSetorFiscal());
        cadastroImobiliario.setQuadraFiscalizacao(this.getImobiliario().getQuadraFiscal());
        cadastroImobiliario.setLoteFiscalizacao(this.getImobiliario().getLoteFiscal());
        cadastroImobiliario.setUnidadeFiscalizacao(this.getImobiliario().getUnidadeFiscal());
        cadastroImobiliario.setMatricula(this.getImobiliario().getMatricula());
        cadastroImobiliario.setCartorio(this.getImobiliario().getCartorio());
        cadastroImobiliario.setDataMatricula(this.getImobiliario().getDataMatricula());
        cadastroImobiliario.setFolha(this.getImobiliario().getFolha());
        cadastroImobiliario.setLivro(this.getImobiliario().getLivro());
        cadastroImobiliario.setAreaComum(this.getImobiliario().getAreaComum());
        cadastroImobiliario.setAreaUtilLote(this.getImobiliario().getAreaUtil());
        cadastroImobiliario.setAreaPrivativa(this.getImobiliario().getAreaPrivativa());
        cadastroImobiliario.setAreaLote(this.getImobiliario().getAreaLote());
        cadastroImobiliario.setAreaTotalConstruida(this.getImobiliario().getAreaTotalConstruida());
        cadastroImobiliario.setComplementoLote(this.getImobiliario().getComplementoLote());
        return cadastroImobiliario;
    }

    @Generated
    public CadastroGeralPostElogeoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public TipoCadastro getTipo() {
        return this.tipo;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public String getEnglobado() {
        return this.englobado;
    }

    @Generated
    public String getCorrespondenciaLocal() {
        return this.correspondenciaLocal;
    }

    @Generated
    public BairroElogeoDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public CadastroImobiliarioElogeoDTO getImobiliario() {
        return this.imobiliario;
    }

    @Generated
    public List<ProprietarioElogeoDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setTipo(TipoCadastro tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setEnglobado(String englobado) {
        this.englobado = englobado;
    }

    @Generated
    public void setCorrespondenciaLocal(String correspondenciaLocal) {
        this.correspondenciaLocal = correspondenciaLocal;
    }

    @Generated
    public void setBairro(BairroElogeoDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setImobiliario(CadastroImobiliarioElogeoDTO imobiliario) {
        this.imobiliario = imobiliario;
    }

    @Generated
    public void setProprietarios(List<ProprietarioElogeoDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeralPostElogeoDTO)) {
            return false;
        }
        CadastroGeralPostElogeoDTO other = (CadastroGeralPostElogeoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep)) {
            return false;
        }
        TipoCadastro this$tipo = this.getTipo();
        TipoCadastro other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$englobado = this.getEnglobado();
        String other$englobado = other.getEnglobado();
        if (this$englobado == null ? other$englobado != null : !this$englobado.equals(other$englobado)) {
            return false;
        }
        String this$correspondenciaLocal = this.getCorrespondenciaLocal();
        String other$correspondenciaLocal = other.getCorrespondenciaLocal();
        if (this$correspondenciaLocal == null ? other$correspondenciaLocal != null : !this$correspondenciaLocal.equals(other$correspondenciaLocal)) {
            return false;
        }
        BairroElogeoDTO this$bairro = this.getBairro();
        BairroElogeoDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        CadastroImobiliarioElogeoDTO this$imobiliario = this.getImobiliario();
        CadastroImobiliarioElogeoDTO other$imobiliario = other.getImobiliario();
        if (this$imobiliario == null ? other$imobiliario != null : !this$imobiliario.equals(other$imobiliario)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        return !(this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeralPostElogeoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        TipoCadastro $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $englobado = this.getEnglobado();
        result = result * 59 + ($englobado == null ? 43 : $englobado.hashCode());
        String $correspondenciaLocal = this.getCorrespondenciaLocal();
        result = result * 59 + ($correspondenciaLocal == null ? 43 : $correspondenciaLocal.hashCode());
        BairroElogeoDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        CadastroImobiliarioElogeoDTO $imobiliario = this.getImobiliario();
        result = result * 59 + ($imobiliario == null ? 43 : $imobiliario.hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroGeralPostElogeoDTO(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", tipo=" + this.getTipo() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cep=" + this.getCep() + ", englobado=" + this.getEnglobado() + ", correspondenciaLocal=" + this.getCorrespondenciaLocal() + ", bairro=" + this.getBairro() + ", imobiliario=" + this.getImobiliario() + ", proprietarios=" + this.getProprietarios() + ")";
    }
}

