/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.sicoob.boletoregistrado;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PagadorBoletoRegistradoSicoobDTO {
    public String numeroCpfCnpj;
    public String nome;
    public String endereco;
    public String bairro;
    public String cidade;
    public String cep;
    public String uf;

    public static PagadorBoletoRegistradoSicoobDTO from(Bloqueto boleto) {
        PagadorBoletoRegistradoSicoobDTO dto = new PagadorBoletoRegistradoSicoobDTO();
        dto.setNumeroCpfCnpj(boleto.getPessoa().getCnpjCpfSemMascara());
        dto.setNome(StringUtils.substring((String)boleto.getPessoa().getNome(), (int)0, (int)50));
        dto.setEndereco(PagadorBoletoRegistradoSicoobDTO.loadEnderecoPrincipal((EnderecoPessoa)boleto.getPessoa().getEnderecoPrincipal()));
        Optional.ofNullable(boleto.getPessoa().getEnderecoPrincipal().getBairro()).map(Bairro::getDescricao).map(desc -> desc.length() > 30 ? desc.substring(0, 30) : desc).ifPresent(arg_0 -> dto.setBairro(arg_0));
        Optional.ofNullable(boleto.getPessoa().getEnderecoPrincipal().getCidade()).map(Cidade::getDescricao).map(desc -> desc.length() > 40 ? desc.substring(0, 40) : desc).ifPresent(arg_0 -> dto.setCidade(arg_0));
        dto.setCep((String)Optional.ofNullable(boleto.getPessoa().getEnderecoPrincipal().getCep()).map(cep -> StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(null));
        Optional.ofNullable(boleto.getPessoa().getEnderecoPrincipal().getUnidadeFederacao()).map(UnidadeFederacao::getUnidadeFederacao).ifPresent(arg_0 -> dto.setUf(arg_0));
        return dto;
    }

    private static String loadEnderecoPrincipal(EnderecoPessoa enderecoPrincipal) {
        return StringUtils.substring((String)StringUtils.normalizeSpace((String)String.format("%s %s %s %s", Optional.ofNullable(enderecoPrincipal.getLogradouro()).map(Logradouro::getTipoLogradouroDescricao).orElse(""), Optional.ofNullable(enderecoPrincipal.getLogradouro()).map(Logradouro::getDescricao).orElse(""), Optional.ofNullable(enderecoPrincipal.getNumero()).orElse(""), Optional.ofNullable(enderecoPrincipal.getComplemento()).orElse(""))), (int)0, (int)40);
    }

    @Generated
    public PagadorBoletoRegistradoSicoobDTO() {
    }

    @Generated
    public String getNumeroCpfCnpj() {
        return this.numeroCpfCnpj;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getEndereco() {
        return this.endereco;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public void setNumeroCpfCnpj(String numeroCpfCnpj) {
        this.numeroCpfCnpj = numeroCpfCnpj;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagadorBoletoRegistradoSicoobDTO)) {
            return false;
        }
        PagadorBoletoRegistradoSicoobDTO other = (PagadorBoletoRegistradoSicoobDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$numeroCpfCnpj = this.getNumeroCpfCnpj();
        String other$numeroCpfCnpj = other.getNumeroCpfCnpj();
        if (this$numeroCpfCnpj == null ? other$numeroCpfCnpj != null : !this$numeroCpfCnpj.equals(other$numeroCpfCnpj)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$endereco = this.getEndereco();
        String other$endereco = other.getEndereco();
        if (this$endereco == null ? other$endereco != null : !this$endereco.equals(other$endereco)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$uf = this.getUf();
        String other$uf = other.getUf();
        return !(this$uf == null ? other$uf != null : !this$uf.equals(other$uf));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagadorBoletoRegistradoSicoobDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $numeroCpfCnpj = this.getNumeroCpfCnpj();
        result = result * 59 + ($numeroCpfCnpj == null ? 43 : $numeroCpfCnpj.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $endereco = this.getEndereco();
        result = result * 59 + ($endereco == null ? 43 : $endereco.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $uf = this.getUf();
        result = result * 59 + ($uf == null ? 43 : $uf.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagadorBoletoRegistradoSicoobDTO(numeroCpfCnpj=" + this.getNumeroCpfCnpj() + ", nome=" + this.getNome() + ", endereco=" + this.getEndereco() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", cep=" + this.getCep() + ", uf=" + this.getUf() + ")";
    }
}

