/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.debitoautomatico;

import br.com.elotech.tributos.domain.DebitoAutomaticoOpcao;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class DebitoAutomaticoOpcaoDTO {
    private Long idDebitoAutomatico;
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long guiaRecolhimento;
    private Long subDivida;
    private String identificacao;
    private String identificacaoOrigem;
    private LocalDate dataAutorizacao;
    private LocalDate dataImplantacao;
    private LocalDate dataExclusao;
    private String usuarioExclusao;
    private Long convenio;
    private String convenioDescricao;
    private Long banco;
    private String bancoDescricao;
    private String agencia;

    public static DebitoAutomaticoOpcaoDTO from(DebitoAutomaticoOpcao opcao) {
        DebitoAutomaticoOpcaoDTO dto = new DebitoAutomaticoOpcaoDTO();
        dto.setIdDebitoAutomatico(opcao.getTipoDebitoAutomatico());
        dto.setEntidade(opcao.getEntidade());
        dto.setExercicio(opcao.getExercicio());
        dto.setTipoCadastro(opcao.getTipoCadastro());
        dto.setCadastroGeral(opcao.getCadastroGeral());
        dto.setGuiaRecolhimento(opcao.getGuiaRecolhimento());
        dto.setSubDivida(opcao.getSubDivida());
        dto.setIdentificacao(opcao.getIdentificacao());
        dto.setIdentificacaoOrigem(opcao.getIdentificacaoOrigem());
        dto.setDataAutorizacao(opcao.getDataAutorizacao());
        dto.setDataImplantacao(opcao.getDataImplantacao());
        dto.setDataExclusao(opcao.getDataExclusao());
        dto.setUsuarioExclusao(opcao.getUsuarioExclusao());
        Optional.ofNullable(opcao.getConvenio()).ifPresent(convenio -> {
            dto.setConvenio(convenio.getConvenio());
            dto.setConvenioDescricao(convenio.getDescricao());
        });
        Optional.ofNullable(opcao.getBanco()).ifPresent(banco -> {
            dto.setBanco(banco.getId());
            dto.setBancoDescricao(banco.getDescricao());
        });
        dto.setAgencia(opcao.getAgencia());
        return dto;
    }

    @Generated
    public DebitoAutomaticoOpcaoDTO() {
    }

    @Generated
    public Long getIdDebitoAutomatico() {
        return this.idDebitoAutomatico;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getIdentificacao() {
        return this.identificacao;
    }

    @Generated
    public String getIdentificacaoOrigem() {
        return this.identificacaoOrigem;
    }

    @Generated
    public LocalDate getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    @Generated
    public LocalDate getDataImplantacao() {
        return this.dataImplantacao;
    }

    @Generated
    public LocalDate getDataExclusao() {
        return this.dataExclusao;
    }

    @Generated
    public String getUsuarioExclusao() {
        return this.usuarioExclusao;
    }

    @Generated
    public Long getConvenio() {
        return this.convenio;
    }

    @Generated
    public String getConvenioDescricao() {
        return this.convenioDescricao;
    }

    @Generated
    public Long getBanco() {
        return this.banco;
    }

    @Generated
    public String getBancoDescricao() {
        return this.bancoDescricao;
    }

    @Generated
    public String getAgencia() {
        return this.agencia;
    }

    @Generated
    public void setIdDebitoAutomatico(Long idDebitoAutomatico) {
        this.idDebitoAutomatico = idDebitoAutomatico;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setIdentificacao(String identificacao) {
        this.identificacao = identificacao;
    }

    @Generated
    public void setIdentificacaoOrigem(String identificacaoOrigem) {
        this.identificacaoOrigem = identificacaoOrigem;
    }

    @Generated
    public void setDataAutorizacao(LocalDate dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    @Generated
    public void setDataImplantacao(LocalDate dataImplantacao) {
        this.dataImplantacao = dataImplantacao;
    }

    @Generated
    public void setDataExclusao(LocalDate dataExclusao) {
        this.dataExclusao = dataExclusao;
    }

    @Generated
    public void setUsuarioExclusao(String usuarioExclusao) {
        this.usuarioExclusao = usuarioExclusao;
    }

    @Generated
    public void setConvenio(Long convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setConvenioDescricao(String convenioDescricao) {
        this.convenioDescricao = convenioDescricao;
    }

    @Generated
    public void setBanco(Long banco) {
        this.banco = banco;
    }

    @Generated
    public void setBancoDescricao(String bancoDescricao) {
        this.bancoDescricao = bancoDescricao;
    }

    @Generated
    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoAutomaticoOpcaoDTO)) {
            return false;
        }
        DebitoAutomaticoOpcaoDTO other = (DebitoAutomaticoOpcaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebitoAutomatico = this.getIdDebitoAutomatico();
        Long other$idDebitoAutomatico = other.getIdDebitoAutomatico();
        if (this$idDebitoAutomatico == null ? other$idDebitoAutomatico != null : !((Object)this$idDebitoAutomatico).equals(other$idDebitoAutomatico)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$guiaRecolhimento = this.getGuiaRecolhimento();
        Long other$guiaRecolhimento = other.getGuiaRecolhimento();
        if (this$guiaRecolhimento == null ? other$guiaRecolhimento != null : !((Object)this$guiaRecolhimento).equals(other$guiaRecolhimento)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$convenio = this.getConvenio();
        Long other$convenio = other.getConvenio();
        if (this$convenio == null ? other$convenio != null : !((Object)this$convenio).equals(other$convenio)) {
            return false;
        }
        Long this$banco = this.getBanco();
        Long other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !((Object)this$banco).equals(other$banco)) {
            return false;
        }
        String this$identificacao = this.getIdentificacao();
        String other$identificacao = other.getIdentificacao();
        if (this$identificacao == null ? other$identificacao != null : !this$identificacao.equals(other$identificacao)) {
            return false;
        }
        String this$identificacaoOrigem = this.getIdentificacaoOrigem();
        String other$identificacaoOrigem = other.getIdentificacaoOrigem();
        if (this$identificacaoOrigem == null ? other$identificacaoOrigem != null : !this$identificacaoOrigem.equals(other$identificacaoOrigem)) {
            return false;
        }
        LocalDate this$dataAutorizacao = this.getDataAutorizacao();
        LocalDate other$dataAutorizacao = other.getDataAutorizacao();
        if (this$dataAutorizacao == null ? other$dataAutorizacao != null : !((Object)this$dataAutorizacao).equals(other$dataAutorizacao)) {
            return false;
        }
        LocalDate this$dataImplantacao = this.getDataImplantacao();
        LocalDate other$dataImplantacao = other.getDataImplantacao();
        if (this$dataImplantacao == null ? other$dataImplantacao != null : !((Object)this$dataImplantacao).equals(other$dataImplantacao)) {
            return false;
        }
        LocalDate this$dataExclusao = this.getDataExclusao();
        LocalDate other$dataExclusao = other.getDataExclusao();
        if (this$dataExclusao == null ? other$dataExclusao != null : !((Object)this$dataExclusao).equals(other$dataExclusao)) {
            return false;
        }
        String this$usuarioExclusao = this.getUsuarioExclusao();
        String other$usuarioExclusao = other.getUsuarioExclusao();
        if (this$usuarioExclusao == null ? other$usuarioExclusao != null : !this$usuarioExclusao.equals(other$usuarioExclusao)) {
            return false;
        }
        String this$convenioDescricao = this.getConvenioDescricao();
        String other$convenioDescricao = other.getConvenioDescricao();
        if (this$convenioDescricao == null ? other$convenioDescricao != null : !this$convenioDescricao.equals(other$convenioDescricao)) {
            return false;
        }
        String this$bancoDescricao = this.getBancoDescricao();
        String other$bancoDescricao = other.getBancoDescricao();
        if (this$bancoDescricao == null ? other$bancoDescricao != null : !this$bancoDescricao.equals(other$bancoDescricao)) {
            return false;
        }
        String this$agencia = this.getAgencia();
        String other$agencia = other.getAgencia();
        return !(this$agencia == null ? other$agencia != null : !this$agencia.equals(other$agencia));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoAutomaticoOpcaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebitoAutomatico = this.getIdDebitoAutomatico();
        result = result * 59 + ($idDebitoAutomatico == null ? 43 : ((Object)$idDebitoAutomatico).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $guiaRecolhimento = this.getGuiaRecolhimento();
        result = result * 59 + ($guiaRecolhimento == null ? 43 : ((Object)$guiaRecolhimento).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : ((Object)$convenio).hashCode());
        Long $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : ((Object)$banco).hashCode());
        String $identificacao = this.getIdentificacao();
        result = result * 59 + ($identificacao == null ? 43 : $identificacao.hashCode());
        String $identificacaoOrigem = this.getIdentificacaoOrigem();
        result = result * 59 + ($identificacaoOrigem == null ? 43 : $identificacaoOrigem.hashCode());
        LocalDate $dataAutorizacao = this.getDataAutorizacao();
        result = result * 59 + ($dataAutorizacao == null ? 43 : ((Object)$dataAutorizacao).hashCode());
        LocalDate $dataImplantacao = this.getDataImplantacao();
        result = result * 59 + ($dataImplantacao == null ? 43 : ((Object)$dataImplantacao).hashCode());
        LocalDate $dataExclusao = this.getDataExclusao();
        result = result * 59 + ($dataExclusao == null ? 43 : ((Object)$dataExclusao).hashCode());
        String $usuarioExclusao = this.getUsuarioExclusao();
        result = result * 59 + ($usuarioExclusao == null ? 43 : $usuarioExclusao.hashCode());
        String $convenioDescricao = this.getConvenioDescricao();
        result = result * 59 + ($convenioDescricao == null ? 43 : $convenioDescricao.hashCode());
        String $bancoDescricao = this.getBancoDescricao();
        result = result * 59 + ($bancoDescricao == null ? 43 : $bancoDescricao.hashCode());
        String $agencia = this.getAgencia();
        result = result * 59 + ($agencia == null ? 43 : $agencia.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoAutomaticoOpcaoDTO(idDebitoAutomatico=" + this.getIdDebitoAutomatico() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", subDivida=" + this.getSubDivida() + ", identificacao=" + this.getIdentificacao() + ", identificacaoOrigem=" + this.getIdentificacaoOrigem() + ", dataAutorizacao=" + this.getDataAutorizacao() + ", dataImplantacao=" + this.getDataImplantacao() + ", dataExclusao=" + this.getDataExclusao() + ", usuarioExclusao=" + this.getUsuarioExclusao() + ", convenio=" + this.getConvenio() + ", convenioDescricao=" + this.getConvenioDescricao() + ", banco=" + this.getBanco() + ", bancoDescricao=" + this.getBancoDescricao() + ", agencia=" + this.getAgencia() + ")";
    }
}

