/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.DocumentoDTO;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class ProtestoDTO {
    private Long id;
    private Long entidade;
    private Long exercicio;
    private Long protesto;
    private LocalDate dataEmissao;
    private LocalDate dataCancelamento;
    private Integer situacao;
    private DocumentoDTO documento;
    private String idTermoS3;
    private Long remessa;
    private Long exercicioRemessa;
    private String usuarioCancelamento;
    private String usuarioGerador;
    private String cartorio;

    public static ProtestoDTO from(Protesto protesto) {
        ProtestoDTO protestoDTO = new ProtestoDTO();
        protestoDTO.setId(protesto.getId());
        protestoDTO.setEntidade(protesto.getEntidade());
        protestoDTO.setExercicio(protesto.getExercicio());
        protestoDTO.setDataEmissao(protesto.getDataEmissao());
        protestoDTO.setDataCancelamento(protesto.getDataCancelamento());
        protestoDTO.setUsuarioCancelamento(protesto.getUsuarioCancelamento());
        protestoDTO.setProtesto(protesto.getProtesto());
        protestoDTO.setUsuarioGerador(protesto.getUsuario());
        Optional.ofNullable(protesto.getSituacao()).ifPresent(situacao -> protestoDTO.setSituacao(situacao.getCodigo()));
        Optional.ofNullable(protesto.getIdTermoProtestoS3()).ifPresent(id -> protestoDTO.setIdTermoS3(id.toString()));
        Optional.ofNullable(protesto.getDocumento()).ifPresent(documento -> protestoDTO.setDocumento(DocumentoDTO.from((Documento)documento)));
        return protestoDTO;
    }

    public static ProtestoDTO from(Protesto protesto, String cartorio) {
        ProtestoDTO protestoDTO = new ProtestoDTO();
        protestoDTO.setId(protesto.getId());
        protestoDTO.setEntidade(protesto.getEntidade());
        protestoDTO.setExercicio(protesto.getExercicio());
        protestoDTO.setDataEmissao(protesto.getDataEmissao());
        protestoDTO.setDataCancelamento(protesto.getDataCancelamento());
        protestoDTO.setUsuarioCancelamento(protesto.getUsuarioCancelamento());
        protestoDTO.setProtesto(protesto.getProtesto());
        protestoDTO.setUsuarioGerador(protesto.getUsuario());
        protestoDTO.setCartorio(cartorio);
        Optional.ofNullable(protesto.getSituacao()).ifPresent(situacao -> protestoDTO.setSituacao(situacao.getCodigo()));
        Optional.ofNullable(protesto.getIdTermoProtestoS3()).ifPresent(id -> protestoDTO.setIdTermoS3(id.toString()));
        Optional.ofNullable(protesto.getDocumento()).ifPresent(documento -> protestoDTO.setDocumento(DocumentoDTO.from((Documento)documento)));
        return protestoDTO;
    }

    @Generated
    public ProtestoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getProtesto() {
        return this.protesto;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public Integer getSituacao() {
        return this.situacao;
    }

    @Generated
    public DocumentoDTO getDocumento() {
        return this.documento;
    }

    @Generated
    public String getIdTermoS3() {
        return this.idTermoS3;
    }

    @Generated
    public Long getRemessa() {
        return this.remessa;
    }

    @Generated
    public Long getExercicioRemessa() {
        return this.exercicioRemessa;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public String getUsuarioGerador() {
        return this.usuarioGerador;
    }

    @Generated
    public String getCartorio() {
        return this.cartorio;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setProtesto(Long protesto) {
        this.protesto = protesto;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setSituacao(Integer situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDocumento(DocumentoDTO documento) {
        this.documento = documento;
    }

    @Generated
    public void setIdTermoS3(String idTermoS3) {
        this.idTermoS3 = idTermoS3;
    }

    @Generated
    public void setRemessa(Long remessa) {
        this.remessa = remessa;
    }

    @Generated
    public void setExercicioRemessa(Long exercicioRemessa) {
        this.exercicioRemessa = exercicioRemessa;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setUsuarioGerador(String usuarioGerador) {
        this.usuarioGerador = usuarioGerador;
    }

    @Generated
    public void setCartorio(String cartorio) {
        this.cartorio = cartorio;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtestoDTO)) {
            return false;
        }
        ProtestoDTO other = (ProtestoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$protesto = this.getProtesto();
        Long other$protesto = other.getProtesto();
        if (this$protesto == null ? other$protesto != null : !((Object)this$protesto).equals(other$protesto)) {
            return false;
        }
        Integer this$situacao = this.getSituacao();
        Integer other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !((Object)this$situacao).equals(other$situacao)) {
            return false;
        }
        Long this$remessa = this.getRemessa();
        Long other$remessa = other.getRemessa();
        if (this$remessa == null ? other$remessa != null : !((Object)this$remessa).equals(other$remessa)) {
            return false;
        }
        Long this$exercicioRemessa = this.getExercicioRemessa();
        Long other$exercicioRemessa = other.getExercicioRemessa();
        if (this$exercicioRemessa == null ? other$exercicioRemessa != null : !((Object)this$exercicioRemessa).equals(other$exercicioRemessa)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        LocalDate this$dataCancelamento = this.getDataCancelamento();
        LocalDate other$dataCancelamento = other.getDataCancelamento();
        if (this$dataCancelamento == null ? other$dataCancelamento != null : !((Object)this$dataCancelamento).equals(other$dataCancelamento)) {
            return false;
        }
        DocumentoDTO this$documento = this.getDocumento();
        DocumentoDTO other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !this$documento.equals(other$documento)) {
            return false;
        }
        String this$idTermoS3 = this.getIdTermoS3();
        String other$idTermoS3 = other.getIdTermoS3();
        if (this$idTermoS3 == null ? other$idTermoS3 != null : !this$idTermoS3.equals(other$idTermoS3)) {
            return false;
        }
        String this$usuarioCancelamento = this.getUsuarioCancelamento();
        String other$usuarioCancelamento = other.getUsuarioCancelamento();
        if (this$usuarioCancelamento == null ? other$usuarioCancelamento != null : !this$usuarioCancelamento.equals(other$usuarioCancelamento)) {
            return false;
        }
        String this$usuarioGerador = this.getUsuarioGerador();
        String other$usuarioGerador = other.getUsuarioGerador();
        if (this$usuarioGerador == null ? other$usuarioGerador != null : !this$usuarioGerador.equals(other$usuarioGerador)) {
            return false;
        }
        String this$cartorio = this.getCartorio();
        String other$cartorio = other.getCartorio();
        return !(this$cartorio == null ? other$cartorio != null : !this$cartorio.equals(other$cartorio));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtestoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $protesto = this.getProtesto();
        result = result * 59 + ($protesto == null ? 43 : ((Object)$protesto).hashCode());
        Integer $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : ((Object)$situacao).hashCode());
        Long $remessa = this.getRemessa();
        result = result * 59 + ($remessa == null ? 43 : ((Object)$remessa).hashCode());
        Long $exercicioRemessa = this.getExercicioRemessa();
        result = result * 59 + ($exercicioRemessa == null ? 43 : ((Object)$exercicioRemessa).hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        LocalDate $dataCancelamento = this.getDataCancelamento();
        result = result * 59 + ($dataCancelamento == null ? 43 : ((Object)$dataCancelamento).hashCode());
        DocumentoDTO $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : $documento.hashCode());
        String $idTermoS3 = this.getIdTermoS3();
        result = result * 59 + ($idTermoS3 == null ? 43 : $idTermoS3.hashCode());
        String $usuarioCancelamento = this.getUsuarioCancelamento();
        result = result * 59 + ($usuarioCancelamento == null ? 43 : $usuarioCancelamento.hashCode());
        String $usuarioGerador = this.getUsuarioGerador();
        result = result * 59 + ($usuarioGerador == null ? 43 : $usuarioGerador.hashCode());
        String $cartorio = this.getCartorio();
        result = result * 59 + ($cartorio == null ? 43 : $cartorio.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProtestoDTO(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", protesto=" + this.getProtesto() + ", dataEmissao=" + this.getDataEmissao() + ", dataCancelamento=" + this.getDataCancelamento() + ", situacao=" + this.getSituacao() + ", documento=" + this.getDocumento() + ", idTermoS3=" + this.getIdTermoS3() + ", remessa=" + this.getRemessa() + ", exercicioRemessa=" + this.getExercicioRemessa() + ", usuarioCancelamento=" + this.getUsuarioCancelamento() + ", usuarioGerador=" + this.getUsuarioGerador() + ", cartorio=" + this.getCartorio() + ")";
    }
}

