/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.enums.TipoFiltroBoolean;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroConsultaDebitoDTO {
    private Pessoa pessoa;
    private TipoCadastro tipoCadastro;
    private String cadastroGeral;
    private String anoDebito;
    private String divida;
    private String subDivida;
    private LocalDate dataLancamentoInicial;
    private LocalDate dataLancamentoFinal;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private Boolean noExercicio = Boolean.FALSE;
    private Boolean dividaAtiva = Boolean.FALSE;
    private Boolean juizo = Boolean.FALSE;
    private Long situacaoParcela;
    private Boolean somenteParcelasEmAberto;
    private Boolean calcularAcrescimos = Boolean.FALSE;
    private LocalDate dataReferencia;
    private Long qtdParcelasVencidas;
    private BigDecimal valorMinimo = BigDecimal.ZERO;
    private BigDecimal valorMaximo = BigDecimal.ZERO;
    private Cidade cidade;
    private Bairro bairro;
    private Logradouro logradouro;
    private String complemento;
    private String numero;
    private String pessoaRange;
    private String parcela;
    private TipoFiltroBoolean parcelado = TipoFiltroBoolean.TODOS;
    private TipoFiltroBoolean reparcelado = TipoFiltroBoolean.TODOS;
    private Long debitosProtestados;
    private String anoBase;
    @NotNull
    private ConsultaDebitoTipoAgrupamento tipoAgrupamento;
    private static final String SITUACAO_LEGAL = "TDP.SITUACAOLEGAL = %d";
    private static final String sqlAnoBase = "EXISTS ( SELECT 1 FROM TRIBDEBITOPARCELA TDP1  INNER JOIN TRIBSITUACAOPARCELA TSP1   ON TDP1.SITUACAODEBITO = TSP1.SITUACAOPARCELA INNER JOIN TRIBTIPOSITUACAOPARCELA TTSP1   ON TSP1.TIPOSITUACAOPARCELA = TTSP1.TIPOSITUACAOPARCELA WHERE TDP1.ENTIDADE = TD.ENTIDADE ";
    private static final Long COM_PROTESTO = 2L;
    private static final Long SEM_PROTESTO = 3L;

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    public String generateWhere() {
        StringBuilder where = new StringBuilder();
        if (Boolean.TRUE.equals(this.calcularAcrescimos) && Objects.isNull(this.dataReferencia)) {
            throw new EloValidationException("A data da refer\u00eancia \u00e9 obrigat\u00f3ria para calcular o acr\u00e9scimo.");
        }
        if (ConsultaDebitoTipoAgrupamento.SALDO_ANALITICO_CONTRIBUINTE_PRIMEIRA_CARGA.equals((Object)this.tipoAgrupamento)) {
            where.append(this.addAND(String.format("P.TIPOPESSOA = '%s'", TipoPessoa.JURIDICA.getValue())));
        }
        if (Objects.nonNull(this.pessoa)) {
            where.append(this.addAND(String.format("P.PESSOA = %d", this.pessoa.getId())));
        }
        if (Objects.nonNull(this.pessoaRange)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.pessoaRange, (String)"P.PESSOA")));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            where.append(this.addAND(String.format("TD.TIPOCADASTRO = %d", this.tipoCadastro.getValue())));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"TD.CADASTROGERAL")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.anoDebito)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoDebito, (String)"TD.EXERCICIO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"TD.GUIARECOLHIMENTO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"TD.SUBDIVIDA")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.parcela)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.parcela, (String)"TDP.PARCELA")));
        }
        if (Objects.nonNull(this.dataLancamentoInicial)) {
            where.append(this.addAND(String.format("TD.DATALANCAMENTO >= '%s'", DateUtils.localDateToString((LocalDate)this.dataLancamentoInicial))));
        }
        if (Objects.nonNull(this.dataLancamentoFinal)) {
            where.append(this.addAND(String.format("TD.DATALANCAMENTO <= '%s'", DateUtils.localDateToString((LocalDate)this.dataLancamentoFinal))));
        }
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            where.append(this.addAND(String.format("TDP.DATAVENCIMENTO >= '%s'", DateUtils.localDateToString((LocalDate)this.dataVencimentoInicial))));
        }
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            where.append(this.addAND(String.format("TDP.DATAVENCIMENTO <= '%s'", DateUtils.localDateToString((LocalDate)this.dataVencimentoFinal))));
        }
        if (Objects.nonNull(this.situacaoParcela)) {
            where.append(this.addAND(String.format("TSP.SITUACAOPARCELA = %d", this.situacaoParcela)));
        }
        if (Boolean.TRUE.equals(this.somenteParcelasEmAberto)) {
            where.append(this.addAND("TTSP.TIPO = 'A'"));
        }
        if (!TipoFiltroBoolean.TODOS.equals((Object)this.getParcelado())) {
            where.append(this.addAND(String.format("TD.PARCELADO = '%s'", this.getParcelado().getValue())));
        }
        if (!TipoFiltroBoolean.TODOS.equals((Object)this.getReparcelado())) {
            where.append(this.addAND(String.format("TD.REPARCELADO = '%s'", this.getReparcelado().getValue())));
        }
        if (Objects.nonNull(this.cidade)) {
            where.append(this.addAND(String.format("TCG.CIDADE = %d", this.cidade.getId())));
        }
        if (Objects.nonNull(this.bairro)) {
            where.append(this.addAND(String.format("TCG.BAIRRO = %d", this.bairro.getBairro())));
        }
        if (Objects.nonNull(this.logradouro)) {
            where.append(this.addAND(String.format("TCG.LOGRADOURO = %d", this.logradouro.getLogradouro())));
        }
        if (StringUtils.isNotBlank((CharSequence)this.complemento)) {
            where.append(this.addAND(String.format("TCG.COMPLEMENTO = '%s'", this.complemento)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.numero)) {
            where.append(this.addAND(String.format("TCG.NUMERO = '%s'", this.numero)));
        }
        if (Boolean.TRUE.equals(this.noExercicio) || Boolean.TRUE.equals(this.dividaAtiva) || Boolean.TRUE.equals(this.juizo)) {
            where.append(this.addAND(this.buildFiltroSituacaoLegal("TDP")));
        }
        if (Objects.nonNull(this.debitosProtestados)) {
            if (COM_PROTESTO.equals(this.debitosProtestados)) {
                where.append(this.addAND("(TDP.IDPROTESTO > 0)"));
            } else if (SEM_PROTESTO.equals(this.debitosProtestados)) {
                where.append(this.addAND("(TDP.IDPROTESTO IS NULL)"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.anoBase)) {
            where.append(this.addAND(sqlAnoBase));
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoBase, (String)"TDP1.EXERCICIO")));
            where.append(this.addAND("TDP1.TIPOCADASTRO = TD.TIPOCADASTRO"));
            where.append(this.addAND("TDP1.CADASTROGERAL = TD.CADASTROGERAL"));
            if (StringUtils.isNotBlank((CharSequence)this.divida)) {
                where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"TDP1.GUIARECOLHIMENTO")));
            }
            where.append(this.addAND("TTSP1.TIPO = 'A'"));
            if (Boolean.TRUE.equals(this.noExercicio) || Boolean.TRUE.equals(this.dividaAtiva) || Boolean.TRUE.equals(this.juizo)) {
                where.append(this.addAND(this.buildFiltroSituacaoLegal("TDP1")));
            }
            where.append(")");
        }
        return where.toString();
    }

    private String buildFiltroSituacaoLegal(String tableAlias) {
        StringBuilder situacaoLegal = new StringBuilder();
        situacaoLegal.append(tableAlias + ".SITUACAOLEGAL IN (");
        if (Boolean.TRUE.equals(this.noExercicio)) {
            situacaoLegal.append(SituacaoLegal.NO_EXERCICIO.getValue().toString()).append(", ");
        }
        if (Boolean.TRUE.equals(this.dividaAtiva)) {
            situacaoLegal.append(SituacaoLegal.DIVIDA_ATIVA.getValue().toString()).append(", ");
        }
        if (Boolean.TRUE.equals(this.juizo)) {
            situacaoLegal.append(SituacaoLegal.JUIZO.getValue().toString());
        }
        if (situacaoLegal.toString().endsWith(", ")) {
            situacaoLegal.append(")");
            return situacaoLegal.toString().replace(", )", ")");
        }
        situacaoLegal.append(")");
        return situacaoLegal.toString();
    }

    public String buildHaving() {
        StringBuilder having = new StringBuilder();
        if (Objects.nonNull(this.qtdParcelasVencidas) && this.qtdParcelasVencidas > 0L) {
            this.addHavingCondition(having, " COUNT(CASE WHEN TDP.datavencimento > CURRENT_DATE THEN 1 END) = %s ", this.qtdParcelasVencidas.toString());
        }
        if (BigDecimal.ZERO.compareTo(this.valorMinimo) < 0) {
            this.addHavingCondition(having, " SUM(TDPR.VALOR) >= %s ", this.valorMinimo.toString());
        }
        if (BigDecimal.ZERO.compareTo(this.valorMaximo) < 0) {
            this.addHavingCondition(having, " SUM(TDPR.VALOR) <= %s ", this.valorMaximo.toString());
        }
        return having.toString();
    }

    private void addHavingCondition(StringBuilder having, String conditionTemplate, String value) {
        if (having.length() > 0) {
            having.append(" AND ");
        } else {
            having.append("HAVING ");
        }
        having.append(String.format(conditionTemplate, value));
    }

    @Generated
    public FiltroConsultaDebitoDTO() {
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getAnoDebito() {
        return this.anoDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataLancamentoInicial() {
        return this.dataLancamentoInicial;
    }

    @Generated
    public LocalDate getDataLancamentoFinal() {
        return this.dataLancamentoFinal;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public Boolean getNoExercicio() {
        return this.noExercicio;
    }

    @Generated
    public Boolean getDividaAtiva() {
        return this.dividaAtiva;
    }

    @Generated
    public Boolean getJuizo() {
        return this.juizo;
    }

    @Generated
    public Long getSituacaoParcela() {
        return this.situacaoParcela;
    }

    @Generated
    public Boolean getSomenteParcelasEmAberto() {
        return this.somenteParcelasEmAberto;
    }

    @Generated
    public Boolean getCalcularAcrescimos() {
        return this.calcularAcrescimos;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public Long getQtdParcelasVencidas() {
        return this.qtdParcelasVencidas;
    }

    @Generated
    public BigDecimal getValorMinimo() {
        return this.valorMinimo;
    }

    @Generated
    public BigDecimal getValorMaximo() {
        return this.valorMaximo;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public Bairro getBairro() {
        return this.bairro;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getPessoaRange() {
        return this.pessoaRange;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public TipoFiltroBoolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public TipoFiltroBoolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public Long getDebitosProtestados() {
        return this.debitosProtestados;
    }

    @Generated
    public String getAnoBase() {
        return this.anoBase;
    }

    @Generated
    public ConsultaDebitoTipoAgrupamento getTipoAgrupamento() {
        return this.tipoAgrupamento;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAnoDebito(String anoDebito) {
        this.anoDebito = anoDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataLancamentoInicial(LocalDate dataLancamentoInicial) {
        this.dataLancamentoInicial = dataLancamentoInicial;
    }

    @Generated
    public void setDataLancamentoFinal(LocalDate dataLancamentoFinal) {
        this.dataLancamentoFinal = dataLancamentoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setNoExercicio(Boolean noExercicio) {
        this.noExercicio = noExercicio;
    }

    @Generated
    public void setDividaAtiva(Boolean dividaAtiva) {
        this.dividaAtiva = dividaAtiva;
    }

    @Generated
    public void setJuizo(Boolean juizo) {
        this.juizo = juizo;
    }

    @Generated
    public void setSituacaoParcela(Long situacaoParcela) {
        this.situacaoParcela = situacaoParcela;
    }

    @Generated
    public void setSomenteParcelasEmAberto(Boolean somenteParcelasEmAberto) {
        this.somenteParcelasEmAberto = somenteParcelasEmAberto;
    }

    @Generated
    public void setCalcularAcrescimos(Boolean calcularAcrescimos) {
        this.calcularAcrescimos = calcularAcrescimos;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setQtdParcelasVencidas(Long qtdParcelasVencidas) {
        this.qtdParcelasVencidas = qtdParcelasVencidas;
    }

    @Generated
    public void setValorMinimo(BigDecimal valorMinimo) {
        this.valorMinimo = valorMinimo;
    }

    @Generated
    public void setValorMaximo(BigDecimal valorMaximo) {
        this.valorMaximo = valorMaximo;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setPessoaRange(String pessoaRange) {
        this.pessoaRange = pessoaRange;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setParcelado(TipoFiltroBoolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(TipoFiltroBoolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setDebitosProtestados(Long debitosProtestados) {
        this.debitosProtestados = debitosProtestados;
    }

    @Generated
    public void setAnoBase(String anoBase) {
        this.anoBase = anoBase;
    }

    @Generated
    public void setTipoAgrupamento(ConsultaDebitoTipoAgrupamento tipoAgrupamento) {
        this.tipoAgrupamento = tipoAgrupamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroConsultaDebitoDTO)) {
            return false;
        }
        FiltroConsultaDebitoDTO other = (FiltroConsultaDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$noExercicio = this.getNoExercicio();
        Boolean other$noExercicio = other.getNoExercicio();
        if (this$noExercicio == null ? other$noExercicio != null : !((Object)this$noExercicio).equals(other$noExercicio)) {
            return false;
        }
        Boolean this$dividaAtiva = this.getDividaAtiva();
        Boolean other$dividaAtiva = other.getDividaAtiva();
        if (this$dividaAtiva == null ? other$dividaAtiva != null : !((Object)this$dividaAtiva).equals(other$dividaAtiva)) {
            return false;
        }
        Boolean this$juizo = this.getJuizo();
        Boolean other$juizo = other.getJuizo();
        if (this$juizo == null ? other$juizo != null : !((Object)this$juizo).equals(other$juizo)) {
            return false;
        }
        Long this$situacaoParcela = this.getSituacaoParcela();
        Long other$situacaoParcela = other.getSituacaoParcela();
        if (this$situacaoParcela == null ? other$situacaoParcela != null : !((Object)this$situacaoParcela).equals(other$situacaoParcela)) {
            return false;
        }
        Boolean this$somenteParcelasEmAberto = this.getSomenteParcelasEmAberto();
        Boolean other$somenteParcelasEmAberto = other.getSomenteParcelasEmAberto();
        if (this$somenteParcelasEmAberto == null ? other$somenteParcelasEmAberto != null : !((Object)this$somenteParcelasEmAberto).equals(other$somenteParcelasEmAberto)) {
            return false;
        }
        Boolean this$calcularAcrescimos = this.getCalcularAcrescimos();
        Boolean other$calcularAcrescimos = other.getCalcularAcrescimos();
        if (this$calcularAcrescimos == null ? other$calcularAcrescimos != null : !((Object)this$calcularAcrescimos).equals(other$calcularAcrescimos)) {
            return false;
        }
        Long this$qtdParcelasVencidas = this.getQtdParcelasVencidas();
        Long other$qtdParcelasVencidas = other.getQtdParcelasVencidas();
        if (this$qtdParcelasVencidas == null ? other$qtdParcelasVencidas != null : !((Object)this$qtdParcelasVencidas).equals(other$qtdParcelasVencidas)) {
            return false;
        }
        Long this$debitosProtestados = this.getDebitosProtestados();
        Long other$debitosProtestados = other.getDebitosProtestados();
        if (this$debitosProtestados == null ? other$debitosProtestados != null : !((Object)this$debitosProtestados).equals(other$debitosProtestados)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$anoDebito = this.getAnoDebito();
        String other$anoDebito = other.getAnoDebito();
        if (this$anoDebito == null ? other$anoDebito != null : !this$anoDebito.equals(other$anoDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataLancamentoInicial = this.getDataLancamentoInicial();
        LocalDate other$dataLancamentoInicial = other.getDataLancamentoInicial();
        if (this$dataLancamentoInicial == null ? other$dataLancamentoInicial != null : !((Object)this$dataLancamentoInicial).equals(other$dataLancamentoInicial)) {
            return false;
        }
        LocalDate this$dataLancamentoFinal = this.getDataLancamentoFinal();
        LocalDate other$dataLancamentoFinal = other.getDataLancamentoFinal();
        if (this$dataLancamentoFinal == null ? other$dataLancamentoFinal != null : !((Object)this$dataLancamentoFinal).equals(other$dataLancamentoFinal)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        BigDecimal this$valorMinimo = this.getValorMinimo();
        BigDecimal other$valorMinimo = other.getValorMinimo();
        if (this$valorMinimo == null ? other$valorMinimo != null : !((Object)this$valorMinimo).equals(other$valorMinimo)) {
            return false;
        }
        BigDecimal this$valorMaximo = this.getValorMaximo();
        BigDecimal other$valorMaximo = other.getValorMaximo();
        if (this$valorMaximo == null ? other$valorMaximo != null : !((Object)this$valorMaximo).equals(other$valorMaximo)) {
            return false;
        }
        Cidade this$cidade = this.getCidade();
        Cidade other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        Bairro this$bairro = this.getBairro();
        Bairro other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        Logradouro this$logradouro = this.getLogradouro();
        Logradouro other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$pessoaRange = this.getPessoaRange();
        String other$pessoaRange = other.getPessoaRange();
        if (this$pessoaRange == null ? other$pessoaRange != null : !this$pessoaRange.equals(other$pessoaRange)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        TipoFiltroBoolean this$parcelado = this.getParcelado();
        TipoFiltroBoolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !this$parcelado.equals(other$parcelado)) {
            return false;
        }
        TipoFiltroBoolean this$reparcelado = this.getReparcelado();
        TipoFiltroBoolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !this$reparcelado.equals(other$reparcelado)) {
            return false;
        }
        String this$anoBase = this.getAnoBase();
        String other$anoBase = other.getAnoBase();
        if (this$anoBase == null ? other$anoBase != null : !this$anoBase.equals(other$anoBase)) {
            return false;
        }
        ConsultaDebitoTipoAgrupamento this$tipoAgrupamento = this.getTipoAgrupamento();
        ConsultaDebitoTipoAgrupamento other$tipoAgrupamento = other.getTipoAgrupamento();
        return !(this$tipoAgrupamento == null ? other$tipoAgrupamento != null : !this$tipoAgrupamento.equals(other$tipoAgrupamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroConsultaDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $noExercicio = this.getNoExercicio();
        result = result * 59 + ($noExercicio == null ? 43 : ((Object)$noExercicio).hashCode());
        Boolean $dividaAtiva = this.getDividaAtiva();
        result = result * 59 + ($dividaAtiva == null ? 43 : ((Object)$dividaAtiva).hashCode());
        Boolean $juizo = this.getJuizo();
        result = result * 59 + ($juizo == null ? 43 : ((Object)$juizo).hashCode());
        Long $situacaoParcela = this.getSituacaoParcela();
        result = result * 59 + ($situacaoParcela == null ? 43 : ((Object)$situacaoParcela).hashCode());
        Boolean $somenteParcelasEmAberto = this.getSomenteParcelasEmAberto();
        result = result * 59 + ($somenteParcelasEmAberto == null ? 43 : ((Object)$somenteParcelasEmAberto).hashCode());
        Boolean $calcularAcrescimos = this.getCalcularAcrescimos();
        result = result * 59 + ($calcularAcrescimos == null ? 43 : ((Object)$calcularAcrescimos).hashCode());
        Long $qtdParcelasVencidas = this.getQtdParcelasVencidas();
        result = result * 59 + ($qtdParcelasVencidas == null ? 43 : ((Object)$qtdParcelasVencidas).hashCode());
        Long $debitosProtestados = this.getDebitosProtestados();
        result = result * 59 + ($debitosProtestados == null ? 43 : ((Object)$debitosProtestados).hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $anoDebito = this.getAnoDebito();
        result = result * 59 + ($anoDebito == null ? 43 : $anoDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LocalDate $dataLancamentoInicial = this.getDataLancamentoInicial();
        result = result * 59 + ($dataLancamentoInicial == null ? 43 : ((Object)$dataLancamentoInicial).hashCode());
        LocalDate $dataLancamentoFinal = this.getDataLancamentoFinal();
        result = result * 59 + ($dataLancamentoFinal == null ? 43 : ((Object)$dataLancamentoFinal).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        BigDecimal $valorMinimo = this.getValorMinimo();
        result = result * 59 + ($valorMinimo == null ? 43 : ((Object)$valorMinimo).hashCode());
        BigDecimal $valorMaximo = this.getValorMaximo();
        result = result * 59 + ($valorMaximo == null ? 43 : ((Object)$valorMaximo).hashCode());
        Cidade $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        Bairro $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        Logradouro $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $pessoaRange = this.getPessoaRange();
        result = result * 59 + ($pessoaRange == null ? 43 : $pessoaRange.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        TipoFiltroBoolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : $parcelado.hashCode());
        TipoFiltroBoolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : $reparcelado.hashCode());
        String $anoBase = this.getAnoBase();
        result = result * 59 + ($anoBase == null ? 43 : $anoBase.hashCode());
        ConsultaDebitoTipoAgrupamento $tipoAgrupamento = this.getTipoAgrupamento();
        result = result * 59 + ($tipoAgrupamento == null ? 43 : $tipoAgrupamento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroConsultaDebitoDTO(pessoa=" + this.getPessoa() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", anoDebito=" + this.getAnoDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataLancamentoInicial=" + this.getDataLancamentoInicial() + ", dataLancamentoFinal=" + this.getDataLancamentoFinal() + ", dataVencimentoInicial=" + this.getDataVencimentoInicial() + ", dataVencimentoFinal=" + this.getDataVencimentoFinal() + ", noExercicio=" + this.getNoExercicio() + ", dividaAtiva=" + this.getDividaAtiva() + ", juizo=" + this.getJuizo() + ", situacaoParcela=" + this.getSituacaoParcela() + ", somenteParcelasEmAberto=" + this.getSomenteParcelasEmAberto() + ", calcularAcrescimos=" + this.getCalcularAcrescimos() + ", dataReferencia=" + this.getDataReferencia() + ", qtdParcelasVencidas=" + this.getQtdParcelasVencidas() + ", valorMinimo=" + this.getValorMinimo() + ", valorMaximo=" + this.getValorMaximo() + ", cidade=" + this.getCidade() + ", bairro=" + this.getBairro() + ", logradouro=" + this.getLogradouro() + ", complemento=" + this.getComplemento() + ", numero=" + this.getNumero() + ", pessoaRange=" + this.getPessoaRange() + ", parcela=" + this.getParcela() + ", parcelado=" + this.getParcelado() + ", reparcelado=" + this.getReparcelado() + ", debitosProtestados=" + this.getDebitosProtestados() + ", anoBase=" + this.getAnoBase() + ", tipoAgrupamento=" + this.getTipoAgrupamento() + ")";
    }
}

