/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneBoleto;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.dto.BoletoRowResumoDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class CarneResumoDTO
implements Serializable {
    private Long entidade;
    private Long exercicio;
    private Long carne;
    private String identificacao;
    private String codigoBarras;
    private String nome;
    private Integer codigoSitucacao;
    private String situacao;
    private LocalDate dataSituacao;
    private LocalDate dataRetirada;
    private String usuarioRetirada;
    private LocalDate dataDevolucao;
    private String usuarioDevolucao;
    private Integer codigoDevolucao;
    private String observacaoDevolucao;
    private List<BoletoRowResumoDTO> boletos = new ArrayList();
    private BigDecimal valorTotalParcelado = BigDecimal.ZERO;

    public static CarneResumoDTO from(Carne carne) {
        return Optional.ofNullable(carne).map(carneMap -> {
            CarneResumoDTO carneDTO = new CarneResumoDTO();
            carneDTO.setEntidade(carneMap.getId().getEntidade());
            carneDTO.setExercicio(carneMap.getId().getExercicio());
            carneDTO.setCarne(carneMap.getId().getCarne());
            carneDTO.setIdentificacao(String.format("%d/%d", carneDTO.getCarne(), carneDTO.getExercicio()));
            carneDTO.setCodigoBarras(carneMap.getCodigoBarras());
            Optional.ofNullable(carneMap.getCadastroGeralEntity()).ifPresent(cadastro -> carneDTO.setNome(String.format("%s - %s", cadastro.getPessoa().getCnpjCpf(), cadastro.getPessoa().getNome())));
            Optional.ofNullable(carneMap.getSituacaoCarne()).ifPresent(situacaoCarne -> {
                carneDTO.setCodigoSitucacao(situacaoCarne.getCodigo());
                carneDTO.setSituacao(situacaoCarne.getDescricao());
            });
            carneDTO.setDataSituacao(carneMap.getDataSituacao());
            carneDTO.setDataRetirada(carneMap.getDataRetirada());
            carneDTO.setUsuarioRetirada(carneMap.getUsuarioRetirada());
            carneDTO.setDataDevolucao(carneMap.getDataDevolucao());
            carneDTO.setUsuarioDevolucao(carneMap.getUsuarioDevolucao());
            Optional.ofNullable(carneMap.getMotivoDevolucao()).ifPresent(motivo -> carneDTO.setCodigoDevolucao(motivo.getCodigo()));
            carneDTO.setObservacaoDevolucao(carneMap.getObservacaoDevolucao());
            carneMap.getBoletos().stream().map(CarneBoleto::getBoleto).map(BoletoRowResumoDTO::from).forEach(boletoDTO -> carneDTO.getBoletos().add(boletoDTO));
            BigDecimal valorTotal = carneDTO.getBoletos().stream().filter(blt -> blt.getSiglaTipoBoleto().equals(TipoBloqueto.PARCELADO.getValue())).map(BoletoRowResumoDTO::getValorTotal).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            carneDTO.setValorTotalParcelado(valorTotal);
            return carneDTO;
        }).orElse(null);
    }

    @Generated
    public CarneResumoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getCarne() {
        return this.carne;
    }

    @Generated
    public String getIdentificacao() {
        return this.identificacao;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public Integer getCodigoSitucacao() {
        return this.codigoSitucacao;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public LocalDate getDataRetirada() {
        return this.dataRetirada;
    }

    @Generated
    public String getUsuarioRetirada() {
        return this.usuarioRetirada;
    }

    @Generated
    public LocalDate getDataDevolucao() {
        return this.dataDevolucao;
    }

    @Generated
    public String getUsuarioDevolucao() {
        return this.usuarioDevolucao;
    }

    @Generated
    public Integer getCodigoDevolucao() {
        return this.codigoDevolucao;
    }

    @Generated
    public String getObservacaoDevolucao() {
        return this.observacaoDevolucao;
    }

    @Generated
    public List<BoletoRowResumoDTO> getBoletos() {
        return this.boletos;
    }

    @Generated
    public BigDecimal getValorTotalParcelado() {
        return this.valorTotalParcelado;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setCarne(Long carne) {
        this.carne = carne;
    }

    @Generated
    public void setIdentificacao(String identificacao) {
        this.identificacao = identificacao;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCodigoSitucacao(Integer codigoSitucacao) {
        this.codigoSitucacao = codigoSitucacao;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setDataRetirada(LocalDate dataRetirada) {
        this.dataRetirada = dataRetirada;
    }

    @Generated
    public void setUsuarioRetirada(String usuarioRetirada) {
        this.usuarioRetirada = usuarioRetirada;
    }

    @Generated
    public void setDataDevolucao(LocalDate dataDevolucao) {
        this.dataDevolucao = dataDevolucao;
    }

    @Generated
    public void setUsuarioDevolucao(String usuarioDevolucao) {
        this.usuarioDevolucao = usuarioDevolucao;
    }

    @Generated
    public void setCodigoDevolucao(Integer codigoDevolucao) {
        this.codigoDevolucao = codigoDevolucao;
    }

    @Generated
    public void setObservacaoDevolucao(String observacaoDevolucao) {
        this.observacaoDevolucao = observacaoDevolucao;
    }

    @Generated
    public void setBoletos(List<BoletoRowResumoDTO> boletos) {
        this.boletos = boletos;
    }

    @Generated
    public void setValorTotalParcelado(BigDecimal valorTotalParcelado) {
        this.valorTotalParcelado = valorTotalParcelado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CarneResumoDTO)) {
            return false;
        }
        CarneResumoDTO other = (CarneResumoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$carne = this.getCarne();
        Long other$carne = other.getCarne();
        if (this$carne == null ? other$carne != null : !((Object)this$carne).equals(other$carne)) {
            return false;
        }
        Integer this$codigoSitucacao = this.getCodigoSitucacao();
        Integer other$codigoSitucacao = other.getCodigoSitucacao();
        if (this$codigoSitucacao == null ? other$codigoSitucacao != null : !((Object)this$codigoSitucacao).equals(other$codigoSitucacao)) {
            return false;
        }
        Integer this$codigoDevolucao = this.getCodigoDevolucao();
        Integer other$codigoDevolucao = other.getCodigoDevolucao();
        if (this$codigoDevolucao == null ? other$codigoDevolucao != null : !((Object)this$codigoDevolucao).equals(other$codigoDevolucao)) {
            return false;
        }
        String this$identificacao = this.getIdentificacao();
        String other$identificacao = other.getIdentificacao();
        if (this$identificacao == null ? other$identificacao != null : !this$identificacao.equals(other$identificacao)) {
            return false;
        }
        String this$codigoBarras = this.getCodigoBarras();
        String other$codigoBarras = other.getCodigoBarras();
        if (this$codigoBarras == null ? other$codigoBarras != null : !this$codigoBarras.equals(other$codigoBarras)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        LocalDate this$dataSituacao = this.getDataSituacao();
        LocalDate other$dataSituacao = other.getDataSituacao();
        if (this$dataSituacao == null ? other$dataSituacao != null : !((Object)this$dataSituacao).equals(other$dataSituacao)) {
            return false;
        }
        LocalDate this$dataRetirada = this.getDataRetirada();
        LocalDate other$dataRetirada = other.getDataRetirada();
        if (this$dataRetirada == null ? other$dataRetirada != null : !((Object)this$dataRetirada).equals(other$dataRetirada)) {
            return false;
        }
        String this$usuarioRetirada = this.getUsuarioRetirada();
        String other$usuarioRetirada = other.getUsuarioRetirada();
        if (this$usuarioRetirada == null ? other$usuarioRetirada != null : !this$usuarioRetirada.equals(other$usuarioRetirada)) {
            return false;
        }
        LocalDate this$dataDevolucao = this.getDataDevolucao();
        LocalDate other$dataDevolucao = other.getDataDevolucao();
        if (this$dataDevolucao == null ? other$dataDevolucao != null : !((Object)this$dataDevolucao).equals(other$dataDevolucao)) {
            return false;
        }
        String this$usuarioDevolucao = this.getUsuarioDevolucao();
        String other$usuarioDevolucao = other.getUsuarioDevolucao();
        if (this$usuarioDevolucao == null ? other$usuarioDevolucao != null : !this$usuarioDevolucao.equals(other$usuarioDevolucao)) {
            return false;
        }
        String this$observacaoDevolucao = this.getObservacaoDevolucao();
        String other$observacaoDevolucao = other.getObservacaoDevolucao();
        if (this$observacaoDevolucao == null ? other$observacaoDevolucao != null : !this$observacaoDevolucao.equals(other$observacaoDevolucao)) {
            return false;
        }
        List this$boletos = this.getBoletos();
        List other$boletos = other.getBoletos();
        if (this$boletos == null ? other$boletos != null : !((Object)this$boletos).equals(other$boletos)) {
            return false;
        }
        BigDecimal this$valorTotalParcelado = this.getValorTotalParcelado();
        BigDecimal other$valorTotalParcelado = other.getValorTotalParcelado();
        return !(this$valorTotalParcelado == null ? other$valorTotalParcelado != null : !((Object)this$valorTotalParcelado).equals(other$valorTotalParcelado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CarneResumoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $carne = this.getCarne();
        result = result * 59 + ($carne == null ? 43 : ((Object)$carne).hashCode());
        Integer $codigoSitucacao = this.getCodigoSitucacao();
        result = result * 59 + ($codigoSitucacao == null ? 43 : ((Object)$codigoSitucacao).hashCode());
        Integer $codigoDevolucao = this.getCodigoDevolucao();
        result = result * 59 + ($codigoDevolucao == null ? 43 : ((Object)$codigoDevolucao).hashCode());
        String $identificacao = this.getIdentificacao();
        result = result * 59 + ($identificacao == null ? 43 : $identificacao.hashCode());
        String $codigoBarras = this.getCodigoBarras();
        result = result * 59 + ($codigoBarras == null ? 43 : $codigoBarras.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        LocalDate $dataSituacao = this.getDataSituacao();
        result = result * 59 + ($dataSituacao == null ? 43 : ((Object)$dataSituacao).hashCode());
        LocalDate $dataRetirada = this.getDataRetirada();
        result = result * 59 + ($dataRetirada == null ? 43 : ((Object)$dataRetirada).hashCode());
        String $usuarioRetirada = this.getUsuarioRetirada();
        result = result * 59 + ($usuarioRetirada == null ? 43 : $usuarioRetirada.hashCode());
        LocalDate $dataDevolucao = this.getDataDevolucao();
        result = result * 59 + ($dataDevolucao == null ? 43 : ((Object)$dataDevolucao).hashCode());
        String $usuarioDevolucao = this.getUsuarioDevolucao();
        result = result * 59 + ($usuarioDevolucao == null ? 43 : $usuarioDevolucao.hashCode());
        String $observacaoDevolucao = this.getObservacaoDevolucao();
        result = result * 59 + ($observacaoDevolucao == null ? 43 : $observacaoDevolucao.hashCode());
        List $boletos = this.getBoletos();
        result = result * 59 + ($boletos == null ? 43 : ((Object)$boletos).hashCode());
        BigDecimal $valorTotalParcelado = this.getValorTotalParcelado();
        result = result * 59 + ($valorTotalParcelado == null ? 43 : ((Object)$valorTotalParcelado).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CarneResumoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", carne=" + this.getCarne() + ", identificacao=" + this.getIdentificacao() + ", codigoBarras=" + this.getCodigoBarras() + ", nome=" + this.getNome() + ", codigoSitucacao=" + this.getCodigoSitucacao() + ", situacao=" + this.getSituacao() + ", dataSituacao=" + this.getDataSituacao() + ", dataRetirada=" + this.getDataRetirada() + ", usuarioRetirada=" + this.getUsuarioRetirada() + ", dataDevolucao=" + this.getDataDevolucao() + ", usuarioDevolucao=" + this.getUsuarioDevolucao() + ", codigoDevolucao=" + this.getCodigoDevolucao() + ", observacaoDevolucao=" + this.getObservacaoDevolucao() + ", boletos=" + this.getBoletos() + ", valorTotalParcelado=" + this.getValorTotalParcelado() + ")";
    }
}

