/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.Assert;

public class CancelamentoDebitoParcelaDTO {
    private Long idDebito;
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long divida;
    private Long subDivida;
    private Long parcela;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private SituacaoLegal situacaoLegal;
    private Boolean estornado = Boolean.FALSE;
    private LocalDate dataEstorno;
    private String usuarioEstorno;
    private String programaEstorno;
    private Long exercicioProcesso;
    private Long idProcesso;
    private String observacao;
    private Long motivoEstorno;
    private String motivoEstornoDescricao;

    public static CancelamentoDebitoParcelaDTO from(CancelamentoDebitoItem cancelamentoDebitoItem) {
        Assert.notNull((Object)cancelamentoDebitoItem, (String)"Erro ao fazer a convers\u00e3o de dados: Itens do cancelamento est\u00e1 nulo");
        Assert.notNull((Object)cancelamentoDebitoItem.getId(), (String)"Erro ao fazer a convers\u00e3o de dados: Entidade PK no item est\u00e1 nula");
        Assert.notNull((Object)cancelamentoDebitoItem.getId().getCancelamentoDebito(), (String)"Erro ao fazer a convers\u00e3o de dados: Entidade do cancelamento no item est\u00e1 nulo");
        Assert.notNull((Object)cancelamentoDebitoItem.getId().getDebitoParcelaTributo(), (String)"Erro ao fazer a convers\u00e3o de dados: Dados do d\u00e9bito est\u00e3o nulos no item do cancelamento");
        CancelamentoDebitoParcelaDTO dto = new CancelamentoDebitoParcelaDTO();
        dto.setEntidade(cancelamentoDebitoItem.getId().getCancelamentoDebito().getId().getEntidade());
        dto.setExercicio(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getExercicio());
        dto.setIdDebito(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getIdDebito());
        dto.setTipoCadastro(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getTipoCadastro());
        dto.setCadastroGeral(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getCadastroGeral());
        dto.setDivida(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getDivida());
        dto.setSubDivida(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getSubDivida());
        dto.setParcela(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getParcela());
        dto.setValor(cancelamentoDebitoItem.getValor());
        dto.setValorJuros((BigDecimal)ObjectUtils.defaultIfNull((Object)cancelamentoDebitoItem.getValorJuros(), (Object)BigDecimal.ZERO));
        dto.setValorMulta((BigDecimal)ObjectUtils.defaultIfNull((Object)cancelamentoDebitoItem.getValorMulta(), (Object)BigDecimal.ZERO));
        dto.setValorCorrecao((BigDecimal)ObjectUtils.defaultIfNull((Object)cancelamentoDebitoItem.getValorCorrecao(), (Object)BigDecimal.ZERO));
        dto.setSituacaoLegal(cancelamentoDebitoItem.getSituacaoLegal());
        dto.setEstornado(cancelamentoDebitoItem.getEstornado());
        dto.setDataEstorno(cancelamentoDebitoItem.getDataEstorno());
        dto.setUsuarioEstorno(cancelamentoDebitoItem.getUsuarioEstorno());
        dto.setProgramaEstorno(cancelamentoDebitoItem.getProgramaEstorno());
        dto.setExercicioProcesso(cancelamentoDebitoItem.getExercicioProcesso());
        dto.setIdProcesso(cancelamentoDebitoItem.getIdProcesso());
        dto.setObservacao(cancelamentoDebitoItem.getObservacao());
        dto.setMotivoEstorno(Objects.nonNull(cancelamentoDebitoItem.getMotivoDesconto()) ? cancelamentoDebitoItem.getMotivoDesconto().getId() : null);
        dto.setMotivoEstornoDescricao(Objects.nonNull(cancelamentoDebitoItem.getMotivoDesconto()) ? cancelamentoDebitoItem.getMotivoDesconto().getDescricao() : null);
        return dto;
    }

    public Boolean equalsCancelamentoDebitoItem(CancelamentoDebitoItem item) {
        DebitoParcelaTributo debitoParcelaTributo = item.getId().getDebitoParcelaTributo();
        return debitoParcelaTributo.getEntidade().equals(this.entidade) && debitoParcelaTributo.getExercicio().equals(this.exercicio) && debitoParcelaTributo.getTipoCadastro().equals(this.tipoCadastro) && debitoParcelaTributo.getCadastroGeral().equals(this.cadastroGeral) && debitoParcelaTributo.getDivida().equals(this.divida) && debitoParcelaTributo.getSubDivida().equals(this.subDivida) && debitoParcelaTributo.getParcela().equals(this.parcela);
    }

    public static CancelamentoDebitoParcelaDTO from(ContenciosoDebitoDTO debitosContencioso, ContenciosoDebitoParcela parcela) {
        CancelamentoDebitoParcelaDTO cancelamentoParcelaDTO = new CancelamentoDebitoParcelaDTO();
        cancelamentoParcelaDTO.setIdDebito(debitosContencioso.getIdDebito());
        cancelamentoParcelaDTO.setEntidade(parcela.getId().getEntidade());
        cancelamentoParcelaDTO.setExercicio(parcela.getId().getExercicio());
        cancelamentoParcelaDTO.setTipoCadastro(parcela.getId().getTipoCadastro().getValue());
        cancelamentoParcelaDTO.setCadastroGeral(parcela.getId().getCadastroGeral());
        cancelamentoParcelaDTO.setDivida(parcela.getId().getDivida());
        cancelamentoParcelaDTO.setSubDivida(parcela.getId().getSubDivida());
        cancelamentoParcelaDTO.setParcela(parcela.getId().getParcela());
        return cancelamentoParcelaDTO;
    }

    @Generated
    public CancelamentoDebitoParcelaDTO() {
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Boolean getEstornado() {
        return this.estornado;
    }

    @Generated
    public LocalDate getDataEstorno() {
        return this.dataEstorno;
    }

    @Generated
    public String getUsuarioEstorno() {
        return this.usuarioEstorno;
    }

    @Generated
    public String getProgramaEstorno() {
        return this.programaEstorno;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getMotivoEstorno() {
        return this.motivoEstorno;
    }

    @Generated
    public String getMotivoEstornoDescricao() {
        return this.motivoEstornoDescricao;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    @Generated
    public void setDataEstorno(LocalDate dataEstorno) {
        this.dataEstorno = dataEstorno;
    }

    @Generated
    public void setUsuarioEstorno(String usuarioEstorno) {
        this.usuarioEstorno = usuarioEstorno;
    }

    @Generated
    public void setProgramaEstorno(String programaEstorno) {
        this.programaEstorno = programaEstorno;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setMotivoEstorno(Long motivoEstorno) {
        this.motivoEstorno = motivoEstorno;
    }

    @Generated
    public void setMotivoEstornoDescricao(String motivoEstornoDescricao) {
        this.motivoEstornoDescricao = motivoEstornoDescricao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelamentoDebitoParcelaDTO)) {
            return false;
        }
        CancelamentoDebitoParcelaDTO other = (CancelamentoDebitoParcelaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Boolean this$estornado = this.getEstornado();
        Boolean other$estornado = other.getEstornado();
        if (this$estornado == null ? other$estornado != null : !((Object)this$estornado).equals(other$estornado)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$idProcesso = this.getIdProcesso();
        Long other$idProcesso = other.getIdProcesso();
        if (this$idProcesso == null ? other$idProcesso != null : !((Object)this$idProcesso).equals(other$idProcesso)) {
            return false;
        }
        Long this$motivoEstorno = this.getMotivoEstorno();
        Long other$motivoEstorno = other.getMotivoEstorno();
        if (this$motivoEstorno == null ? other$motivoEstorno != null : !((Object)this$motivoEstorno).equals(other$motivoEstorno)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        LocalDate this$dataEstorno = this.getDataEstorno();
        LocalDate other$dataEstorno = other.getDataEstorno();
        if (this$dataEstorno == null ? other$dataEstorno != null : !((Object)this$dataEstorno).equals(other$dataEstorno)) {
            return false;
        }
        String this$usuarioEstorno = this.getUsuarioEstorno();
        String other$usuarioEstorno = other.getUsuarioEstorno();
        if (this$usuarioEstorno == null ? other$usuarioEstorno != null : !this$usuarioEstorno.equals(other$usuarioEstorno)) {
            return false;
        }
        String this$programaEstorno = this.getProgramaEstorno();
        String other$programaEstorno = other.getProgramaEstorno();
        if (this$programaEstorno == null ? other$programaEstorno != null : !this$programaEstorno.equals(other$programaEstorno)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$motivoEstornoDescricao = this.getMotivoEstornoDescricao();
        String other$motivoEstornoDescricao = other.getMotivoEstornoDescricao();
        return !(this$motivoEstornoDescricao == null ? other$motivoEstornoDescricao != null : !this$motivoEstornoDescricao.equals(other$motivoEstornoDescricao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CancelamentoDebitoParcelaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Boolean $estornado = this.getEstornado();
        result = result * 59 + ($estornado == null ? 43 : ((Object)$estornado).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $idProcesso = this.getIdProcesso();
        result = result * 59 + ($idProcesso == null ? 43 : ((Object)$idProcesso).hashCode());
        Long $motivoEstorno = this.getMotivoEstorno();
        result = result * 59 + ($motivoEstorno == null ? 43 : ((Object)$motivoEstorno).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        LocalDate $dataEstorno = this.getDataEstorno();
        result = result * 59 + ($dataEstorno == null ? 43 : ((Object)$dataEstorno).hashCode());
        String $usuarioEstorno = this.getUsuarioEstorno();
        result = result * 59 + ($usuarioEstorno == null ? 43 : $usuarioEstorno.hashCode());
        String $programaEstorno = this.getProgramaEstorno();
        result = result * 59 + ($programaEstorno == null ? 43 : $programaEstorno.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $motivoEstornoDescricao = this.getMotivoEstornoDescricao();
        result = result * 59 + ($motivoEstornoDescricao == null ? 43 : $motivoEstornoDescricao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CancelamentoDebitoParcelaDTO(idDebito=" + this.getIdDebito() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", valor=" + this.getValor() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", situacaoLegal=" + this.getSituacaoLegal() + ", estornado=" + this.getEstornado() + ", dataEstorno=" + this.getDataEstorno() + ", usuarioEstorno=" + this.getUsuarioEstorno() + ", programaEstorno=" + this.getProgramaEstorno() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", idProcesso=" + this.getIdProcesso() + ", observacao=" + this.getObservacao() + ", motivoEstorno=" + this.getMotivoEstorno() + ", motivoEstornoDescricao=" + this.getMotivoEstornoDescricao() + ")";
    }
}

