/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.supersimples;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVarredura;
import br.com.elotech.tributos.enums.supersimples.SituacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribsupersimplessolicitacao")
public class SuperSimplesSolicitacao
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idsolicitacao")
    @EloSequence(sequenceName="s05SuperSimplesCNPJPendente")
    private Long id;
    @Column(name="arquivo")
    private String nomeArquivo;
    private LocalDate dataImportacao;
    private String usuario;
    private LocalDate dataExclusao;
    private Boolean varreduraFinal = Boolean.FALSE;
    private LocalDate dataFinal;
    private String hash;
    private Long idArquivo;
    @Enumerated(value=EnumType.STRING)
    private SituacaoSuperSimplesSolicitacao situacao;
    @OneToMany(mappedBy="solicitacao", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SuperSimplesSolicitacaoVarredura> varreduras = new ArrayList();

    public boolean hasVarreduraWithTipoOperacaoInicialAndIdArquivo() {
        return this.varreduras.stream().anyMatch(varredura -> TipoOperacaoSuperSimplesSolicitacao.INICIAL.getDescricao().equals(varredura.getTipoOperacao()) && varredura.getIdArquivo() != null);
    }

    @Generated
    public SuperSimplesSolicitacao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public LocalDate getDataImportacao() {
        return this.dataImportacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataExclusao() {
        return this.dataExclusao;
    }

    @Generated
    public Boolean getVarreduraFinal() {
        return this.varreduraFinal;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public Long getIdArquivo() {
        return this.idArquivo;
    }

    @Generated
    public SituacaoSuperSimplesSolicitacao getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<SuperSimplesSolicitacaoVarredura> getVarreduras() {
        return this.varreduras;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setDataImportacao(LocalDate dataImportacao) {
        this.dataImportacao = dataImportacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataExclusao(LocalDate dataExclusao) {
        this.dataExclusao = dataExclusao;
    }

    @Generated
    public void setVarreduraFinal(Boolean varreduraFinal) {
        this.varreduraFinal = varreduraFinal;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setIdArquivo(Long idArquivo) {
        this.idArquivo = idArquivo;
    }

    @Generated
    public void setSituacao(SituacaoSuperSimplesSolicitacao situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setVarreduras(List<SuperSimplesSolicitacaoVarredura> varreduras) {
        this.varreduras = varreduras;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuperSimplesSolicitacao)) {
            return false;
        }
        SuperSimplesSolicitacao other = (SuperSimplesSolicitacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SuperSimplesSolicitacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SuperSimplesSolicitacao(id=" + this.getId() + ")";
    }
}

