/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.pagamentocredito;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCreditoMovimentacao;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCreditoReceita;
import br.com.elotech.tributos.enums.pagamentocredito.OrigemCredito;
import br.com.elotech.tributos.enums.pagamentocredito.StatusCredito;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="tribpagamentocredito")
public class PagamentoCredito
implements EloEntity<Long>,
Serializable {
    @Id
    @Caption(value="Id")
    @EloSequence(sequenceName="S05IDPAGAMENTOCREDITO")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="origem")
    private OrigemCredito origem;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private StatusCredito status;
    @Caption(value="Pagamento")
    @DiffRevisionIgnore
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="entidadepagamento", referencedColumnName="entidade"), @JoinColumn(name="exerciciopagamento", referencedColumnName="exercicioPagamento"), @JoinColumn(name="pagamento", referencedColumnName="pagamento")})
    private Pagamento pagamentoOrigem;
    @OneToOne
    @JoinColumn(name="creditoorigem", referencedColumnName="id")
    @JsonIncludeProperties(value={"id"})
    private PagamentoCredito creditoOrigem;
    @OneToOne
    @JoinColumn(name="boleto", referencedColumnName="idkey")
    @JsonIncludeProperties(value={"id", "bloqueto", "exercicioBloqueto, entidade"})
    private Bloqueto boletoOrigem;
    @Column(name="cadastrogeral")
    private Long cadastroGeral;
    @Column(name="tipocadastro")
    private Long tipoCadastro;
    @Caption(value="Data Origem")
    @Column(name="dataorigem")
    private LocalDate dataOrigem;
    @Caption(value="Saldo Original")
    @Column(name="saldooriginal")
    private BigDecimal saldoOriginal;
    @Caption(value="Saldo Dispon\u00edvel")
    @Column(name="saldodisponivel")
    private BigDecimal saldoDisponivel;
    @DiffRevisionIgnore
    @OneToMany(mappedBy="pagamentoCredito", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnore
    private List<PagamentoCreditoMovimentacao> movimentacoes;
    @DiffRevisionIgnore
    @JsonIgnore
    @OneToMany(mappedBy="pagamentoCredito", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<PagamentoCreditoReceita> receitas;
    @Transient
    @JsonIgnore
    private boolean remanescente;
    @Transient
    @JsonIgnore
    private Long novoCadastroGeral;
    @Transient
    @JsonIgnore
    private Long novoTipoCadastro;

    public static PagamentoCredito makeTo(Pagamento pagamento, OrigemCredito origemCredito, Boolean somenteValorPagoAMaior) {
        PagamentoCredito credito = PagamentoCredito.builder().pagamentoOrigem(pagamento).creditoOrigem(null).boletoOrigem(pagamento.getPagamentoBoleto().getBoleto()).dataOrigem(LocalDate.now()).saldoOriginal(pagamento.getValorPago().setScale(2, RoundingMode.UNNECESSARY)).movimentacoes(new ArrayList()).saldoDisponivel(pagamento.getValorPago()).cadastroGeral(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getCadastroGeral()).tipoCadastro(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getTipoCadastro().getValue()).origem(origemCredito).status(StatusCredito.DISPONIVEL).build();
        credito.setReceitas(pagamento.getPagamentoBoleto().getPagamentosDebito().stream().map(pagamentoDebito -> PagamentoCreditoReceita.from((PagamentoDebito)pagamentoDebito, (PagamentoCredito)credito)).collect(Collectors.toList()));
        if (Boolean.TRUE.equals(somenteValorPagoAMaior)) {
            credito.setSaldoDisponivel(credito.getReceitas().stream().map(PagamentoCreditoReceita::getPagamentoDebito).map(PagamentoDebito::getValorPagoMaior).reduce(BigDecimal.ZERO, BigDecimal::add));
            return credito;
        }
        credito.setSaldoDisponivel(credito.getReceitas().stream().map(PagamentoCreditoReceita::getPagamentoDebito).map(pagamentoDebito -> pagamentoDebito.getValorPago().add(pagamentoDebito.getValorPagoMaior()).subtract(pagamentoDebito.getValorPagoMenor())).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.UNNECESSARY));
        return credito;
    }

    public static PagamentoCredito makeTo(Pagamento pagamento, OrigemCredito origemCredito) {
        return PagamentoCredito.makeTo((Pagamento)pagamento, (OrigemCredito)origemCredito, (Boolean)Boolean.FALSE);
    }

    public static PagamentoCredito makeTo(PagamentoCredito credito, OrigemCredito origemCredito) {
        PagamentoCredito novoCredito = PagamentoCredito.builder().creditoOrigem(credito).pagamentoOrigem(null).dataOrigem(LocalDate.now()).saldoOriginal(credito.getSaldoDisponivel()).movimentacoes(new ArrayList()).saldoDisponivel(credito.getSaldoDisponivel()).cadastroGeral(credito.getNovoCadastroGeral()).tipoCadastro(credito.getNovoTipoCadastro()).origem(origemCredito).status(StatusCredito.DISPONIVEL).build();
        novoCredito.setReceitas(List.copyOf(credito.getReceitas()).stream().map(receita -> {
            PagamentoCreditoReceita receitaClonada = receita.clone();
            receitaClonada.setId(null);
            receitaClonada.setPagamentoCredito(novoCredito);
            return receitaClonada;
        }).collect(Collectors.toList()));
        return novoCredito;
    }

    public PagamentoCredito withId(Long id) {
        this.id = id;
        return this;
    }

    public void novaMovimentacao(Bloqueto bloqueto, String usuarioCnpjCpf) {
        PagamentoCreditoMovimentacao movimentacao = PagamentoCreditoMovimentacao.makeTo((Bloqueto)bloqueto, (String)usuarioCnpjCpf, (PagamentoCredito)this).pagamento();
        if (this.saldoDisponivel.compareTo(bloqueto.getValorBloqueto()) < 0) {
            movimentacao.setValorUtilizado(this.saldoDisponivel);
        }
        this.usarSaldo(movimentacao.getValorUtilizado());
        this.addMovimentacao(movimentacao);
        this.updateStatus();
        if (this.isBoletoDeOutroCadastro(bloqueto)) {
            this.updateDadosParaTransferencia(bloqueto);
        }
    }

    public void novaMovimentacao(BigDecimal valor, Bloqueto bloqueto, String usuarioCnpjCpf) {
        PagamentoCreditoMovimentacao movimentacao = PagamentoCreditoMovimentacao.makeTo((Bloqueto)bloqueto, (String)usuarioCnpjCpf, (PagamentoCredito)this).pagamento();
        movimentacao.setValorUtilizado(valor);
        if (this.saldoDisponivel.compareTo(valor) < 0) {
            movimentacao.setValorUtilizado(this.saldoDisponivel);
        }
        this.usarSaldo(movimentacao.getValorUtilizado());
        this.addMovimentacao(movimentacao);
        this.updateStatus();
        if (this.isBoletoDeOutroCadastro(bloqueto)) {
            this.updateDadosParaTransferencia(bloqueto);
        }
    }

    public void novaMovimentacao(DevolucaoCreditoItem devolucaoItem, String usuarioCnpjCpf) {
        PagamentoCreditoMovimentacao movimentacao = PagamentoCreditoMovimentacao.makeTo((DevolucaoCreditoItem)devolucaoItem, (String)usuarioCnpjCpf, (PagamentoCredito)this).restituicao();
        this.usarSaldo(movimentacao.getValorUtilizado());
        this.addMovimentacao(movimentacao);
        this.updateStatus();
    }

    public void novaMovimentacao(PagamentoCredito novoCredito, String usuarioCnpjCpf) {
        PagamentoCreditoMovimentacao movimentacao = PagamentoCreditoMovimentacao.makeTo((PagamentoCredito)novoCredito, (String)usuarioCnpjCpf, (PagamentoCredito)this).transferenciaSaldoRemanescente();
        this.usarSaldo(movimentacao.getValorUtilizado());
        this.addMovimentacao(movimentacao);
        this.updateStatus();
    }

    public boolean existeSaldoParaOValor(BigDecimal valor) {
        return this.saldoDisponivel.compareTo(valor) >= 0;
    }

    public boolean existeSaldo() {
        return this.saldoDisponivel.compareTo(BigDecimal.ZERO) > 0;
    }

    public void estornarMovimentacaoPorBoleto(Bloqueto boletoPago) {
        PagamentoCreditoMovimentacao movimentacao = this.getMovimentacaoPorBoleto(boletoPago);
        this.estornarSaldo(movimentacao.getValorUtilizado());
        this.movimentacoes.remove(movimentacao);
    }

    public PagamentoCreditoMovimentacao getMovimentacaoPorBoleto(Bloqueto boleto) {
        return this.movimentacoes.stream().filter(movimento -> movimento.getBoletoPago() != null && movimento.getBoletoPago().equals((Object)boleto)).findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o encontrado movimenta\u00e7\u00e3o para o boleto %s/%s no cr\u00e9dito %s", boleto.getBloqueto(), boleto.getExercicioBloqueto(), this.id)));
    }

    private void addMovimentacao(PagamentoCreditoMovimentacao movimentacao) {
        this.movimentacoes.add(movimentacao);
    }

    private void usarSaldo(BigDecimal valor) {
        this.saldoDisponivel = this.saldoDisponivel.subtract(valor);
    }

    private void estornarSaldo(BigDecimal valor) {
        this.saldoDisponivel = this.saldoDisponivel.add(valor);
    }

    private void updateStatus() {
        this.status = this.existeSaldo() ? StatusCredito.DISPONIVEL : StatusCredito.LIQUIDADO;
    }

    private boolean isBoletoDeOutroCadastro(Bloqueto boleto) {
        return !this.cadastroGeral.equals(boleto.getCadastroGeral().getCadastroGeral()) || !this.tipoCadastro.equals(boleto.getCadastroGeral().getTipoCadastro().getValue());
    }

    private void updateDadosParaTransferencia(Bloqueto boleto) {
        this.remanescente = true;
        this.novoCadastroGeral = boleto.getCadastroGeral().getCadastroGeral();
        this.novoTipoCadastro = boleto.getCadastroGeral().getTipoCadastro().getValue();
    }

    @Generated
    private static List<PagamentoCreditoMovimentacao> $default$movimentacoes() {
        return new ArrayList<PagamentoCreditoMovimentacao>();
    }

    @Generated
    private static boolean $default$remanescente() {
        return false;
    }

    @Generated
    public static PagamentoCreditoBuilder builder() {
        return new PagamentoCreditoBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public OrigemCredito getOrigem() {
        return this.origem;
    }

    @Generated
    public StatusCredito getStatus() {
        return this.status;
    }

    @Generated
    public Pagamento getPagamentoOrigem() {
        return this.pagamentoOrigem;
    }

    @Generated
    public PagamentoCredito getCreditoOrigem() {
        return this.creditoOrigem;
    }

    @Generated
    public Bloqueto getBoletoOrigem() {
        return this.boletoOrigem;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public LocalDate getDataOrigem() {
        return this.dataOrigem;
    }

    @Generated
    public BigDecimal getSaldoOriginal() {
        return this.saldoOriginal;
    }

    @Generated
    public BigDecimal getSaldoDisponivel() {
        return this.saldoDisponivel;
    }

    @Generated
    public List<PagamentoCreditoMovimentacao> getMovimentacoes() {
        return this.movimentacoes;
    }

    @Generated
    public List<PagamentoCreditoReceita> getReceitas() {
        return this.receitas;
    }

    @Generated
    public boolean isRemanescente() {
        return this.remanescente;
    }

    @Generated
    public Long getNovoCadastroGeral() {
        return this.novoCadastroGeral;
    }

    @Generated
    public Long getNovoTipoCadastro() {
        return this.novoTipoCadastro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setOrigem(OrigemCredito origem) {
        this.origem = origem;
    }

    @Generated
    public void setStatus(StatusCredito status) {
        this.status = status;
    }

    @Generated
    public void setPagamentoOrigem(Pagamento pagamentoOrigem) {
        this.pagamentoOrigem = pagamentoOrigem;
    }

    @Generated
    public void setCreditoOrigem(PagamentoCredito creditoOrigem) {
        this.creditoOrigem = creditoOrigem;
    }

    @Generated
    public void setBoletoOrigem(Bloqueto boletoOrigem) {
        this.boletoOrigem = boletoOrigem;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setDataOrigem(LocalDate dataOrigem) {
        this.dataOrigem = dataOrigem;
    }

    @Generated
    public void setSaldoOriginal(BigDecimal saldoOriginal) {
        this.saldoOriginal = saldoOriginal;
    }

    @Generated
    public void setSaldoDisponivel(BigDecimal saldoDisponivel) {
        this.saldoDisponivel = saldoDisponivel;
    }

    @JsonIgnore
    @Generated
    public void setMovimentacoes(List<PagamentoCreditoMovimentacao> movimentacoes) {
        this.movimentacoes = movimentacoes;
    }

    @JsonIgnore
    @Generated
    public void setReceitas(List<PagamentoCreditoReceita> receitas) {
        this.receitas = receitas;
    }

    @JsonIgnore
    @Generated
    public void setRemanescente(boolean remanescente) {
        this.remanescente = remanescente;
    }

    @JsonIgnore
    @Generated
    public void setNovoCadastroGeral(Long novoCadastroGeral) {
        this.novoCadastroGeral = novoCadastroGeral;
    }

    @JsonIgnore
    @Generated
    public void setNovoTipoCadastro(Long novoTipoCadastro) {
        this.novoTipoCadastro = novoTipoCadastro;
    }

    @Generated
    public String toString() {
        return "PagamentoCredito(id=" + this.getId() + ", origem=" + this.getOrigem() + ", status=" + this.getStatus() + ", pagamentoOrigem=" + this.getPagamentoOrigem() + ", creditoOrigem=" + this.getCreditoOrigem() + ", boletoOrigem=" + this.getBoletoOrigem() + ", cadastroGeral=" + this.getCadastroGeral() + ", tipoCadastro=" + this.getTipoCadastro() + ", dataOrigem=" + this.getDataOrigem() + ", saldoOriginal=" + this.getSaldoOriginal() + ", saldoDisponivel=" + this.getSaldoDisponivel() + ", movimentacoes=" + this.getMovimentacoes() + ", receitas=" + this.getReceitas() + ", remanescente=" + this.isRemanescente() + ", novoCadastroGeral=" + this.getNovoCadastroGeral() + ", novoTipoCadastro=" + this.getNovoTipoCadastro() + ")";
    }

    @Generated
    public PagamentoCredito(Long id, OrigemCredito origem, StatusCredito status, Pagamento pagamentoOrigem, PagamentoCredito creditoOrigem, Bloqueto boletoOrigem, Long cadastroGeral, Long tipoCadastro, LocalDate dataOrigem, BigDecimal saldoOriginal, BigDecimal saldoDisponivel, List<PagamentoCreditoMovimentacao> movimentacoes, List<PagamentoCreditoReceita> receitas, boolean remanescente, Long novoCadastroGeral, Long novoTipoCadastro) {
        this.id = id;
        this.origem = origem;
        this.status = status;
        this.pagamentoOrigem = pagamentoOrigem;
        this.creditoOrigem = creditoOrigem;
        this.boletoOrigem = boletoOrigem;
        this.cadastroGeral = cadastroGeral;
        this.tipoCadastro = tipoCadastro;
        this.dataOrigem = dataOrigem;
        this.saldoOriginal = saldoOriginal;
        this.saldoDisponivel = saldoDisponivel;
        this.movimentacoes = movimentacoes;
        this.receitas = receitas;
        this.remanescente = remanescente;
        this.novoCadastroGeral = novoCadastroGeral;
        this.novoTipoCadastro = novoTipoCadastro;
    }

    @Generated
    public PagamentoCredito() {
        this.movimentacoes = PagamentoCredito.$default$movimentacoes();
        this.remanescente = PagamentoCredito.$default$remanescente();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoCredito)) {
            return false;
        }
        PagamentoCredito other = (PagamentoCredito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoCredito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

