/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.acrescimo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.acrescimo.FormaCalculo;
import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.domain.acrescimo.PeriodoCorrecao;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="indicecorrecao")
public class IndiceCorrecao
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="SEQ_INDICECORRECAO")
    @Column(name="indicecorrecao")
    private Long id;
    @Length(max=50)
    @NotEmpty
    private @Length(max=50) @NotEmpty String descricao;
    @Column(name="periodo")
    @NotNull
    private PeriodoCorrecao periodoCorrecao;
    @Column(name="formacalculo")
    @NotNull
    private FormaCalculo formaCalculo;
    @JsonIgnoreProperties(value={"id.indiceCorrecao"})
    @OneToMany(mappedBy="id.indiceCorrecao", cascade={CascadeType.ALL}, orphanRemoval=true)
    @IgnoreSizeOf
    private List<ValorIndice> valores = new ArrayList();

    public IndiceCorrecao merge(IndiceCorrecao other) {
        if (!Objects.isNull(other)) {
            this.descricao = (String)ObjectUtils.firstNonNull((Object[])new String[]{other.descricao, this.descricao});
            this.periodoCorrecao = (PeriodoCorrecao)ObjectUtils.firstNonNull((Object[])new PeriodoCorrecao[]{other.periodoCorrecao, this.periodoCorrecao});
            this.formaCalculo = (FormaCalculo)ObjectUtils.firstNonNull((Object[])new FormaCalculo[]{other.formaCalculo, this.formaCalculo});
            this.replaceValores(other.valores);
        }
        return this;
    }

    public void replaceValores(List<ValorIndice> valores) {
        if (Objects.isNull(valores)) {
            this.valores = null;
            return;
        }
        if (Objects.isNull(this.valores)) {
            this.valores = new ArrayList();
        } else {
            this.valores.clear();
        }
        this.valores.addAll(valores);
        this.setVinculoValor();
    }

    public ValorIndice getUltimoValorIndiceByData(LocalDate data) {
        Comparator<ValorIndice> valorIndiceComparator = Comparator.comparing(item -> item.getId().getData());
        return this.valores.stream().filter(valorIndice -> !valorIndice.getId().getData().isAfter(data)).sorted(valorIndiceComparator.reversed()).findFirst().orElse(null);
    }

    private Predicate<ValorIndice> filterByData(LocalDate data) {
        if (EnumSet.of(PeriodoCorrecao.ANUAL, PeriodoCorrecao.MENSAL).contains(this.periodoCorrecao)) {
            return p -> p.getId().getData().getYear() == data.getYear() && p.getId().getData().getMonthValue() == data.getMonthValue();
        }
        return p -> p.getId().getData().equals(data);
    }

    public ValorIndice getValorIndiceByData(LocalDate data) {
        Comparator<ValorIndice> valorIndiceComparator = Comparator.comparing(item -> item.getId().getData());
        return this.valores.stream().filter(this.filterByData(data)).sorted(valorIndiceComparator).findFirst().orElse(null);
    }

    public void setVinculoValor() {
        this.valores.forEach(valorIndice -> valorIndice.setIndiceCorrecao(this));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public IndiceCorrecao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public PeriodoCorrecao getPeriodoCorrecao() {
        return this.periodoCorrecao;
    }

    @Generated
    public FormaCalculo getFormaCalculo() {
        return this.formaCalculo;
    }

    @Generated
    public List<ValorIndice> getValores() {
        return this.valores;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setPeriodoCorrecao(PeriodoCorrecao periodoCorrecao) {
        this.periodoCorrecao = periodoCorrecao;
    }

    @Generated
    public void setFormaCalculo(FormaCalculo formaCalculo) {
        this.formaCalculo = formaCalculo;
    }

    @JsonIgnoreProperties(value={"id.indiceCorrecao"})
    @Generated
    public void setValores(List<ValorIndice> valores) {
        this.valores = valores;
    }

    @Generated
    public String toString() {
        return "IndiceCorrecao(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", periodoCorrecao=" + this.getPeriodoCorrecao() + ", formaCalculo=" + this.getFormaCalculo() + ", valores=" + this.getValores() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndiceCorrecao)) {
            return false;
        }
        IndiceCorrecao other = (IndiceCorrecao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndiceCorrecao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

