/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.ProjetoCalculoDTO;
import br.com.elotech.tributos.calculo.repository.ProjetoCalculoDTORowMapper;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ProjetoCalculoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjetoCalculoRepository.class);
    private static final String LOAD_PROJETOS = "br/com/elotech/tributos/calculo/repository/load-projetos.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ProjetoCalculoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<CadastroCalculoRoot<ProjetoPK>> loadCadastros(String filtro) {
        String sql = String.format(FileUtils.readResourceAsString((String)LOAD_PROJETOS), filtro);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List cadastros = this.namedParameterJdbcTemplate.query(sql, (RowMapper)new ProjetoCalculoDTORowMapper());
        stopwatch.stop();
        LOGGER.debug("Carregando {} projetos do banco - {} m {} s {} ms - {} ns", new Object[]{cadastros.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return cadastros.stream().collect(Collectors.groupingBy(CadastroCalculoDTO::getId)).entrySet().stream().map(arg_0 -> this.buildRoot(arg_0)).collect(Collectors.toList());
    }

    private CadastroCalculoRoot<ProjetoPK> buildRoot(Map.Entry<ProjetoPK, List<ProjetoCalculoDTO>> cadastros) {
        CadastroCalculoRoot root = new CadastroCalculoRoot();
        root.setChildren(cadastros.getValue());
        if (!cadastros.getValue().isEmpty()) {
            root.setId((Object)cadastros.getKey());
        }
        return root;
    }
}

