/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoImobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoMobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoProjetoContext;
import br.com.elotech.tributos.calculo.dto.CalculoRuralContext;
import br.com.elotech.tributos.domain.calculo.OrigemDadosCalculo;
import java.util.Map;

public class CalculoContextFactory {
    private CalculoContextFactory() {
    }

    public static CalculoContext getContext(OrigemDadosCalculo origemDadosCalculo) {
        Map<OrigemDadosCalculo, CalculoProjetoContext> contextMap = Map.of(OrigemDadosCalculo.IMOBILIARIO, new CalculoImobiliarioContext(), OrigemDadosCalculo.MOBILIARIO, new CalculoMobiliarioContext(), OrigemDadosCalculo.RURAL, new CalculoRuralContext(), OrigemDadosCalculo.PROJETO, new CalculoProjetoContext());
        CalculoContext context = contextMap.getOrDefault(origemDadosCalculo, null);
        if (context == null) {
            throw new EloValidationException(String.format("N\u00e3o h\u00e1 implementa\u00e7\u00e3o de c\u00e1lculo para a origem de dados %s.", origemDadosCalculo.name()));
        }
        return context;
    }
}

