/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.pgfn.processamento;

import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnConfiguracao;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemEntityDTO;
import br.com.elotech.tributos.service.supersimples.pgfn.GeracaoDebitoPgfnService;
import br.com.elotech.tributos.service.supersimples.pgfn.PgfnConfiguracaoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
public class ProcessamentoArquivoPgfnProcessor
implements ItemProcessor<PgfnArquivoItemEntityDTO, PgfnArquivoItemEntityDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoArquivoPgfnProcessor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessamentoArquivoPgfnProcessor.class);
    private final GeracaoDebitoPgfnService geracaoDebitoPgfnService;
    private final PgfnConfiguracaoService pgfnConfiguracaoService;
    private StepExecution stepExecution;
    private PgfnConfiguracao configuracao;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.configuracao = this.pgfnConfiguracaoService.findByEntidadePrincipalAndExercicioAtual();
        log.info("Configura\u00e7\u00e3o carregada: {}", (Object)this.configuracao);
    }

    public PgfnArquivoItemEntityDTO process(PgfnArquivoItemEntityDTO item) {
        if (!item.getDadosDebito().getSituacao().permiteBaixar()) {
            return null;
        }
        LOGGER.debug("ExecutionId: {}, StepId: {}, ReadCount: {}", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.debug("Realizando a gera\u00e7\u00e3o de d\u00e9bito do registro {}", (Object)item);
        this.geracaoDebitoPgfnService.generateNovoDebito(item, this.configuracao);
        return item;
    }

    @Generated
    public ProcessamentoArquivoPgfnProcessor(GeracaoDebitoPgfnService geracaoDebitoPgfnService, PgfnConfiguracaoService pgfnConfiguracaoService) {
        this.geracaoDebitoPgfnService = geracaoDebitoPgfnService;
        this.pgfnConfiguracaoService = pgfnConfiguracaoService;
    }
}

