/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.validaregrasimportacao.estornodeducaocredito;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoDeducaoCreditoValidacaoDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoDeducaoCreditoValidacaoBatchReader
extends JdbcCursorItemReader<EstornoDeducaoCreditoValidacaoDTO> {
    public EstornoDeducaoCreditoValidacaoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long entidade = (Long)jobParameters.get("entidade");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        this.setFetchSize(10000);
        this.setName("simamEstornoDeducaoCreditoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(EstornoDeducaoCreditoValidacaoDTO.class));
        String sqlBase = FileUtils.readResourceAsString((String)"sql/simam/validacaoarquivo/estornoDeducaoCreditoValidacao.sql");
        String sqlComParametros = sqlBase.replace(":dataInicial", StringUtils.wrap((String)dataInicial.toString(), (String)"'")).replace(":dataFinal", StringUtils.wrap((String)dataFinal.toString(), (String)"'")).replace(":entidade", entidade.toString());
        this.setSql(sqlComParametros);
    }
}

