/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class ReferenciaOrigemParcelamentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReferenciaOrigemParcelamentoService.class);
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final EntityManager entityManager;

    @Transactional
    public void atualizaReferenciaDividaAtiva(JobExecution jobExecution) {
        log.info("SIM-AM - Referencia Origem Parcelamento DA - iniciando atualiza\u00e7\u00e3o.");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate("dataFinal")));
        Long entidade = jobExecution.getJobParameters().getLong("entidade");
        Integer exercicio = dataInicial.getYear();
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade);
        params.addValue("exercicio", (Object)exercicio);
        params.addValue("dataInicial", (Object)dataInicial);
        params.addValue("dataFinal", (Object)dataFinal);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/referenciaOrigemParcelamentoDABatch.sql");
        int maxExecucoes = 10;
        int countExecucoes = 1;
        int updatedRows = 0;
        do {
            updatedRows = this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)params);
            log.info(String.format("SIM-AM - Referencia Origem Parcelamento DA - %d registros inseridos.", updatedRows));
        } while (updatedRows > 0 && ++countExecucoes < maxExecucoes);
        log.info("SIM-AM - Referencia Origem Parcelamento DA - fim da atualiza\u00e7\u00e3o.");
    }

    @Transactional
    public void atualizaReferenciaExercicio(JobExecution jobExecution) {
        log.info("SIM-AM - Referencia Origem Parcelamento exerc\u00edcio - iniciando atualiza\u00e7\u00e3o.");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate("dataFinal")));
        Long entidade = jobExecution.getJobParameters().getLong("entidade");
        Integer exercicio = dataInicial.getYear();
        Integer competencia = dataInicial.getMonthValue();
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade);
        params.addValue("exercicio", (Object)exercicio);
        params.addValue("dataInicial", (Object)dataInicial);
        params.addValue("dataFinal", (Object)dataFinal);
        params.addValue("anogerado", (Object)exercicio);
        params.addValue("mesgerado", (Object)competencia);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/referenciaOrigemParcelamentoBatch.sql");
        int maxExecucoes = 10;
        int countExecucoes = 1;
        int updatedRows = 0;
        do {
            updatedRows = this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)params);
            log.info(String.format("SIM-AM - Referencia Origem Parcelamento exerc\u00edcio - %d registros inseridos.", updatedRows));
        } while (updatedRows > 0 && ++countExecucoes < maxExecucoes);
        log.info("SIM-AM - Referencia Origem Parcelamento exerc\u00edcio - fim da atualiza\u00e7\u00e3o.");
    }

    @Generated
    public ReferenciaOrigemParcelamentoService(NamedParameterJdbcTemplate namedParameterJdbcTemplate, EntityManager entityManager) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.entityManager = entityManager;
    }
}

