/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.importacao;

import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.batch.CustomFlatFileItemReader;
import br.com.elotech.tributos.batch.debitoautomatico.importacao.ImportacaoArquivoDebitoAutomaticoReader;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItem;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemA;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemB;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemC;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemD;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemE;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemF;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemH;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemI;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemJ;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemK;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemL;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemT;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemX;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemZ;
import br.com.elotech.tributos.dto.debitoautomatico.ArquivoDebitoAutomaticoItemDTO;
import br.com.elotech.tributos.enums.ArquivoDebitoAutomaticoItemTipo;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.resolvers.arquivoclient.ArquivoClientMinioResolver;
import br.com.elotech.tributos.util.FieldUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.InputStream;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoArquivoDebitoAutomaticoReader
extends CustomFlatFileItemReader<ArquivoDebitoAutomaticoItemDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoDebitoAutomaticoReader.class);

    public ImportacaoArquivoDebitoAutomaticoReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, ArquivoStorageFeignClient arquivoStorageFeignClient, ArquivoClientMinioResolver arquivoClientMinioResolver, ParametroGeralService parametroGeralService) {
        Long idArquivo = (Long)jobParameters.get("idArquivo");
        this.setResource((Resource)new InputStreamResource(this.getFileStream(idArquivo, arquivoClientMinioResolver, arquivoStorageFeignClient)));
        this.setLineMapper(this.buildLineMapper());
    }

    private InputStream getFileStream(Long idArquivo, ArquivoClientMinioResolver minioResolver, ArquivoStorageFeignClient feignClient) {
        ArquivoDTO arquivoDto = feignClient.findOne(idArquivo);
        log.debug("Buscando url de download do arquivo");
        ArquivoFindRequest request = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getTenantId().orElse("")), (String)arquivoDto.getFullPath());
        return minioResolver.getArquivoClient().buscarArquivo(request).map(ArquivoContent::getContent).orElseThrow(() -> new EloValidationException("Erro ao baixar o arquivo"));
    }

    private LineTokenizer getLineTokenizer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private LineMapper<ArquivoDebitoAutomaticoItemDTO> buildLineMapper() {
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        lineMapper.setLineTokenizer(this.getLineTokenizer());
        lineMapper.setFieldSetMapper(arg_0 -> this.mapLineToDTO(arg_0));
        return lineMapper;
    }

    private ArquivoDebitoAutomaticoItemDTO mapLineToDTO(FieldSet fieldSet) {
        ArquivoDebitoAutomaticoItemTipo tipo = ArquivoDebitoAutomaticoItemTipo.fromValue((String)fieldSet.readString(0));
        ADAItemA item = null;
        switch (2.$SwitchMap$br$com$elotech$tributos$enums$ArquivoDebitoAutomaticoItemTipo[tipo.ordinal()]) {
            case 1: {
                item = new ADAItemA();
                break;
            }
            case 2: {
                item = new ADAItemB();
                break;
            }
            case 3: {
                item = new ADAItemC();
                break;
            }
            case 4: {
                item = new ADAItemD();
                break;
            }
            case 5: {
                item = new ADAItemE();
                break;
            }
            case 6: {
                item = new ADAItemF();
                break;
            }
            case 7: {
                item = new ADAItemH();
                break;
            }
            case 8: {
                item = new ADAItemI();
                break;
            }
            case 9: {
                item = new ADAItemJ();
                break;
            }
            case 10: {
                item = new ADAItemK();
                break;
            }
            case 11: {
                item = new ADAItemL();
                break;
            }
            case 12: {
                item = new ADAItemT();
                break;
            }
            case 13: {
                item = new ADAItemX();
                break;
            }
            case 14: {
                item = new ADAItemZ();
            }
        }
        ArquivoDebitoAutomaticoItemDTO dto = new ArquivoDebitoAutomaticoItemDTO(tipo, (ADAItem)item);
        FieldUtils.setFields((Object)dto.getItem(), (FieldSet)fieldSet);
        return dto;
    }
}

