/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.importacao;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItem;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemA;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemB;
import br.com.elotech.tributos.dto.debitoautomatico.ArquivoDebitoAutomaticoItemDTO;
import br.com.elotech.tributos.enums.ArquivoDebitoAutomaticoItemTipo;
import br.com.elotech.tributos.repository.DebitoRepository;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImportacaoArquivoDebitoAutomaticoProcessor
implements ItemProcessor<ArquivoDebitoAutomaticoItemDTO, ADAItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoDebitoAutomaticoProcessor.class);
    private final DebitoRepository debitoRepository;
    private ChunkContext chunkContext;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    private void preencheDebito(ADAItemB itemB) {
        Optional debito;
        Long cadastroGeral = new Long(itemB.getIdentificacaoClienteEmpresa().substring(0, 15));
        Long exericio = new Long(itemB.getIdentificacaoClienteEmpresa().substring(15, 19));
        Long divida = new Long(itemB.getIdentificacaoClienteEmpresa().substring(19, 21));
        Long subdivida = new Long(itemB.getIdentificacaoClienteEmpresa().substring(21, 23));
        Long formaPagamento = new Long(itemB.getIdentificacaoClienteEmpresa().substring(24, 25));
        itemB.setFormaPagamento(formaPagamento);
        Long tipoCadastro = 3L;
        if (cadastroGeral >= 0L && cadastroGeral <= 999999L) {
            tipoCadastro = 2L;
        }
        if (cadastroGeral >= 1000000L && cadastroGeral <= 80000000L) {
            tipoCadastro = 1L;
        }
        if ((debito = this.debitoRepository.findByCompositeKey(Long.valueOf(1L), exericio, tipoCadastro, cadastroGeral, divida, subdivida)).isPresent()) {
            itemB.setEntidade(((Debito)debito.get()).getEntidade());
            itemB.setExercicio(((Debito)debito.get()).getExercicio());
            itemB.setTipoCadastro(((Debito)debito.get()).getTipoCadastro());
            itemB.setCadastroGeral(((Debito)debito.get()).getCadastroGeralId());
            itemB.setGuiaRecolhimento(((Debito)debito.get()).getGuiaRecolhimento());
            itemB.setSubdivida(((Debito)debito.get()).getSubDivida());
            return;
        }
        tipoCadastro = new Long(itemB.getIdentificacaoClienteEmpresa().substring(0, 2));
        cadastroGeral = new Long(itemB.getIdentificacaoClienteEmpresa().substring(2, 14));
        exericio = new Long(itemB.getIdentificacaoClienteEmpresa().substring(14, 18));
        divida = new Long(itemB.getIdentificacaoClienteEmpresa().substring(18, 21));
        subdivida = new Long(itemB.getIdentificacaoClienteEmpresa().substring(21, 24));
        formaPagamento = new Long(itemB.getIdentificacaoClienteEmpresa().substring(24, 25));
        itemB.setFormaPagamento(formaPagamento);
        debito = this.debitoRepository.findByCompositeKey(Long.valueOf(1L), exericio, tipoCadastro, cadastroGeral, divida, subdivida);
        if (debito.isPresent()) {
            itemB.setEntidade(((Debito)debito.get()).getEntidade());
            itemB.setExercicio(((Debito)debito.get()).getExercicio());
            itemB.setTipoCadastro(((Debito)debito.get()).getTipoCadastro());
            itemB.setCadastroGeral(((Debito)debito.get()).getCadastroGeralId());
            itemB.setGuiaRecolhimento(((Debito)debito.get()).getGuiaRecolhimento());
            itemB.setSubdivida(((Debito)debito.get()).getSubDivida());
        }
    }

    public ADAItem process(ArquivoDebitoAutomaticoItemDTO item) {
        if (ArquivoDebitoAutomaticoItemTipo.A.equals((Object)item.getTipo())) {
            ADAItemA itemA = (ADAItemA)item.getItem();
            this.stepExecution.getExecutionContext().putLong("codigoBanco", itemA.getCodigoBanco().longValue());
            this.stepExecution.getExecutionContext().putString("codigoConvenio", itemA.getCodigoConvenio());
        }
        if (ArquivoDebitoAutomaticoItemTipo.B.equals((Object)item.getTipo())) {
            ADAItemB itemB = (ADAItemB)item.getItem();
            itemB.setIdentificacaoClienteEmpresa(StringUtils.leftPad((String)itemB.getIdentificacaoClienteEmpresa(), (int)25, (String)"0"));
            this.preencheDebito(itemB);
            return item.getItem();
        }
        return null;
    }

    @Generated
    public ImportacaoArquivoDebitoAutomaticoProcessor(DebitoRepository debitoRepository) {
        this.debitoRepository = debitoRepository;
    }
}

