/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.atualizacaomonetaria;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoObservacaoId;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.TributoPadrao;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetariaItem;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetariaItemId;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoKeyDTO;
import br.com.elotech.tributos.dto.DividaTributoEspelhoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.DebitoParaAtualizarDTO;
import br.com.elotech.tributos.repository.TributoPadraoRepository;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DebitoTributoService;
import br.com.elotech.tributos.service.DividaTributoEspelhoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class AtualizacaoMonetariaParcelamentoBatchProcessor
implements ItemProcessor<DebitoParaAtualizarDTO, Collection<AtualizacaoMonetariaItem>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaParcelamentoBatchProcessor.class);
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final FormaPagamentoService formaPagamentoService;
    private final ObjectMapper objectMapper;
    private final EntityManager entityManager;
    private final TributoPadraoRepository tributoPadraoRepository;
    private final DividaTributoEspelhoService dividaTributoEspelhoService;
    private final DebitoTributoService debitoTributoService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private AtualizacaoMonetariaParcelamentoParams params;
    private Long formaPagamento;
    private Long idAtualizacaoMonetaria;
    private ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos;
    private Map<ClassificacaoTipoTributo, TributoPadrao> tributosPadrao = new HashMap();
    private Map<String, DividaTributoEspelhoDTO> tributosPadraoEspelhamento = new HashMap();

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws JsonProcessingException {
        this.params = (AtualizacaoMonetariaParcelamentoParams)this.objectMapper.readValue(stepExecution.getJobParameters().getString("params"), AtualizacaoMonetariaParcelamentoParams.class);
        this.idAtualizacaoMonetaria = stepExecution.getJobParameters().getLong("idAtualizacaoMonetaria");
        log.debug("Iniciando carregamento de parametros do banco");
        this.formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.params.getExercicio())).getId();
        log.debug("Carregou forma de pagamento");
        this.parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimoBatch();
        log.debug("Carregou parametros dos acrescimos");
        this.tributosPadrao = this.tributoPadraoRepository.findByEntidadeAndExercicio(this.params.getEntidade(), this.params.getExercicio()).stream().collect(Collectors.toMap(TributoPadrao::getClassificacaoTipoTributo, Function.identity()));
        log.debug("Carregou os tributos padr\u00e3o");
        this.tributosPadraoEspelhamento = this.dividaTributoEspelhoService.loadEspelhoComTributoPadrao(this.params.getEntidade(), this.params.getExercicio()).stream().collect(Collectors.toMap(dividaTributoEspelho -> this.buildChaveEspelhamento(dividaTributoEspelho.getDivida(), dividaTributoEspelho.getTributo()), Function.identity()));
        log.debug("Carregou os tributos do espelho");
    }

    public Collection<AtualizacaoMonetariaItem> process(DebitoParaAtualizarDTO debitoParaAtualizarDTO) throws Exception {
        log.debug("Carregando parcelas do debito {} a partir da parcela {}", (Object)debitoParaAtualizarDTO.getIdDebito(), (Object)debitoParaAtualizarDTO.getMinParcela());
        List parcelas = this.debitoEmAbertoService.loadDebitoEmAberto(this.buildFiltro(debitoParaAtualizarDTO), Boolean.valueOf(false));
        log.debug("{} registros encontrados a partir do debito {}", (Object)parcelas.size(), (Object)debitoParaAtualizarDTO.getIdDebito());
        LocalDate novaDataCorrecao = this.params.getDataCorrecao().with(TemporalAdjusters.firstDayOfMonth());
        log.debug("Nova data de corre\u00e7\u00e3o: {}", (Object)novaDataCorrecao);
        LocalDate dataCorrecaoMensal = novaDataCorrecao.minusYears(1L);
        parcelas.forEach(parcela -> {
            parcela.setDataPrimeiraParcela(dataCorrecaoMensal);
            parcela.setDataLancamento(dataCorrecaoMensal);
            parcela.setDataVencimento(dataCorrecaoMensal);
            parcela.setValorOriginalDebito(parcela.getValorPrincipal());
        });
        log.debug("Alterada datas de lancamento, vencimento e primeira parcela para {}", (Object)dataCorrecaoMensal);
        this.calculoAcrescimoService.calculaAcrescimos(parcelas, this.formaPagamento, novaDataCorrecao, this.parametrosAcrescimos);
        log.debug("Calculou os acr\u00e9scimos dos registros filhos do debito {}", (Object)debitoParaAtualizarDTO.getIdDebito());
        this.adicionarObservacao((DebitoEmAbertoDTO)parcelas.get(0), this.params);
        HashMap debitoTributoToSave = new HashMap();
        HashMap debitoParcelaTributoToSave = new HashMap();
        HashMap itensReajuste = new HashMap();
        parcelas.forEach(debito -> {
            log.trace("Iniciando atualizacao do registro {}, valor de correcao {}", (Object)debito.getIdDebitoParcelaReceita(), (Object)debito.getValorCorrecao());
            if (debito.getValorCorrecao().compareTo(BigDecimal.ZERO) == 0) {
                DebitoParcelaTributo debitoParcelaTributoZerado = (DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)debito.getIdDebitoParcelaReceita());
                DebitoParcelaTributoKeyDTO chaveDebitoParcelaTributoZerado = DebitoParcelaTributoKeyDTO.builder().entidade(debito.getEntidade()).exercicio(debito.getExercicio()).tipoCadastro(debito.getTipoCadastro()).cadastroGeral(debito.getCadastroGeral()).divida(debito.getDivida()).subDivida(debito.getSubDivida()).parcela(debito.getParcela()).tributo(debito.getTributo()).build();
                this.createItemReajuste(itensReajuste, debitoParcelaTributoZerado, chaveDebitoParcelaTributoZerado, debito.getValorPrincipal(), debito.getValorOriginalDebito(), debito.getValorCorrecao());
                return;
            }
            String tributoCorrecaoPadrao = this.resolveTributoPadrao(debito);
            log.trace("Os valores de corre\u00e7\u00e3o do registro {} serao incluidos no tributo {}", (Object)debito.getIdDebitoParcelaReceita(), (Object)tributoCorrecaoPadrao);
            DebitoTributoId idDebitoTributo = DebitoTributoId.builder().entidade(debito.getEntidade()).exercicio(debito.getExercicio()).tipoCadastro(debito.getTipoCadastro()).cadastroGeral(debito.getCadastroGeral()).divida(debito.getDivida()).subDivida(debito.getSubDivida()).tributo(tributoCorrecaoPadrao).build();
            DebitoTributo debitoTributo = this.resolveDebitoTributo(debitoTributoToSave, idDebitoTributo);
            log.trace("Resolveu o debitoTributo {} com valor original {}, para o registro {}", new Object[]{idDebitoTributo.formatLog(), debitoTributo.getValorTributo(), debito.getIdDebitoParcelaReceita()});
            debitoTributo.setValorTributo(debitoTributo.getValorTributo().add(debito.getValorCorrecao()));
            DebitoParcelaTributoKeyDTO debitoParcelaTributoKeyDTO = DebitoParcelaTributoKeyDTO.builder().entidade(debito.getEntidade()).exercicio(debito.getExercicio()).tipoCadastro(debito.getTipoCadastro()).cadastroGeral(debito.getCadastroGeral()).divida(debito.getDivida()).subDivida(debito.getSubDivida()).parcela(debito.getParcela()).tributo(tributoCorrecaoPadrao).build();
            DebitoParcelaTributo debitoParcelaTributo = this.resolveDebitoParcelaTributo(debitoParcelaTributoToSave, debitoParcelaTributoKeyDTO);
            log.trace("Resolveu o debitoParcelaTributo. Valores do registro {} serao inseridos no registro {}", (Object)debito.getIdDebitoParcelaReceita(), (Object)debitoParcelaTributoKeyDTO.formatLog());
            BigDecimal valorOriginal = debitoParcelaTributo.getValor();
            debitoParcelaTributo.setValor(debitoParcelaTributo.getValor().add(debito.getValorCorrecao()));
            debitoParcelaTributo.setValorAtualizacao(debitoParcelaTributo.getValorAtualizacao().add(debito.getValorCorrecao()));
            this.createItemReajuste(itensReajuste, debitoParcelaTributo, debitoParcelaTributoKeyDTO, debitoParcelaTributo.getValor(), valorOriginal, debito.getValorCorrecao());
            log.debug("Finalizando atualizacao do registro {}", (Object)debito.getIdDebitoParcelaReceita());
        });
        log.debug("Salvando os registros alterados pelo debito {}", (Object)debitoParaAtualizarDTO.getIdDebito());
        this.debitoTributoService.saveAll(debitoTributoToSave.values());
        log.debug(" {} debitosTributos atualizados", (Object)debitoTributoToSave.size());
        this.debitoParcelaTributoService.saveAll(debitoParcelaTributoToSave.values());
        log.debug(" {} debitoParcelaTributos atualizados", (Object)debitoParcelaTributoToSave.size());
        log.debug("Finalizando processamento do debito {}", (Object)debitoParaAtualizarDTO.getIdDebito());
        return itensReajuste.values();
    }

    private void createItemReajuste(Map<DebitoParcelaTributoKeyDTO, AtualizacaoMonetariaItem> itensReajuste, DebitoParcelaTributo debitoParcelaTributo, DebitoParcelaTributoKeyDTO chaveDebitoParcelaTributo, BigDecimal valor, BigDecimal valorOriginal, BigDecimal valorAtualizacao) {
        itensReajuste.compute(chaveDebitoParcelaTributo, (key, itemExistente) -> {
            if (Objects.isNull(itemExistente)) {
                AtualizacaoMonetariaItem item = new AtualizacaoMonetariaItem();
                item.setId(AtualizacaoMonetariaItemId.of((Long)this.idAtualizacaoMonetaria, (DebitoParcelaTributo)debitoParcelaTributo));
                item.setValor(valor);
                item.setValorOriginal(valorOriginal);
                item.setValorAtualizacao(valorAtualizacao);
                log.trace("Criando item Reajuste com valorAtualizacao {} e valorOriginal {} para o iddebitoparcelatributo {}", new Object[]{valorAtualizacao, valorOriginal, key});
                return item;
            }
            log.trace("Reaproveitando item Reajuste para o iddebitoparcelatributo {} com valor {}", key, (Object)valorAtualizacao);
            itemExistente.setValor(itemExistente.getValor().add(valorAtualizacao));
            itemExistente.setValorAtualizacao(itemExistente.getValorAtualizacao().add(valorAtualizacao));
            return itemExistente;
        });
    }

    private void adicionarObservacao(DebitoEmAbertoDTO debitoParaAtualizarDTO, AtualizacaoMonetariaParcelamentoParams params) {
        DebitoObservacao observacao = new DebitoObservacao();
        observacao.setId(DebitoObservacaoId.of((Long)debitoParaAtualizarDTO.getEntidade(), (Long)debitoParaAtualizarDTO.getExercicio(), (Long)debitoParaAtualizarDTO.getTipoCadastro(), (Long)debitoParaAtualizarDTO.getCadastroGeral(), (Long)debitoParaAtualizarDTO.getDivida(), (Long)debitoParaAtualizarDTO.getSubDivida(), null));
        observacao.setObservacao(String.format("Atualiza\u00e7\u00e3o monet\u00e1ria %d [%d/%d] %s", this.idAtualizacaoMonetaria, params.getMes(), params.getExercicio(), StringUtils.defaultIfBlank((CharSequence)params.getObservacao(), (CharSequence)"")));
        this.debitoObservacaoService.save(observacao);
        log.debug("Adicionou observacao para o debito {}", (Object)debitoParaAtualizarDTO.getIdDebito());
    }

    private String buildFiltro(DebitoParaAtualizarDTO debitoParaAtualizarDTO) {
        return String.format("TRIBDEBITO.IDDEBITO = %d AND TRIBDEBITOPARCELA.PARCELA >= %d", debitoParaAtualizarDTO.getIdDebito(), debitoParaAtualizarDTO.getMinParcela());
    }

    private DebitoParcelaTributo resolveDebitoParcelaTributo(Map<DebitoParcelaTributoKeyDTO, DebitoParcelaTributo> cache, DebitoParcelaTributoKeyDTO keyDTO) {
        return cache.computeIfAbsent(keyDTO, key -> this.debitoParcelaTributoService.findByKey(key).orElseGet(() -> this.createDebitoParcelaTributo(key)));
    }

    private DebitoParcelaTributo createDebitoParcelaTributo(DebitoParcelaTributoKeyDTO key) {
        DebitoParcela parcela = new DebitoParcela();
        parcela.setId(key.toIdParcela());
        DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
        debitoParcelaTributo.setDebitoParcela(parcela);
        debitoParcelaTributo.setTributo(key.getTributo());
        log.trace("Criando debito parcela tributo com a chave {}", (Object)key.formatLog());
        return debitoParcelaTributo;
    }

    private DebitoTributo resolveDebitoTributo(Map<DebitoTributoId, DebitoTributo> cache, DebitoTributoId idDebitoTributo) {
        return cache.computeIfAbsent(idDebitoTributo, id -> this.debitoTributoService.findById((Serializable)idDebitoTributo).orElseGet(() -> this.createDebitoTributo(idDebitoTributo)));
    }

    private DebitoTributo createDebitoTributo(DebitoTributoId idDebitoTributo) {
        DebitoTributo debitoTributo = new DebitoTributo();
        debitoTributo.setId(idDebitoTributo);
        debitoTributo.setOrdem(Long.valueOf(99L));
        log.trace("Criando debito tributo com a chave {}", (Object)idDebitoTributo.formatLog());
        return debitoTributo;
    }

    private String resolveTributoPadrao(DebitoEmAbertoDTO debitoEmAbertoDTO) {
        return (String)this.getTributoPadraoFromEspelhamento(debitoEmAbertoDTO).or(() -> this.getTributoPadrao(debitoEmAbertoDTO)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar configura\u00e7\u00e3o de tributo padr\u00e3o para o id %d, tributo %s exercicio %d", debitoEmAbertoDTO.getIdDebitoParcelaReceita(), debitoEmAbertoDTO.getTributo(), debitoEmAbertoDTO.getExercicio())));
    }

    private Optional<String> getTributoPadraoFromEspelhamento(DebitoEmAbertoDTO debitoEmAbertoDTO) {
        return Optional.ofNullable((DividaTributoEspelhoDTO)this.tributosPadraoEspelhamento.get(this.buildChaveEspelhamento(debitoEmAbertoDTO.getDivida(), debitoEmAbertoDTO.getTributo()))).map(DividaTributoEspelhoDTO::getCorrecao);
    }

    private Optional<String> getTributoPadrao(DebitoEmAbertoDTO debitoEmAbertoDTO) {
        return Optional.ofNullable(debitoEmAbertoDTO.getClassificacaoTipoTributo()).map(ClassificacaoTipoTributo::fromValueWithoutException).map(classificacao -> (TributoPadrao)this.tributosPadrao.get(classificacao)).map(TributoPadrao::getCorrecao);
    }

    private String buildChaveEspelhamento(Long divida, String tributo) {
        return String.format("%d_%s", divida, tributo);
    }

    @OnProcessError
    public void onProcessError(DebitoParaAtualizarDTO debito, Exception e) throws JsonProcessingException {
        log.error("Erro ao processar o item {})", (Object)this.objectMapper.writeValueAsString((Object)debito), (Object)e);
    }

    @Generated
    public AtualizacaoMonetariaParcelamentoBatchProcessor(DebitoEmAbertoService debitoEmAbertoService, CalculoAcrescimoService calculoAcrescimoService, DebitoObservacaoService debitoObservacaoService, FormaPagamentoService formaPagamentoService, ObjectMapper objectMapper, EntityManager entityManager, TributoPadraoRepository tributoPadraoRepository, DividaTributoEspelhoService dividaTributoEspelhoService, DebitoTributoService debitoTributoService, DebitoParcelaTributoService debitoParcelaTributoService) {
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.formaPagamentoService = formaPagamentoService;
        this.objectMapper = objectMapper;
        this.entityManager = entityManager;
        this.tributoPadraoRepository = tributoPadraoRepository;
        this.dividaTributoEspelhoService = dividaTributoEspelhoService;
        this.debitoTributoService = debitoTributoService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
    }
}

