SELECT
    TRIBCADASTROGERAL.TIPOCADASTRO AS tipocadastro,
    TRIBCADASTROGERAL.CADASTROGERAL AS cadastrogeral,
    CASE WHEN PESSOA.PESSOA IS NOT NULL THEN PESSOA.PESSOA  ELSE PESSOA.PESSOA END AS codigoPessoa,
    CASE WHEN PESSOA.NOME IS NOT NULL THEN PESSOA.NOME ELSE PESSOA.NOME END AS nomePessoa,
    TRIBCADASTROGERAL.idkey as idCadastro,
    TIPOLOGRADOURO.DESCRICAO as tipoLogradouro,
    LOGRADOURO.DESCRICAO as logradouro,
    TRIBIMOBILIARIOTESTADA.NUMERO as numero,
    TRIBCADASTROIMOBILIARIO.inscricaocadastral as inscricaoCadastral,
    TRIBCADASTROIMOBILIARIO.setor_inscricaocadastral as setorInscricaoCadastral,
    TRIBCADASTROIMOBILIARIO.distrito_inscricaocadastral as distritoInscricaoCadastral,
    TRIBCADASTROIMOBILIARIO.condominio
FROM TRIBCADASTROGERAL TRIBCADASTROGERAL
         JOIN TRIBCADASTROIMOBILIARIO TRIBCADASTROIMOBILIARIO ON TRIBCADASTROGERAL.TIPOCADASTRO = TRIBCADASTROIMOBILIARIO.TIPOCADASTRO
         AND TRIBCADASTROGERAL.CADASTROGERAL = TRIBCADASTROIMOBILIARIO.CADASTROGERAL
         LEFT JOIN TRIBQUADRICULA TRIBQUADRICULA ON TRIBCADASTROIMOBILIARIO.QUADRICULA_INSCRICAOCADASTRAL = TRIBQUADRICULA.QUADRICULA
         LEFT JOIN TRIBDISTRITO TRIBDISTRITO ON TRIBCADASTROIMOBILIARIO.DISTRITO_INSCRICAOCADASTRAL = TRIBDISTRITO.DISTRITO
         LEFT JOIN TRIBSETOR TRIBSETOR ON TRIBCADASTROIMOBILIARIO.TRIBSETOR_IDKEY = TRIBSETOR.IDKEY
         LEFT JOIN TRIBIMOBILIARIA TRIBIMOBILIARIA ON TRIBCADASTROIMOBILIARIO.IMOBILIARIA = TRIBIMOBILIARIA.IMOBILIARIA
         LEFT JOIN PESSOA PESSOA ON TRIBCADASTROGERAL.PESSOA = PESSOA.PESSOA
         LEFT JOIN TRIBIMOBILIARIOTESTADA TRIBIMOBILIARIOTESTADA ON TRIBIMOBILIARIOTESTADA.TRIBCADASTROGERAL_IDKEY = TRIBCADASTROIMOBILIARIO.TRIBCADASTROGERAL_IDKEY AND TRIBIMOBILIARIOTESTADA.PRINCIPAL = 'S'
         LEFT JOIN TRIBLOGRADOUROTESTADA TRIBLOGRADOUROTESTADA ON TRIBLOGRADOUROTESTADA.IDLOGRADOUROTESTADA = TRIBIMOBILIARIOTESTADA.IDLOGRADOUROTESTADA
         LEFT JOIN CIDADE ON TRIBCADASTROGERAL.CIDADE = CIDADE.CIDADE
         LEFT JOIN LOGRADOURO ON TRIBCADASTROGERAL.LOGRADOURO_IDKEY = LOGRADOURO.IDKEY
         LEFT JOIN TIPOLOGRADOURO TIPOLOGRADOURO ON TIPOLOGRADOURO.TIPOLOGRADOURO = LOGRADOURO.TIPOLOGRADOURO
         LEFT JOIN BAIRRO ON TRIBCADASTROGERAL.BAIRRO_IDKEY = BAIRRO.IDKEY
         LEFT JOIN TRIBCADASTROGERALISENCAO TRIBCADASTROGERALISENCAO ON TRIBCADASTROGERAL.IDKEY = TRIBCADASTROGERALISENCAO.TRIBCADASTROGERAL_IDKEY
         LEFT JOIN TRIBISENCAO TRIBISENCAO ON TRIBCADASTROGERALISENCAO.ISENCAO = TRIBISENCAO.ISENCAO
WHERE TRIBCADASTROGERAL.EXCLUSAOLOGICA = 'N'
%s
GROUP BY TRIBCADASTROGERAL.TIPOCADASTRO,
TRIBCADASTROGERAL.CADASTROGERAL,
PESSOA.PESSOA,
PESSOA.NOME,
TRIBCADASTROGERAL.idkey,
TIPOLOGRADOURO.DESCRICAO,
LOGRADOURO.DESCRICAO,
TRIBIMOBILIARIOTESTADA.NUMERO,
TRIBCADASTROIMOBILIARIO.inscricaocadastral,
TRIBCADASTROIMOBILIARIO.setor_inscricaocadastral,
TRIBCADASTROIMOBILIARIO.distrito_inscricaocadastral,
TRIBCADASTROIMOBILIARIO.condominio