select filtro.DataMovimentacao,
       filtro.iptuex,
       filtro.issex,
       filtro.itbiex,
       filtro.melhoriaex,
       filtro.taxasex,
       filtro.outrosex,
       filtro.cosipex,
       filtro.impugnacaoex,
       filtro.naotribex,
       filtro.iptuda,
       filtro.issda,
       filtro.itbida,
       filtro.melhoriada,
       filtro.taxasda,
       filtro.outrosda,
       filtro.cosipda,
       filtro.impugnacaoda,
       filtro.naotribda,
       filtro.iptu,
       filtro.iss,
       filtro.itbi,
       filtro.melhoria,
       filtro.taxas,
       filtro.outros,
       filtro.cosip,
       filtro.impugnacao,
       filtro.naotrib,
       filtro.SimplesNacional
from
    (
-- Pagamento
Select pg.DataMovimentacao,
       sum(pg.iptuex) as iptuex,
       sum(pg.issex) as issex,
       sum(pg.itbiex) as itbiex,
       sum(pg.melhoriaex) as melhoriaex,
       sum(pg.taxasex) as taxasex,
       sum(pg.outrosex) as outrosex,
       sum(pg.cosipex) as cosipex,
       sum(pg.impugnacaoex) impugnacaoex,
       sum(pg.naotribex) as naotribex,
       sum(pg.iptuda) as iptuda,
       sum(pg.issda) as issda,
       sum(pg.itbida) as itbida,
       sum(pg.melhoriada) as melhoriada,
       sum(pg.taxasda) as taxasda,
       sum(pg.outrosda) as outrosda,
       sum(pg.cosipda) as cosipda,
       sum(pg.impugnacaoda) impugnacaoda,
       sum(pg.naotribda) as naotribda,
       sum(pg.iptu) as iptu,
       sum(pg.iss) as iss,
       sum(pg.itbi) as itbi,
       sum(pg.melhoria) as melhoria,
       sum(pg.taxas) as taxas,
       sum(pg.outros) as outros,
       sum(pg.cosip) as cosip,
       sum(pg.impugnacao) impugnacao,
       sum(pg.naotrib) as naotrib,
       sum(pg.SimplesNacional) as simplesnacional
from (
Select tp.dataLancamento as DataMovimentacao,
       tpd.SituacaoLegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then tpd.valorpago + tpd.valorpagomaior else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then tpd.valorpago + tpd.valorpagomaior else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then tpd.valorpago + tpd.valorpagomaior else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then tpd.valorpago + tpd.valorpagomaior else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then tpd.valorpago + tpd.valorpagomaior else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then tpd.valorpago + tpd.valorpagomaior else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then tpd.valorpago + tpd.valorpagomaior else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then tpd.valorpago + tpd.valorpagomaior else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then tpd.valorpago + tpd.valorpagomaior else 0 end) as naotrib,
       sum(case when tp.simplesnacional = 'S' and tr.tiporeceita = 2 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as SimplesNacional
from tribpagamentodebito tpd
  left join tribpagamentobloqueto tpb on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
  left join tribpagamento tp on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
  left join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
where tp.entidade = :entidade
  and tp.datalancamento  between ':dataInicial' AND ':dataFinal'
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
group by
  tp.dataLancamento,
  tpd.SituacaoLegal,
  tr.TipoReceita,
  tp.simplesnacional
) pg
group by pg.DataMovimentacao
union all
-- Reabilitação Pagamento
Select pg.DataMovimentacao,
       sum(pg.iptuex) as iptuex,
       sum(pg.issex) as issex,
       sum(pg.itbiex) as itbiex,
       sum(pg.melhoriaex) as melhoriaex,
       sum(pg.taxasex) as taxasex,
       sum(pg.outrosex) as outrosex,
       sum(pg.cosipex) as cosipex,
       sum(pg.impugnacaoex) impugnacaoex,
       sum(pg.naotribex) as naotribex,
       sum(pg.iptuda) as iptuda,
       sum(pg.issda) as issda,
       sum(pg.itbida) as itbida,
       sum(pg.melhoriada) as melhoriada,
       sum(pg.taxasda) as taxasda,
       sum(pg.outrosda) as outrosda,
       sum(pg.cosipda) as cosipda,
       sum(pg.impugnacaoda) impugnacaoda,
       sum(pg.naotribda) as naotribda,
       sum(pg.iptu) as iptu,
       sum(pg.iss) as iss,
       sum(pg.itbi) as itbi,
       sum(pg.melhoria) as melhoria,
       sum(pg.taxas) as taxas,
       sum(pg.outros) as outros,
       sum(pg.cosip) as cosip,
       sum(pg.impugnacao) impugnacao,
       sum(pg.naotrib) as naotrib,
       sum(pg.SimplesNacional) as simplesnacional
from (
Select tp.dataLancamento as DataMovimentacao,
       tpd.SituacaoLegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then tpd.valorpago + tpd.valorpagomaior else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then tpd.valorpago + tpd.valorpagomaior else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then tpd.valorpago + tpd.valorpagomaior else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then tpd.valorpago + tpd.valorpagomaior else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then tpd.valorpago + tpd.valorpagomaior else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then tpd.valorpago + tpd.valorpagomaior else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then tpd.valorpago + tpd.valorpagomaior else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then tpd.valorpago + tpd.valorpagomaior else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then tpd.valorpago + tpd.valorpagomaior else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then tpd.valorpago + tpd.valorpagomaior else 0 end) as naotrib,
       sum(case when tp.simplesnacional = 'S' and tr.tiporeceita = 2 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) as SimplesNacional
from tribpagamentodebito tpd
  left join tribpagamentobloqueto tpb on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
  left join tribpagamento tp on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
  left join tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
  left join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
  join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
where tp.entidade = :entidade
  and tep.datareabilitacao is not null
  and tep.datareabilitacao between ':dataInicial' AND ':dataFinal'
  and tep.datareabilitacao <> tep.data
group by
  tp.datalancamento,
  tpd.situacaolegal,
  tr.tipoReceita,
  tp.simplesnacional
) pg
group by pg.DataMovimentacao
union ALL
-- Crédito de Contribuinte
Select pg.DataMovimentacao,
       sum(pg.iptuex) as iptuex,
       sum(pg.issex) as issex,
       sum(pg.itbiex) as itbiex,
       sum(pg.melhoriaex) as melhoriaex,
       sum(pg.taxasex) as taxasex,
       sum(pg.outrosex) as outrosex,
       sum(pg.cosipex) as cosipex,
       sum(pg.impugnacaoex) impugnacaoex,
       sum(pg.naotribex) as naotribex,
       sum(pg.iptuda) as iptuda,
       sum(pg.issda) as issda,
       sum(pg.itbida) as itbida,
       sum(pg.melhoriada) as melhoriada,
       sum(pg.taxasda) as taxasda,
       sum(pg.outrosda) as outrosda,
       sum(pg.cosipda) as cosipda,
       sum(pg.impugnacaoda) impugnacaoda,
       sum(pg.naotribda) as naotribda,
       sum(pg.iptu) as iptu,
       sum(pg.iss) as iss,
       sum(pg.itbi) as itbi,
       sum(pg.melhoria) as melhoria,
       sum(pg.taxas) as taxas,
       sum(pg.outros) as outros,
       sum(pg.cosip) as cosip,
       sum(pg.impugnacao) impugnacao,
       sum(pg.naotrib) as naotrib,
       sum(pg.SimplesNacional) as simplesnacional
from (
Select tcc.data as DataMovimentacao,
       tdp.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal = 0 then tcci.valorlancado else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then tcci.valorlancado else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then tcci.valorlancado else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then tcci.valorlancado else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then tcci.valorlancado else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then tcci.valorlancado else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then tcci.valorlancado else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then tcci.valorlancado else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then tcci.valorlancado else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then tcci.valorlancado else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then tcci.valorlancado else 0 end) as naotrib,
       0 as SimplesNacional
from tribcreditocontribuinte tcc
  left outer join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade  and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte  = tcc.creditocontribuinte
  left outer join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
  left outer join tribdebitoparcela tdp on tdp.entidade  = tdpr.entidade
    and tdp.exercicio = tdpr.exercicio
    and tdp.tipocadastro = tdpr.tipocadastro
    and tdp.cadastrogeral  = tdpr.cadastrogeral
    and tdp.guiarecolhimento  = tdpr.guiarecolhimento
    and tdp.subdivida  = tdpr.subdivida
    and tdp.parcela = tdpr.parcela
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
       join contabancaria cb  on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
where tcc.entidade = :entidade
  and tcc.data BETWEEN ':dataInicial' AND ':dataFinal'
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
group by
  tcc.data,
  tdp.situacaolegal,
  tr.tiporeceita
) pg
group by pg.DataMovimentacao
union all
-- Devolucao de credito
Select pg.DataMovimentacao,
       sum(pg.iptuex) as iptuex,
       sum(pg.issex) as issex,
       sum(pg.itbiex) as itbiex,
       sum(pg.melhoriaex) as melhoriaex,
       sum(pg.taxasex) as taxasex,
       sum(pg.outrosex) as outrosex,
       sum(pg.cosipex) as cosipex,
       sum(pg.impugnacaoex) impugnacaoex,
       sum(pg.naotribex) as naotribex,
       sum(pg.iptuda) as iptuda,
       sum(pg.issda) as issda,
       sum(pg.itbida) as itbida,
       sum(pg.melhoriada) as melhoriada,
       sum(pg.taxasda) as taxasda,
       sum(pg.outrosda) as outrosda,
       sum(pg.cosipda) as cosipda,
       sum(pg.impugnacaoda) impugnacaoda,
       sum(pg.naotribda) as naotribda,
       sum(pg.iptu) as iptu,
       sum(pg.iss) as iss,
       sum(pg.itbi) as itbi,
       sum(pg.melhoria) as melhoria,
       sum(pg.taxas) as taxas,
       sum(pg.outros) as outros,
       sum(pg.cosip) as cosip,
       sum(pg.impugnacao) impugnacao,
       sum(pg.naotrib) as naotrib,
       sum(pg.SimplesNacional) as simplesnacional
from (
Select d.data as DataMovimentacao,
       tdp.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal = 0 then dd.valordevolvido * -1 else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then dd.valordevolvido * -1 else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then dd.valordevolvido * -1 else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then dd.valordevolvido * -1 else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then dd.valordevolvido * -1 else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then dd.valordevolvido * -1 else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then dd.valordevolvido * -1 else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then dd.valordevolvido * -1 else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then dd.valordevolvido * -1 else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then dd.valordevolvido * -1 else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then dd.valordevolvido * -1 else 0 end) as naotrib,
       0 as SimplesNacional
from tribDevolucaoCredito            d
  LEFT join tribDevolucaoCreditoItem     di   on di.iddevolucaocredito = d.iddevolucaocredito
                 left join tribDevolucaoCreditoDebito   dd   on dd.iddevolucaocredito = di.iddevolucaocredito and dd.sequenciaitem = di.sequenciaitem
                 left join tribDebitoParcelaReceita     tdpr on dd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 left join tribdebitoparcela            tdp  on tdp.entidade  = tdpr.entidade and tdp.exercicio = tdpr.exercicio
                                                           and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral  = tdpr.cadastrogeral
                                                           and tdp.guiarecolhimento  = tdpr.guiarecolhimento and tdp.subdivida  = tdpr.subdivida
                                                           and tdp.parcela = tdpr.parcela
                 left join tribreceita                  tr   on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
                 join contabancaria                cb   on cb.entidade = d.entidade and cb.contabancaria = d.contabancaria
where d.entidade = :entidade
          and d.data between ':dataInicial' and ':dataFinal'
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
group by
   d.data,
   tdp.situacaolegal,
   tr.tiporeceita
) pg
group by pg.DataMovimentacao
union all
--Estorno de Pagamento
Select pg.DataMovimentacao,
       sum(pg.iptuex) as iptuex,
       sum(pg.issex) as issex,
       sum(pg.itbiex) as itbiex,
       sum(pg.melhoriaex) as melhoriaex,
       sum(pg.taxasex) as taxasex,
       sum(pg.outrosex) as outrosex,
       sum(pg.cosipex) as cosipex,
       sum(pg.impugnacaoex) impugnacaoex,
       sum(pg.naotribex) as naotribex,
       sum(pg.iptuda) as iptuda,
       sum(pg.issda) as issda,
       sum(pg.itbida) as itbida,
       sum(pg.melhoriada) as melhoriada,
       sum(pg.taxasda) as taxasda,
       sum(pg.outrosda) as outrosda,
       sum(pg.cosipda) as cosipda,
       sum(pg.impugnacaoda) impugnacaoda,
       sum(pg.naotribda) as naotribda,
       sum(pg.iptu) as iptu,
       sum(pg.iss) as iss,
       sum(pg.itbi) as itbi,
       sum(pg.melhoria) as melhoria,
       sum(pg.taxas) as taxas,
       sum(pg.outros) as outros,
       sum(pg.cosip) as cosip,
       sum(pg.impugnacao) impugnacao,
       sum(pg.naotrib) as naotrib,
       sum(pg.SimplesNacional) as simplesnacional
from (
Select tep.data as DataMovimentacao,
       tpd.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal = 0 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then (tpd.valorpago + tpd.valorpagomaior) * -1 else 0 end) as naotrib,
       sum(case when tp.simplesnacional = 'S' and tr.tiporeceita = 2 and tpd.situacaolegal = 0 then tpd.valorpago + tpd.valorpagomaior else 0 end) * -1 as SimplesNacional
from tribestornopagamento tep
  left join tribestornopagamentoitem tepi
    on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
  left join tribpagamentodebito tpd
    on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto
   AND tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
  left join tribpagamentobloqueto tpb
    on tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
  left join tribpagamento tp
    on tp.entidade = tpb.entidade
    and tp.exerciciopagamento = tpb.exerciciopagamento
    and tp.pagamento = tpb.pagamento
  LEFT join contabancaria cb
    on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
  left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
where tep.entidade = :entidade
  and tep.data BETWEEN ':dataInicial' AND ':dataFinal'
  and tep.geracreditocontribuinte = 'N'
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
  and (tep.datareabilitacao is null or (tep.datareabilitacao is not null and tep.data <> tep.datareabilitacao))
group by
   tep.data,
   tpd.situacaolegal,
   tr.tiporeceita,
   tp.simplesnacional
) pg
group by pg.DataMovimentacao
union ALL
--Estorno de Crédito de Contribuinte
Select pg.DataMovimentacao,
       sum(pg.iptuex) as iptuex,
       sum(pg.issex) as issex,
       sum(pg.itbiex) as itbiex,
       sum(pg.melhoriaex) as melhoriaex,
       sum(pg.taxasex) as taxasex,
       sum(pg.outrosex) as outrosex,
       sum(pg.cosipex) as cosipex,
       sum(pg.impugnacaoex) impugnacaoex,
       sum(pg.naotribex) as naotribex,
       sum(pg.iptuda) as iptuda,
       sum(pg.issda) as issda,
       sum(pg.itbida) as itbida,
       sum(pg.melhoriada) as melhoriada,
       sum(pg.taxasda) as taxasda,
       sum(pg.outrosda) as outrosda,
       sum(pg.cosipda) as cosipda,
       sum(pg.impugnacaoda) impugnacaoda,
       sum(pg.naotribda) as naotribda,
       sum(pg.iptu) as iptu,
       sum(pg.iss) as iss,
       sum(pg.itbi) as itbi,
       sum(pg.melhoria) as melhoria,
       sum(pg.taxas) as taxas,
       sum(pg.outros) as outros,
       sum(pg.cosip) as cosip,
       sum(pg.impugnacao) impugnacao,
       sum(pg.naotrib) as naotrib,
       sum(pg.SimplesNacional) as simplesnacional
from (
Select tcc.dataestorno as DataMovimentacao,
       tdp.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal = 0 then tcci.valorestornado * -1 else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then tcci.valorestornado * -1 else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then tcci.valorestornado * -1 else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then tcci.valorestornado * -1 else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then tcci.valorestornado * -1 else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then tcci.valorestornado * -1 else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then tcci.valorestornado * -1 else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then tcci.valorestornado * -1 else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then tcci.valorestornado * -1 else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then tcci.valorestornado * -1 else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then tcci.valorestornado * -1 else 0 end) as naotrib,
       0.00 AS SimplesNacional
from tribcreditocontribuinte tcc
  left join tribCreditoContribuinteItem tcci
     on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio
     and tcci.creditocontribuinte = tcc.creditocontribuinte
  left join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancariaestorno = cb.contabancaria
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
  left join tribdebitoparcela            tdp
     on tdp.entidade  = tdpr.entidade
     and tdp.exercicio = tdpr.exercicio
    and tdp.tipocadastro = tdpr.tipocadastro
    and tdp.cadastrogeral  = tdpr.cadastrogeral
    and tdp.guiarecolhimento  = tdpr.guiarecolhimento
    and tdp.subdivida  = tdpr.subdivida
    and tdp.parcela = tdpr.parcela
  left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
where tcc.entidade = :entidade
  and tcc.dataestorno BETWEEN ':dataInicial' AND ':dataFinal'
  and tcc.valorestornado > 0
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
GROUP BY
   tcc.dataestorno,
   tdp.situacaolegal,
   tr.tiporeceita
) pg
group by pg.DataMovimentacao
) as filtro