select rd.Entidade,
       rd.TipoCadastro,
       rd.CadastroGeral,
       rd.Exercicio,
       rd.GuiaRecolhimento,
       rd.SubDivida,
       tdao.Identificacao,
       tdao.DataAutorizacao,
       tdao.Banco,
       tdao.convenio,
       CompletaString(tdao.Agencia,' ','D',4) as Agencia,
       bloq.DataVencimento,
       CompletaString(tdao.IdentificacaoOrigem,' ','D',25) as  ClienteEmpresa,
       bloq.NossoNumero as UsoDaEmpresa,
       sum(bloqDeb.valorPrincipal-bloqDeb.valordesconto) as Valor
from tribremdebitoautomaticodetalhe rd
join tribBloqueto bloq
 on rd.entidade = bloq.entidade
and rd.exerciciobloqueto = bloq.exerciciobloqueto
and rd.bloqueto = bloq.bloqueto
join tribBloquetoDebito bloqDeb
 on bloq.Entidade = bloqDeb.Entidade
and bloq.ExercicioBloqueto = bloqDeb.ExercicioBloqueto
and bloq.Bloqueto = bloqDeb.Bloqueto
join tribDebitoParcelaReceita recID
 on bloqDeb.IDDebitoParcelaReceita = recID.IDDebitoParcelaReceita
and rd.Entidade = recID.Entidade
and rd.TipoCadastro = recID.TipoCadastro
and rd.CadastroGeral = recID.CadastroGeral
and rd.Exercicio = recID.Exercicio
and rd.GuiaRecolhimento = recID.GuiaRecolhimento
and rd.SubDivida = recID.SubDivida
join TribDebitoAutomaticoOpcao tdao
on tdao.Entidade = rd.Entidade
and tdao.TipoCadastro = rd.TipoCadastro
and tdao.CadastroGeral = rd.CadastroGeral
and tdao.Exercicio = rd.Exercicio
and tdao.GuiaRecolhimento = rd.GuiaRecolhimento
and tdao.SubDivida = rd.SubDivida
where tdao.dataExclusao is null
and rd.idremdebitoautomatico = :idRemessa
group by rd.Entidade,
       rd.TipoCadastro,
       rd.CadastroGeral,
       rd.Exercicio,
       rd.GuiaRecolhimento,
       rd.SubDivida,
       tdao.Identificacao,
       tdao.DataAutorizacao,
       tdao.Banco,
       tdao.convenio,
       tdao.Agencia,
       bloq.DataVencimento,
       tdao.IdentificacaoOrigem,
       bloq.NossoNumero