with imobiliario as
(
select tcg.tipocadastro,
      tcg.cadastrogeral,
      case when
        tcg.exclusaologica = 'S' then
        'E'
        else
        'I'
      end as TipoOperacao,
      pe1.pessoa,
      pe1.nome,
      pe1.tipopessoa,
      pe1.cnpj_cpf,
      ci.complementolote as complemento,
      tcg.CodigoSistemaAnterior,
      tcg.suspensoemissao,
      tcg.exclusaologica,
      tcg.englobado,
      tcg.datainclusao,
      tcg.dataalteracao,
      tcg.logradouro,
      tl.sigla as tipologradouro,
      lg.descricao as desclogradouro,
      tcg.numero,
      tcg.bairro,
      tcg.cep,
      cd.descricao as desccidade,
      ba.descricao as descbairro,
      ci.inscricaocadastral,
      ci.inscricaocadastralanterior,
      ci.trecho_inscricaocadastral,
      ci.quadra_inscricaocadastral,
      ci.lote_inscricaocadastral,
      ci.distrito_inscricaocadastral,
      ci.setor_inscricaocadastral,
      ci.unidade_inscricaocadastral,
      ci.distrito_descr,
      di1.descricao as descdistrito,
      ci.setor_descr,
      ci.trecho_descr,
      ci.quadra_descr,
      ci.lote_descr,
      ci.unidade_descr,
      ci.imobiliaria,
      ci.condominio,
      co.descricao as desccondominio,
      ci.loteamento,
      lo.descricao as descloteamento,
      ci.tipoimovel,
      ci.anoaliquotaprogressiva,
      (trunc(ci.arealote,2)) as arealote,
      ci.profundidademedia,
      (trunc(ci.areatotalconstruida,2)) as areatotalconstruida,
      ci.limitacercamuro,
      ci.imovelproprio,
      ci.matricula,
      ci.Cartorio,
      ci.datamatricula,
      ci.livro,
      ci.folha,
      ci.facequadra,
      ci.caucionado,
      ci.latitude,
      ci.longitude,
      (trunc(ci.areautillote,2)) as areautillote,
      (trunc(ci.areaprivativa,2)) as areaprivativa,
      (trunc(ci.areacomum,2)) as areacomum,
      ci.complementolote,
      Ise.Isencao as CodIsencao,
      Ise.Descricao as DescIsencao,
      tbit.modeloresposta,
      coalesce((select sum(trunc(area,2))
          from tribimobiliarioareaverde tia
         where tia.tipocadastro = tcg.tipocadastro
         and tia.cadastrogeral = tcg.cadastrogeral),0) as areaverde
from tribCadastroGeral tcg
Left Outer Join TribIsencao Ise on
     Ise.Isencao = TCG.CodigoIsencao
left outer join tribCadastroImobiliario ci on
      ci.tipocadastro = tcg.tipocadastro and
      ci.cadastrogeral = tcg.cadastrogeral
left outer join tribDistrito di1 on
     di1.distrito = ci.distrito_inscricaocadastral
left outer join tribSetor se1 on
     se1.distrito = ci.distrito_inscricaocadastral and
     se1.setor = ci.setor_inscricaocadastral
left outer join tribLoteamento lo on
     lo.distrito = ci.distrito_inscricaocadastral and
     lo.setor = ci.setor_inscricaocadastral and
     lo.loteamento = ci.loteamento
left outer join tribCondominio co on
     co.distrito = ci.distrito_inscricaocadastral and
     co.setor = ci.setor_inscricaocadastral and
     co.condominio = ci.condominio
left outer join Pessoa pe1 on
     pe1.pessoa = tcg.pessoa
left outer join logradouro lg on
     lg.cidade = tcg.cidade and
     lg.logradouro = tcg.logradouro
left outer join tipologradouro tl on
     tl.tipologradouro = lg.tipologradouro
left outer join bairro ba on
     ba.cidade = tcg.cidade and
     ba.bairro = tcg.bairro
left outer join cidade cd on
     cd.cidade = tcg.cidade
left outer join tribboletimimobiliarioterreno tbit on
     tbit.tipocadastro = ci.tipocadastro and
     tbit.cadastrogeral = ci.cadastrogeral and
     tbit.modelo = 1 and
     tbit.modelogrupo = 1 and
     tbit.modelocampo = 5
where tcg.tipocadastro =  1
%s
)
select imobiliario.tipocadastro,
       imobiliario.cadastrogeral,
       imobiliario.TipoOperacao,
      imobiliario.pessoa,
      imobiliario.nome,
      imobiliario.tipopessoa,
      imobiliario.cnpj_cpf,
      imobiliario.complemento,
      imobiliario.CodigoSistemaAnterior,
      imobiliario.suspensoemissao,
      imobiliario.exclusaologica,
      imobiliario.englobado,
      imobiliario.datainclusao,
      imobiliario.dataalteracao,
      imobiliario.logradouro,
      imobiliario.tipologradouro,
      imobiliario.desclogradouro,
      imobiliario.numero,
      imobiliario.bairro,
      imobiliario.cep,
      imobiliario.desccidade,
      imobiliario.descbairro,
      imobiliario.inscricaocadastral,
      imobiliario.inscricaocadastralanterior,
      imobiliario.trecho_inscricaocadastral,
      imobiliario.quadra_inscricaocadastral,
      imobiliario.lote_inscricaocadastral,
      imobiliario.distrito_inscricaocadastral,
      imobiliario.setor_inscricaocadastral,
      imobiliario.unidade_inscricaocadastral,
      imobiliario.distrito_descr,
      imobiliario.descdistrito,
      imobiliario.setor_descr,
      imobiliario.trecho_descr,
      imobiliario.quadra_descr,
      imobiliario.lote_descr,
      imobiliario.unidade_descr,
      imobiliario.imobiliaria,
      imobiliario.condominio,
      imobiliario.desccondominio,
      imobiliario.loteamento,
      imobiliario.descloteamento,
      imobiliario.tipoimovel,
      imobiliario.anoaliquotaprogressiva,
      imobiliario.arealote,
      imobiliario.profundidademedia,
      imobiliario.areatotalconstruida,
      imobiliario.limitacercamuro,
      imobiliario.imovelproprio,
      imobiliario.matricula,
      imobiliario.Cartorio,
      imobiliario.datamatricula,
      imobiliario.livro,
      imobiliario.folha,
      imobiliario.facequadra,
      imobiliario.caucionado,
      imobiliario.latitude,
      imobiliario.longitude,
      imobiliario.areautillote,
      imobiliario.areaprivativa,
      imobiliario.areacomum,
      imobiliario.complementolote,
      imobiliario.CodIsencao,
      imobiliario.DescIsencao,
      imobiliario.modeloresposta,
      imobiliario.areaverde,
      ARRAY_AGG(proprietarios.*) as proprietarios,
      ARRAY_AGG(terrenos.*) as terrenos,
      ARRAY_AGG(segmentos.*) as segmentos,
      ARRAY_AGG(areasverdes.*) as areasverdes,
      ARRAY_AGG(testadas.*) as testadas
from imobiliario
  left join (
    select
    tcg.Tipocadastro,
    tcg.CadastroGeral,
    pr.pessoa,
    pe3.tipopessoa,
    pe3.nome,
    pe3.nomefantasia,
    pe3.cnpj_cpf,
    PE3.RG,
    PE3.OrgaoEmissor,
    case when pr.vinculo = 1 then
         pr.principal
         else
         pr.coresponsavelprincipal
         end as principal,
    pr.vinculo,
    tv.descricao as desctipovinculo,
    (trunc(pr.percentual,3)) as percentual,
    tplo.sigla,
    log.descricao as DescLogradouro,
    Ende.Numero,
    Ende.CEP as CEP,
    Ende.Complemento as Complemento,
    Ende.UnidadeFederacao,
    bai.descricao as DescBairro,
    cid.descricao as DescCidade,
    CP.telefoneresidencial as TELRES,
    CP.TelefoneComercial as TELCOM,
    CP.TelefoneCelular as CELULAR,
    cp.email
    from tribcadastroimobiliario CI
    left outer join tribcadastrogeral TCG on
    CI.Tipocadastro = TCG.Tipocadastro and
    CI.CadastroGeral = TCG.CadastroGeral
    left outer join tribproprietario pr on
    PR.Tipocadastro = CI.Tipocadastro and
    PR.CadastroGeral = CI.CadastroGeral
    left outer join pessoa PE3 on
    PE3.Pessoa = PR.Pessoa
    left outer join Enderecopessoa Ende on
    Ende.pessoa = pe3.pessoa and
    Ende.sequencia = coalesce(pe3.sequenciaendereco, 1)
    Left outer Join ContatoPessoa CP on
      Cp.Pessoa = Pe3.Pessoa and
      CP.Sequencia = PE3.SequenciaContato
    Left outer join tribvinculo tv on
    tv.vinculo = pr.vinculo
    left outer join logradouro log on
      log.cidade = ende.cidade and
      log.logradouro = ende.logradouro
    Left outer join tipologradouro tplo on
      tplo.tipologradouro = log.tipologradouro
    left outer join bairro bai on
         bai.cidade = ende.cidade and
         bai.bairro = ende.bairro
    left outer join cidade cid on
         cid.cidade = ende.cidade
    order by pr.principal desc
) proprietarios
   on proprietarios.tipocadastro = imobiliario.tipocadastro
   and proprietarios.cadastrogeral = imobiliario.cadastrogeral
left join (
  SELECT
    A.TIPOCADASTRO,
    A.CADASTROGERAL,
    UPPER(B.DESCRICAO) AS CAMPO,
    UPPER(C.DESCRICAO) AS RESPOSTA
  FROM TRIBBOLETIMIMOBILIARIOTERRENO A
  LEFT OUTER JOIN TRIBMODELOCAMPO B
    ON A.MODELO = B.MODELO
    AND A.MODELOGRUPO = B.MODELOGRUPO
    AND A.MODELOCAMPO = B.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELORESPOSTA C
    ON A.MODELO = C.MODELO
    AND A.MODELOGRUPO = C.MODELOGRUPO
    AND A.MODELOCAMPO = C.MODELOCAMPO
    AND A.MODELORESPOSTA = C.MODELORESPOSTA
  where A.MODELO = 1
    AND A.MODELOGRUPO = 1
    AND A.MODELOCAMPO IN (1,10)
  ORDER BY B.MODELO,B.MODELOGRUPO,B.MODELOCAMPO
) terrenos
   on terrenos.tipocadastro = imobiliario.tipocadastro
   and terrenos.cadastrogeral = imobiliario.cadastrogeral
 left join (
    SELECT A.TIPOCADASTRO,
           A.CADASTROGERAL,
           A.SEQUENCIA,
           UPPER(A3.DESCRICAO) AS TIPOSEGMENTO,
           A.AREACONSTRUIDA,
           A.PRINCIPAL,
           UPPER(B.DESCRICAO) AS CAMPO,
           COALESCE (A2.DESCRICAORESPOSTA, UPPER(C.DESCRICAO)) AS RESPOSTA,
           D.DESCRICAO AS SITUACAOSEGMENTO
    FROM TRIBIMOBILIARIOSEGMENTO A
    LEFT OUTER JOIN TRIBBOLETIMIMOBILIARIOSEGMENTO A2
                 ON A.TIPOCADASTRO = A2.TIPOCADASTRO
                AND A.CADASTROGERAL = A2.CADASTROGERAL
                AND A.SEQUENCIA = A2.SEQUENCIA
    LEFT OUTER JOIN TRIBTIPOSEGMENTO A3
                 ON A.TIPOSEGMENTO = A3.TIPOSEGMENTO
    LEFT OUTER JOIN TRIBMODELOCAMPO B
                 ON A2.MODELO = B.MODELO
                AND A2.MODELOGRUPO = B.MODELOGRUPO
                AND A2.MODELOCAMPO = B.MODELOCAMPO
    LEFT OUTER JOIN TRIBMODELORESPOSTA C
                 ON A2.MODELO = C.MODELO
                AND A2.MODELOGRUPO = C.MODELOGRUPO
                AND A2.MODELOCAMPO = C.MODELOCAMPO
                AND A2.MODELORESPOSTA = C.MODELORESPOSTA
    LEFT OUTER JOIN TRIBSITUACAOSEGMENTOIMOB D
                 ON D.IDSITUACAOSEGMENTO = A.IDSITUACAOSEGMENTO
      WHERE A2.MODELO = 1
      AND A2.MODELOGRUPO = 3
    ORDER BY A.SEQUENCIA,
             A2.MODELO,
             A2.MODELOGRUPO,
             A2.MODELOCAMPO
) segmentos
   on segmentos.tipocadastro = imobiliario.tipocadastro
   and segmentos.tipocadastro = imobiliario.cadastrogeral
left join (
    SELECT
      A.TIPOCADASTRO,
      A.CADASTROGERAL,
      A.SEQUENCIA,
      A.AREA,
      B.SIGLA,
      UPPER(B.DESCRICAO) AS TIPO
    FROM TRIBIMOBILIARIOAREAVERDE A
    LEFT OUTER JOIN TRIBTIPOAREAVERDE B
    ON A.TIPOAREAVERDE = B.TIPOAREAVERDE
    ORDER BY A.SEQUENCIA
) areasverdes
   on areasverdes.tipocadastro = imobiliario.tipocadastro
   and areasverdes.tipocadastro = imobiliario.cadastrogeral
left join (
    SELECT
      A.TIPOCADASTRO,
      A.CADASTROGERAL,
      A.IDLOGRADOUROTESTADA AS COD_TESTADA,
      A.PRINCIPAL,
      TL.SIGLA AS TIPOLOGRADOURO,
      B.LOGRADOURO       AS LOG_COD,
      LOG1.DESCRICAO     AS LOG_DESCR,
      B.LOGRADOUROTRECHO AS LOGTRECHO_COD,
      LOG2.DESCRICAO     AS LOGTRECHO_DESCR,
      (cast(A.TAMANHOTESTADA as numeric(16,2)) * 100) AS TAMANHOTESTADA
    FROM TRIBIMOBILIARIOTESTADA A
    LEFT OUTER JOIN TRIBLOGRADOUROTESTADA B
    ON A.IDLOGRADOUROTESTADA = B.IDLOGRADOUROTESTADA
    LEFT OUTER JOIN LOGRADOURO LOG1
    ON B.CIDADE = LOG1.CIDADE
    AND B.LOGRADOURO = LOG1.LOGRADOURO
    LEFT OUTER JOIN TRIBLOGRADOUROTRECHO TLT
    ON B.SETOR = TLT.SETOR
    AND B.LOGRADOUROTRECHO = TLT.LOGRADOUROTRECHO
    LEFT OUTER JOIN LOGRADOURO LOG2
    ON TLT.CIDADE = LOG2.CIDADE
    AND TLT.LOGRADOURO = LOG2.LOGRADOURO
    LEFT OUTER JOIN TIPOLOGRADOURO TL
    ON TL.TIPOLOGRADOURO = LOG1.TIPOLOGRADOURO
    ORDER BY A.IDLOGRADOUROTESTADA
) testadas
   on testadas.tipocadastro = imobiliario.tipocadastro
   and testadas.tipocadastro = imobiliario.cadastrogeral
group by imobiliario.tipocadastro,
       imobiliario.cadastrogeral,
       imobiliario.TipoOperacao,
       imobiliario.pessoa,
       imobiliario.nome,
       imobiliario.tipopessoa,
       imobiliario.cnpj_cpf,
       imobiliario.complemento,
       imobiliario.CodigoSistemaAnterior,
       imobiliario.suspensoemissao,
       imobiliario.exclusaologica,
       imobiliario.englobado,
       imobiliario.datainclusao,
       imobiliario.dataalteracao,
       imobiliario.logradouro,
       imobiliario.tipologradouro,
       imobiliario.desclogradouro,
       imobiliario.numero,
       imobiliario.bairro,
       imobiliario.cep,
       imobiliario.desccidade,
       imobiliario.descbairro,
       imobiliario.inscricaocadastral,
       imobiliario.inscricaocadastralanterior,
       imobiliario.trecho_inscricaocadastral,
       imobiliario.quadra_inscricaocadastral,
       imobiliario.lote_inscricaocadastral,
       imobiliario.distrito_inscricaocadastral,
       imobiliario.setor_inscricaocadastral,
       imobiliario.unidade_inscricaocadastral,
       imobiliario.distrito_descr,
       imobiliario.descdistrito,
       imobiliario.setor_descr,
       imobiliario.trecho_descr,
       imobiliario.quadra_descr,
       imobiliario.lote_descr,
       imobiliario.unidade_descr,
       imobiliario.imobiliaria,
       imobiliario.condominio,
       imobiliario.desccondominio,
       imobiliario.loteamento,
       imobiliario.descloteamento,
       imobiliario.tipoimovel,
       imobiliario.anoaliquotaprogressiva,
       imobiliario.arealote,
       imobiliario.profundidademedia,
       imobiliario.areatotalconstruida,
       imobiliario.limitacercamuro,
       imobiliario.imovelproprio,
       imobiliario.matricula,
       imobiliario.Cartorio,
       imobiliario.datamatricula,
       imobiliario.livro,
       imobiliario.folha,
       imobiliario.facequadra,
       imobiliario.caucionado,
       imobiliario.latitude,
       imobiliario.longitude,
       imobiliario.areautillote,
       imobiliario.areaprivativa,
       imobiliario.areacomum,
       imobiliario.complementolote,
       imobiliario.CodIsencao,
       imobiliario.DescIsencao,
       imobiliario.modeloresposta,
       imobiliario.areaverde