--arrecadacao por pagamento
SELECT 'Pagamentos' as TIPO,
       COALESCE(SUM(X.VALORPRINCIPAL),0) AS VALORPRINCIPAL,
       COALESCE(SUM(X.VALORJUROS),0) AS VALORJUROS,
       COALESCE(SUM(X.VALORMULTA),0) AS VALORMULTA,
       COALESCE(SUM(X.VALORCORRECAO),0) AS VALORCORRECAO,
       COALESCE(SUM(X.VALORDESCONTO),0) AS VALORDESCONTO,
       COALESCE(SUM(X.VALORPRINCIPAL + X.VALORJUROS + X.VALORMULTA + X.VALORCORRECAO - X.VALORDESCONTO),0) AS VALORTOTAL
FROM (
SELECT A.ENTIDADE,
       A.EXERCICIOPAGAMENTO,
       A.PAGAMENTO,
       A.DATAPAGAMENTO,
       A.DATALANCAMENTO AS DATAMOVIMENTACAO,
       C.VALORPRINCIPAL + COALESCE(C.VALORPAGOMAIOR,0) AS VALORPRINCIPAL,
       C.VALORJUROS,
       C.VALORMULTA,
       C.VALORCORRECAO,
       CASE
          WHEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0) > 0
             THEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0)
             ELSE COALESCE(C.VALORDESCONTO,0) + COALESCE(C.VALORPAGOMENOR,0)
       END AS VALORDESCONTO,
       C.VALORPAGOMENOR,
       C.VALORPAGOMAIOR,
       C.VALORPAGO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBPAGAMENTO A
LEFT OUTER JOIN TRIBPAGAMENTOBLOQUETO B
 ON A.ENTIDADE = B.ENTIDADE
AND A.EXERCICIOPAGAMENTO = B.EXERCICIOPAGAMENTO
AND A.PAGAMENTO = B.PAGAMENTO
LEFT OUTER JOIN TRIBPAGAMENTODEBITO C
 ON B.IDPAGAMENTOBLOQUETO = C.IDPAGAMENTOBLOQUETO
LEFT OUTER JOIN CONTABANCARIA CB
 ON A.ENTIDADE = CB.ENTIDADE
AND A.CONTABANCARIA = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON C.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'
) X
:FILTRO
UNION ALL
--arrecadacao por estorno pagamento
SELECT 'Estorno Pagamentos' as TIPO,
       COALESCE(SUM(X.VALORPRINCIPAL) * -1,0) AS VALORPRINCIPAL,
       COALESCE(SUM(X.VALORJUROS) * -1,0) AS VALORJUROS,
       COALESCE(SUM(X.VALORMULTA) * -1,0) AS VALORMULTA,
       COALESCE(SUM(X.VALORCORRECAO) * -1,0) AS VALORCORRECAO,
       COALESCE(SUM(X.VALORDESCONTO) * -1,0) AS VALORDESCONTO,
       COALESCE(SUM(X.VALORPRINCIPAL + X.VALORJUROS + X.VALORMULTA + X.VALORCORRECAO - X.VALORDESCONTO) * -1,0) AS VALORTOTAL
FROM (
SELECT A.ENTIDADE,
       A.EXERCICIOPAGAMENTO,
       A.PAGAMENTO,
       EP.DATA AS DATAMOVIMENTACAO,
       C.VALORPRINCIPAL + COALESCE(C.VALORPAGOMAIOR,0) AS VALORPRINCIPAL,
       C.VALORJUROS,
       C.VALORMULTA,
       C.VALORCORRECAO,
       CASE
          WHEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0) > 0
             THEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0)
             ELSE COALESCE(C.VALORDESCONTO,0) + COALESCE(C.VALORPAGOMENOR,0)
       END AS VALORDESCONTO,
       C.VALORPAGOMENOR,
       C.VALORPAGOMAIOR,
       C.VALORPAGO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBESTORNOPAGAMENTO EP
LEFT OUTER JOIN TRIBPAGAMENTO A
 ON EP.ENTIDADE = A.ENTIDADE
AND EP.EXERCICIOPAGAMENTO = A.EXERCICIOPAGAMENTO
AND EP.PAGAMENTO = A.PAGAMENTO
LEFT OUTER JOIN TRIBESTORNOPAGAMENTOITEM EPI
 ON EP.ENTIDADE = EPI.ENTIDADE
AND EP.EXERCICIO = EPI.EXERCICIO
AND EP.ESTORNO = EPI.ESTORNO
LEFT OUTER JOIN TRIBPAGAMENTODEBITO C
 ON EPI.IDPAGAMENTOBLOQUETO = C.IDPAGAMENTOBLOQUETO
AND EPI.IDDEBITOPARCELARECEITA = C.IDDEBITOPARCELARECEITA
LEFT OUTER JOIN CONTABANCARIA CB
 ON EP.ENTIDADE = CB.ENTIDADE
AND EP.CONTABANCARIAESTORNO = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON C.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'
AND COALESCE(EP.REABILITADO, 'N') = 'N'
) X
:FILTRO
UNION ALL
--arrecadacao por reabilitacao estorno pagamento
SELECT 'Reabilitação Estorno Pagamentos' as TIPO,
       COALESCE(SUM(X.VALORPRINCIPAL),0) AS VALORPRINCIPAL,
       COALESCE(SUM(X.VALORJUROS),0) AS VALORJUROS,
       COALESCE(SUM(X.VALORMULTA),0) AS VALORMULTA,
       COALESCE(SUM(X.VALORCORRECAO),0) AS VALORCORRECAO,
       COALESCE(SUM(X.VALORDESCONTO),0) AS VALORDESCONTO,
       COALESCE(SUM(X.VALORPRINCIPAL + X.VALORJUROS + X.VALORMULTA + X.VALORCORRECAO - X.VALORDESCONTO),0) AS VALORTOTAL
FROM (
SELECT A.ENTIDADE,
       A.EXERCICIOPAGAMENTO,
       A.PAGAMENTO,
       EP.DATAREABILITACAO AS DATAMOVIMENTACAO,
       C.VALORPRINCIPAL + COALESCE(C.VALORPAGOMAIOR,0) AS VALORPRINCIPAL,
       C.VALORJUROS,
       C.VALORMULTA,
       C.VALORCORRECAO,
       CASE
          WHEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0) > 0
             THEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0)
             ELSE COALESCE(C.VALORDESCONTO,0) + COALESCE(C.VALORPAGOMENOR,0)
       END AS VALORDESCONTO,
       C.VALORPAGOMENOR,
       C.VALORPAGOMAIOR,
       C.VALORPAGO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBESTORNOPAGAMENTO EP
LEFT OUTER JOIN TRIBPAGAMENTO A
 ON EP.ENTIDADE = A.ENTIDADE
AND EP.EXERCICIOPAGAMENTO = A.EXERCICIOPAGAMENTO
AND EP.PAGAMENTO = A.PAGAMENTO
LEFT OUTER JOIN TRIBESTORNOPAGAMENTOITEM EPI
 ON EP.ENTIDADE = EPI.ENTIDADE
AND EP.EXERCICIO = EPI.EXERCICIO
AND EP.ESTORNO = EPI.ESTORNO
LEFT OUTER JOIN TRIBPAGAMENTODEBITO C
 ON EPI.IDPAGAMENTOBLOQUETO = C.IDPAGAMENTOBLOQUETO
AND EPI.IDDEBITOPARCELARECEITA = C.IDDEBITOPARCELARECEITA
LEFT OUTER JOIN CONTABANCARIA CB
 ON A.ENTIDADE = CB.ENTIDADE
AND A.CONTABANCARIA = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON C.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'
AND COALESCE(EP.REABILITADO, 'N') = 'S'
) X
:FILTRO
UNION ALL
--arrecadacao por credito
SELECT 'Créditos' as TIPO,
       COALESCE(SUM(X.VALORPRINCIPAL),0) AS VALORPRINCIPAL,
       COALESCE(SUM(X.VALORJUROS),0) AS VALORJUROS,
       COALESCE(SUM(X.VALORMULTA),0) AS VALORMULTA,
       COALESCE(SUM(X.VALORCORRECAO),0) AS VALORCORRECAO,
       COALESCE(SUM(X.VALORDESCONTO),0) AS VALORDESCONTO,
       COALESCE(SUM(X.VALORPRINCIPAL + X.VALORJUROS + X.VALORMULTA + X.VALORCORRECAO - X.VALORDESCONTO),0) AS VALORTOTAL
FROM (
SELECT D.ENTIDADE,
       D.EXERCICIO AS EXERCICIOCREDITO,
       D.CREDITOCONTRIBUINTE AS CREDITO,
       D.DATA AS DATAMOVIMENTACAO,
       E.VALORPRINCIPAL,
       E.VALORJUROS,
       E.VALORMULTA,
       E.VALORCORRECAO,
       CASE
         WHEN COALESCE(E.VALORDESCONTOPRINCIPAL,0) + COALESCE(E.VALORDESCONTOJUROS,0) + COALESCE(E.VALORDESCONTOMULTA,0) + COALESCE(E.VALORDESCONTOCORRECAO,0) + COALESCE(E.VALORDESCONTOJUROSFINAN, 0) > 0
           THEN COALESCE(E.VALORDESCONTOPRINCIPAL,0) + COALESCE(E.VALORDESCONTOJUROS,0) + COALESCE(E.VALORDESCONTOMULTA,0) + COALESCE(E.VALORDESCONTOCORRECAO,0) + COALESCE(E.VALORDESCONTOJUROSFINAN, 0)
           ELSE COALESCE(E.VALORDESCONTO,0)
       END AS VALORDESCONTO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBCREDITOCONTRIBUINTE D
LEFT OUTER JOIN TRIBCREDITOCONTRIBUINTEITEM E
 ON D.ENTIDADE = E.ENTIDADE
AND D.EXERCICIO = E.EXERCICIO
AND D.CREDITOCONTRIBUINTE = E.CREDITOCONTRIBUINTE
LEFT OUTER JOIN CONTABANCARIA CB
 ON D.ENTIDADE = CB.ENTIDADE
AND D.CONTABANCARIA = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON E.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'
) X
:FILTRO
UNION ALL
--arrecadacao por estorno credito
SELECT 'Estorno Créditos' as TIPO,
       COALESCE(SUM(X.VALORPRINCIPAL) * -1,0) AS VALORPRINCIPAL,
       COALESCE(SUM(X.VALORJUROS) * -1,0) AS VALORJUROS,
       COALESCE(SUM(X.VALORMULTA) * -1,0) AS VALORMULTA,
       COALESCE(SUM(X.VALORCORRECAO) * -1,0) AS VALORCORRECAO,
       COALESCE(SUM(X.VALORDESCONTO) * -1,0) AS VALORDESCONTO,
       COALESCE(SUM(X.VALORPRINCIPAL + X.VALORJUROS + X.VALORMULTA + X.VALORCORRECAO - X.VALORDESCONTO) * -1,0) AS VALORTOTAL
FROM (
SELECT D.ENTIDADE,
       D.EXERCICIO AS EXERCICIOCREDITO,
       D.CREDITOCONTRIBUINTE AS CREDITO,
       D.DATAESTORNO AS DATAMOVIMENTACAO,
       E.VALORPRINCIPAL,
       E.VALORJUROS,
       E.VALORMULTA,
       E.VALORCORRECAO,
       CASE
         WHEN COALESCE(E.VALORDESCONTOPRINCIPAL,0) + COALESCE(E.VALORDESCONTOJUROS,0) + COALESCE(E.VALORDESCONTOMULTA,0) + COALESCE(E.VALORDESCONTOCORRECAO,0) + COALESCE(E.VALORDESCONTOJUROSFINAN, 0) > 0
           THEN COALESCE(E.VALORDESCONTOPRINCIPAL,0) + COALESCE(E.VALORDESCONTOJUROS,0) + COALESCE(E.VALORDESCONTOMULTA,0) + COALESCE(E.VALORDESCONTOCORRECAO,0) + COALESCE(E.VALORDESCONTOJUROSFINAN, 0)
           ELSE COALESCE(E.VALORDESCONTO,0)
       END AS VALORDESCONTO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBCREDITOCONTRIBUINTE D
LEFT OUTER JOIN TRIBCREDITOCONTRIBUINTEITEM E
 ON D.ENTIDADE = E.ENTIDADE
AND D.EXERCICIO = E.EXERCICIO
AND D.CREDITOCONTRIBUINTE = E.CREDITOCONTRIBUINTE
LEFT OUTER JOIN CONTABANCARIA CB
 ON D.ENTIDADE = CB.ENTIDADE
AND D.CONTABANCARIAESTORNO = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON E.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'
AND EXISTS (SELECT 1
            FROM TRIBCREDITOCONTRIBUINTEITEMMOV CIM
            WHERE CIM.IDCREDITOCONTRIBUINTEITEM = E.IDCREDITOCONTRIBUINTEITEM
            AND CIM.TIPO = 'E')
) X
:FILTRO
