select
    debito.iddebito,
    debitoparcelareceita.iddebitoparcelareceita,
    pessoa.pessoa,
    pessoa.idunico as idunicopessoa,
    tributo.id as idtributo,
    tributo.classificacao as classificacaotributo,
    pagamentodebito.situacaolegal,
    motivodeducao.motivodesconto as idmotivodeducao,
    tipooperacaotce.idtipooperacaotce as idtipooperacaodeducao,
    contabancaria.id as idcontacontabil,
    tributo.tiporeceita as tipoTributo,
    sum(coalesce(devolucaocreditodebito.valordevolvido,0) - coalesce(devolucaocreditodebito.valordescontoprincipal,0)) as valorprincipal,
    sum(coalesce(devolucaocreditodebito.valorjuros,0) - coalesce(devolucaocreditodebito.valordescontojuros,0)) as valorjuros,
    sum(coalesce(devolucaocreditodebito.valormulta,0) - coalesce(devolucaocreditodebito.valordescontomulta,0)) as valormulta,
    sum(coalesce(devolucaocreditodebito.valorcorrecao,0) - coalesce(devolucaocreditodebito.valordescontocorrecao,0)) as valorcorrecao
from tribdevolucaocredito devolucaoCredito
left join tribdevolucaocreditoitem devolucaocreditoitem
    on devolucaocredito.iddevolucaocredito = devolucaocreditoItem.iddevolucaocredito
left join tribdevolucaocreditodebito devolucaocreditodebito
    on devolucaocreditoitem.iddevolucaocredito = devolucaocreditodebito.iddevolucaocredito
    and devolucaocreditoitem.sequenciaitem = devolucaocreditodebito.sequenciaitem
left join contabancaria on devolucaoCredito.contabancaria = contabancaria.contabancaria
left join tribpagamentocredito credito on credito.id = devolucaocreditoitem.pagamentocredito
left join tribpagamento pagamento
    on (
    (pagamento.pagamento, pagamento.entidade, pagamento.exerciciopagamento) =
    (devolucaocreditoitem.pagamento, devolucaocreditoitem.entidade, devolucaocreditoitem.exerciciopagamento) or
    (pagamento.pagamento, pagamento.entidade, pagamento.exerciciopagamento) =
    (credito.pagamento, credito.entidadepagamento, credito.exerciciopagamento))
left join tribpagamentobloqueto  pagamentobloqueto
    on pagamentobloqueto.pagamento = pagamento.pagamento
    and pagamentobloqueto.entidade = pagamento.entidade
    and pagamentobloqueto.exerciciopagamento = pagamento.exerciciopagamento
left join tribpagamentodebito pagamentodebito
    on pagamentodebito.idpagamentobloqueto = devolucaocreditodebito.idpagamentobloqueto
    and pagamentodebito.iddebitoparcelareceita = devolucaocreditodebito.iddebitoparcelareceita
join tribbloqueto boleto on pagamentobloqueto.entidade = boleto.entidade
                        and pagamentobloqueto.exerciciobloqueto = boleto.exerciciobloqueto
                        and pagamentobloqueto.bloqueto = boleto.bloqueto
left join tribmotivodesconto motivodeducao on devolucaoCredito.motivodesconto = motivodeducao.motivodesconto
left join tribtipooperacaotce tipooperacaotce on motivodeducao.idtipooperacaotce = tipooperacaotce.idtipooperacaotce
join tribdebitoparcelareceita debitoparcelareceita on devolucaocreditodebito.iddebitoparcelareceita = debitoparcelareceita.iddebitoparcelareceita
join tribdebitoparcela parcela on debitoparcelareceita.entidade = parcela.entidade
                              and debitoparcelareceita.exercicio = parcela.exercicio
                              and debitoparcelareceita.tipocadastro = parcela.tipocadastro
                              and debitoparcelareceita.cadastrogeral = parcela.cadastrogeral
                              and debitoparcelareceita.guiarecolhimento = parcela.guiarecolhimento
                              and debitoparcelareceita.subdivida = parcela.subdivida
                              and debitoparcelareceita.parcela = parcela.parcela
join tribdebito debito on parcela.entidade = debito.entidade
                      and parcela.exercicio = debito.exercicio
                      and parcela.tipocadastro = debito.tipocadastro
                      and parcela.cadastrogeral = debito.cadastrogeral
                      and parcela.guiarecolhimento = debito.guiarecolhimento
                      and parcela.subdivida = debito.subdivida
join tribcadastrogeral cadastrogeral
                         on debito.tipocadastro  = cadastrogeral.tipocadastro
                        and debito.cadastrogeral = cadastrogeral.cadastrogeral
join pessoa on cadastrogeral.pessoa = pessoa.pessoa
join tribreceita tributo on debitoparcelareceita.entidade = tributo.entidade
                        and :exercicio = tributo.exercicio
                        and debitoparcelareceita.receita = tributo.receita
where contabancaria.integraarrecadacao = 'S'
    and devolucaoCredito.data = :dataParam
    and devolucaoCredito.situacao = 'D'
    and coalesce(pagamentodebito.valorprincipal,0) > 0
group by debito.iddebito,
    debitoparcelareceita.iddebitoparcelareceita,
    pessoa.pessoa,
    pessoa.idunico,
    tributo.id,
    tributo.classificacao,
    pagamentodebito.situacaolegal,
    motivodeducao.motivodesconto,
    tipooperacaotce.idtipooperacaotce,
    contabancaria.id,
    tributo.tiporeceita