select td.iddebito,
       tdpr.entidade,
       tdpr.exercicio,
       tdpr.tipocadastro,
       tdpr.cadastrogeral,
       tdpr.guiarecolhimento,
       tdpr.subdivida $AGRUPAMENTO_TRIBUTO,
       sum(tdprea.valoratualizacao) as valoratualizacao,
       sum(tdprea.valororiginal)    as valororiginal,
       sum(tdprea.valor)            as valor,
       case when sum(tdprea.valororiginal)  = 0 then 1 else sum(tdprea.valoratualizacao)/sum(tdprea.valororiginal) end as diferenca
from  tribdebitoparcelarecreajuste tdprea
         inner join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tdprea.iddebitoparcelareceita
         inner join tribdebito td on tdpr.entidade = td.entidade and tdpr.exercicio = td.exercicio and
                                     tdpr.tipocadastro = td.tipocadastro and tdpr.cadastrogeral = td.cadastrogeral and
                                     tdpr.guiarecolhimento = td.guiarecolhimento and tdpr.subdivida = td.subdivida
where tdprea.idreajuste = :id
    $FILTRO_RSQL
group by td.iddebito,
    tdpr.entidade,
    tdpr.exercicio,
    tdpr.tipocadastro,
    tdpr.cadastrogeral,
    tdpr.guiarecolhimento,
    tdpr.subdivida $AGRUPAMENTO_TRIBUTO