/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.sisobra;

import br.com.elotech.tributos.domain.sisobra.SisObraHabitese;
import br.com.elotech.tributos.domain.sisobra.SisObraHabiteseArea;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseDadosAlvaraDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaComplementarItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaPrincipalItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.HabiteseXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.InfHabiteseXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.NiNovoProprietarioXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.SisObraPrefHabiteseXmlDTO;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaCategoria;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaDestinacao;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaTipoObra;
import br.com.elotech.tributos.enums.sisobra.TipoHabitese;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SisObraHabiteseXmlBuilder {
    private static final String AREA_PRINCIPAL = "P";
    private static final String AREA_COMPLEMENTAR = "C";

    public static String buildXmlHabitese(SisObraHabitese habitese, List<SisObraHabiteseArea> habiteseAreas, String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        return SisObraHabiteseXmlBuilder.buildXml((SisObraHabitese)habitese, habiteseAreas, (String)cnpjCpfDocumento, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara);
    }

    private static String buildXml(SisObraHabitese habitese, List<SisObraHabiteseArea> habiteseAreas, String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        SisObraPrefHabiteseXmlDTO sisObraPrefHabiteseXmlDTO = new SisObraPrefHabiteseXmlDTO();
        HabiteseXmlDTO habiteseXmlDTO = new HabiteseXmlDTO();
        InfHabiteseXmlDTO infHabiteseXmlDTO = new InfHabiteseXmlDTO();
        sisObraPrefHabiteseXmlDTO.setVersao("1.03");
        infHabiteseXmlDTO.setId("id0000001");
        infHabiteseXmlDTO.setNumeroHabitese(habitese.getIdSisobraHabitese());
        if (habitese.getDataFinalObra() != null) {
            String dataHabitese = String.valueOf(habitese.getDataHabitese());
            String dataFinalObra = String.valueOf(habitese.getDataFinalObra());
            if (habitese.getDataFinalObra().equals(habitese.getDataAlvara())) {
                dataHabitese = dataFinalObra = String.valueOf(habitese.getDataFinalObra().plusDays(1L));
            }
            infHabiteseXmlDTO.setDataHabitese(dataHabitese);
            infHabiteseXmlDTO.setDataFinalObra(dataFinalObra);
        }
        infHabiteseXmlDTO.setTipoHabitese(TipoHabitese.fromValue((Long)habitese.getTipoHabitese()).getDescricao());
        infHabiteseXmlDTO.setUnidadeMedida(UnidadeMedida.fromValue((Long)habitese.getUnidadeMedida()).getDescricao());
        infHabiteseXmlDTO.setArea(SisObraHabiteseXmlBuilder.getListArea(habiteseAreas));
        infHabiteseXmlDTO.setNumeroAlvara(SisObraHabiteseXmlBuilder.getNumeroAlvara((SisObraHabitese)habitese, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara));
        infHabiteseXmlDTO.setDataAlvara(String.valueOf(SisObraHabiteseXmlBuilder.getDataAlvara((SisObraHabitese)habitese, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara)));
        infHabiteseXmlDTO.setNiNovoProprietario(SisObraHabiteseXmlBuilder.getProprietarioObra((String)cnpjCpfDocumento, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara));
        habiteseXmlDTO.setInfHabitese(infHabiteseXmlDTO);
        sisObraPrefHabiteseXmlDTO.setHabitese(habiteseXmlDTO);
        XmlMapper xmlMapper = new XmlMapper();
        try {
            return xmlMapper.writeValueAsString((Object)sisObraPrefHabiteseXmlDTO);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static LocalDate getDataAlvara(SisObraHabitese habitese, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        if (sisObraHabiteseDadosAlvara.getIdSisObraAlvara() != null && !sisObraHabiteseDadosAlvara.getIdSisObraAlvara().isEmpty()) {
            return LocalDate.parse(sisObraHabiteseDadosAlvara.getDataAlvara());
        }
        return habitese.getDataAlvara();
    }

    private static String getNumeroAlvara(SisObraHabitese habitese, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        if (sisObraHabiteseDadosAlvara.getIdSisObraAlvara() != null && !sisObraHabiteseDadosAlvara.getIdSisObraAlvara().isEmpty()) {
            return sisObraHabiteseDadosAlvara.getIdSisObraAlvara();
        }
        if (habitese.getNumeroAlvaraDoc() != null && !habitese.getNumeroAlvaraDoc().isEmpty()) {
            return habitese.getNumeroAlvaraDoc();
        }
        return "0";
    }

    private static NiNovoProprietarioXmlDTO getProprietarioObra(String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        NiNovoProprietarioXmlDTO niNovoProprietario = new NiNovoProprietarioXmlDTO();
        if (cnpjCpfDocumento != null) {
            if (cnpjCpfDocumento.length() == 11 && !cnpjCpfDocumento.equals(sisObraHabiteseDadosAlvara.getCpfProprietarioObra())) {
                niNovoProprietario.setCpf(cnpjCpfDocumento);
            }
            if (cnpjCpfDocumento.length() == 14 && !cnpjCpfDocumento.equals(sisObraHabiteseDadosAlvara.getCnpjProprietarioObra())) {
                niNovoProprietario.setCnpj(cnpjCpfDocumento);
            }
        }
        if (niNovoProprietario.getCpf() != null || niNovoProprietario.getCnpj() != null) {
            return niNovoProprietario;
        }
        return null;
    }

    private static AreaItemXmlDTO getListArea(List<SisObraHabiteseArea> habiteseAreas) {
        AreaItemXmlDTO areaItemXmlDTO = new AreaItemXmlDTO();
        ArrayList<AreaPrincipalItemXmlDTO> areaPrincipalList = new ArrayList<AreaPrincipalItemXmlDTO>();
        ArrayList<AreaComplementarItemXmlDTO> areaComplementarList = new ArrayList<AreaComplementarItemXmlDTO>();
        for (SisObraHabiteseArea habiteseArea : habiteseAreas) {
            if (habiteseArea.getTipo().equals("P")) {
                AreaPrincipalItemXmlDTO areaPrincipalItemXmlDTO = new AreaPrincipalItemXmlDTO();
                areaPrincipalItemXmlDTO.setCategoria(AlvaraAreaCategoria.fromValue((Long)habiteseArea.getCategoria()).getDescricao());
                areaPrincipalItemXmlDTO.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)habiteseArea.getDestinacao()).getDescricao());
                areaPrincipalItemXmlDTO.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)habiteseArea.getTipoObra()).getDescricao());
                if (areaPrincipalItemXmlDTO.getDestinacao().equals(AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR)) {
                    areaPrincipalItemXmlDTO.setQtdTotalUnidadesBloco(String.valueOf(habiteseArea.getQtdTotalUnidade()));
                }
                areaPrincipalItemXmlDTO.setArea(String.format("%.2f", habiteseArea.getArea()).replace(",", "."));
                areaPrincipalList.add(areaPrincipalItemXmlDTO);
            }
            if (!habiteseArea.getTipo().equals("C")) continue;
            AreaComplementarItemXmlDTO areaComplementarItemXmlDTO = new AreaComplementarItemXmlDTO();
            areaComplementarItemXmlDTO.setCategoria(AlvaraAreaCategoria.fromValue((Long)habiteseArea.getCategoria()).getDescricao());
            areaComplementarItemXmlDTO.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)habiteseArea.getDestinacao()).getDescricao());
            areaComplementarItemXmlDTO.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)habiteseArea.getTipoObra()).getDescricao());
            if (areaComplementarItemXmlDTO.getDestinacao().equals(AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR)) {
                areaComplementarItemXmlDTO.setQtdTotalUnidadesBloco(String.valueOf(habiteseArea.getQtdTotalUnidade()));
            }
            areaComplementarItemXmlDTO.setAreaCoberta(String.format("%.2f", habiteseArea.getAreaCoberta()).replace(",", "."));
            areaComplementarItemXmlDTO.setAreaDescoberta(String.format("%.2f", habiteseArea.getAreaDescoberta()).replace(",", "."));
            areaComplementarList.add(areaComplementarItemXmlDTO);
        }
        if (!areaPrincipalList.isEmpty()) {
            areaItemXmlDTO.setAreaPrincipal(areaPrincipalList);
        }
        if (!areaComplementarList.isEmpty()) {
            areaItemXmlDTO.setAreaComplementar(areaComplementarList);
        }
        return areaItemXmlDTO;
    }
}

