/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rocada;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.jpa.support.EloSequenceCache;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.rocada.TipoRocada;
import br.com.elotech.tributos.domain.rocada.TipoRocadaId;
import br.com.elotech.tributos.dto.rocada.TipoRocadaDTO;
import br.com.elotech.tributos.repository.rocada.TipoRocadaRepository;
import br.com.elotech.tributos.service.ContextService;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class TipoRocadaService
extends CrudService<TipoRocada, TipoRocadaId> {
    private final TipoRocadaRepository tipoRocadaRepository;
    private final ContextService contextService;
    private final EloSequenceCache eloSequenceCache;

    protected void beforeSave(TipoRocada entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        Long entidade = Objects.nonNull(entity.getId()) && Objects.nonNull(entity.getId().getEntidade()) ? entity.getId().getEntidade() : this.contextService.getEntidadePrincipal();
        Long exercicio = Objects.nonNull(entity.getId()) && Objects.nonNull(entity.getId().getExercicio()) ? entity.getId().getExercicio() : this.contextService.getExercicioAtual();
        Long id = Objects.nonNull(entity.getId()) ? entity.getId().getId() : null;
        this.validatePadraoComConflito(entity, id, entidade, exercicio);
        this.applyIdIfNotExists(entity, entidade, exercicio);
    }

    private void validatePadraoComConflito(TipoRocada tipoRocada, Long id, Long entidade, Long exercicio) {
        if (Boolean.TRUE.equals(tipoRocada.getPadrao())) {
            this.tipoRocadaRepository.findTipoRocadaPadraoComConflito(id, entidade, exercicio).ifPresent(conflitante -> {
                throw new EloValidationException(String.format("J\u00e1 existe um Tipo de Ro\u00e7ada definido como padr\u00e3o para o c\u00f3digo %d.", conflitante.getId().getId()));
            });
        }
    }

    private void applyIdIfNotExists(TipoRocada entity, Long entidade, Long exercicio) {
        if (Objects.isNull(entity.getId()) || Objects.isNull(entity.getId().getId())) {
            TipoRocadaId tipoRocadaId = new TipoRocadaId();
            tipoRocadaId.setEntidade(entidade);
            tipoRocadaId.setExercicio(exercicio);
            entity.setId(tipoRocadaId);
            EloSequenceGenerator.attrNextValues((Object)entity, (SessionFactory)((SessionFactory)this.getEm().getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)), (EloSequenceCache)this.eloSequenceCache);
        }
    }

    public Page<TipoRocada> search(String search, Pageable pageable) {
        search = String.format("id.entidade==%d and id.exercicio==%d %s", this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), search.isEmpty() ? "" : "and " + search);
        return this.findByRsql(search, pageable);
    }

    public TipoRocada findByIdAndEntidadePrincipalAndExercicioAtual(Long id) {
        TipoRocadaId tipoRocadaId = new TipoRocadaId();
        tipoRocadaId.setEntidade(this.contextService.getEntidadePrincipal());
        tipoRocadaId.setExercicio(this.contextService.getExercicioAtual());
        tipoRocadaId.setId(id);
        return (TipoRocada)this.findById((Serializable)tipoRocadaId).orElseThrow(RestException::notFound);
    }

    public TipoRocada findPadraoByEntidadeAndExercicio(Long entidade, Long exercicio) {
        return (TipoRocada)this.tipoRocadaRepository.findPadraoByEntidadeAndExercicio(entidade, exercicio).orElseThrow(RestException::notFound);
    }

    public void deleteByIdAndEntidadePrincipalAndExercicioAtual(Long id) {
        TipoRocada tipoRocada = this.findByIdAndEntidadePrincipalAndExercicioAtual(id);
        this.delete((EloEntity)tipoRocada, null);
    }

    public TipoRocadaDTO save(TipoRocadaDTO tipoRocadaDTO) {
        TipoRocada tipoRocada = (TipoRocada)this.save((EloEntity)tipoRocadaDTO.toEntity(), null);
        return TipoRocadaDTO.from((TipoRocada)tipoRocada);
    }

    @Generated
    public TipoRocadaService(TipoRocadaRepository tipoRocadaRepository, ContextService contextService, EloSequenceCache eloSequenceCache) {
        this.tipoRocadaRepository = tipoRocadaRepository;
        this.contextService = contextService;
        this.eloSequenceCache = eloSequenceCache;
    }
}

