/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class LancamentoArredacacaoJobStarter {
    private final JobLauncher jobLauncher;
    private final Job lancamentoArrecadacaoPeriodoJob;
    private final JobExplorer jobExplorer;

    public LancamentoArredacacaoJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="lancamentoArrecadacaoBatchJob") Job lancamentoArrecadacaoPeriodoJob) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.lancamentoArrecadacaoPeriodoJob = lancamentoArrecadacaoPeriodoJob;
    }

    private JobExecution start(JobParameters parameters) {
        try {
            return this.jobLauncher.run(this.lancamentoArrecadacaoPeriodoJob, parameters);
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new EloValidationException("Job Lan\u00e7amento x Arrecada\u00e7\u00e3o j\u00e1 est\u00e1 sendo executado");
        }
        catch (JobRestartException e) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel reiniciar o Job Lan\u00e7amento x Arrecada\u00e7\u00e3o");
        }
        catch (JobParametersInvalidException e) {
            throw new EloValidationException("Par\u00e2metros para o Job Lan\u00e7amento x Arrecada\u00e7\u00e3o est\u00e1 inv\u00e1lido. Verifique!");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel reiniciar o Job Lan\u00e7amento x Arrecada\u00e7\u00e3o, pois foi conclu\u00eddo com sucesso");
        }
    }

    public JobExecution startJob(Long entidade, Long exercicio, Long mesAnalise) {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade, true);
        jobParametersBuilder.addLong("exercicio", exercicio, true);
        jobParametersBuilder.addLong("mesAnalise", mesAnalise, true);
        jobParametersBuilder.addDate("date", new Date());
        this.validateExisteJobComMesmosParametros(entidade, exercicio, mesAnalise);
        return this.start(jobParametersBuilder.toJobParameters());
    }

    protected void validateExisteJobComMesmosParametros(Long entidade, Long exercicio, Long mesAnalise) {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.LANCAMENTO_ARRECADACAO.getTipo()).stream().anyMatch(jobExecution -> {
            Long parametroEntidade = jobExecution.getJobParameters().getLong("entidade");
            Long parametroExercicio = jobExecution.getJobParameters().getLong("exercicio");
            Long parametroMesAnalise = jobExecution.getJobParameters().getLong("mesAnalise");
            return Objects.equals(parametroEntidade, entidade) && Objects.equals(parametroExercicio, exercicio) && Objects.equals(parametroMesAnalise, mesAnalise);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException("J\u00e1 existe um job de lan\u00e7amento x arrecada\u00e7\u00e3o em execu\u00e7\u00e3o com os mesmos par\u00e2metros.");
        }
    }
}

