/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.parcelametoreajuste;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajuste;
import br.com.elotech.tributos.dto.parcelamento.SituacaoReajusteParcelamentoLote;
import br.com.elotech.tributos.dto.parcelamento.SituacaoReajusteParcelamentoLoteItem;
import br.com.elotech.tributos.exception.LoteParcelamentoReajusteNotFoundException;
import br.com.elotech.tributos.service.LoteParcelamentoReajusteService;
import br.com.elotech.tributos.service.NotificacaoService;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class LoteReajusteParcelamentoJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoteReajusteParcelamentoJobListener.class);
    private final LoteParcelamentoReajusteService loteParcelamentoReajusteService;
    private final NotificacaoService notificacaoService;
    private final String notificationKey = "notificacaoId";
    private static final Map<NotificationStatus, String> notificationMessage = Map.of(NotificationStatus.STARTED, "Iniciando processamento de atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento %s ", NotificationStatus.COMPLETED, "Finalizado processamento de atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento %s", NotificationStatus.FAILED, "Erro no processamento de atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento %s");

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idLoteReajusteParcela = jobExecution.getJobParameters().getLong("idLoteReajusteParcela");
        LoteParcelamentoReajuste loteParcelamentoReajuste = this.findLoteParcelamentoReajust(idLoteReajusteParcela);
        loteParcelamentoReajuste.setSituacao(SituacaoReajusteParcelamentoLote.STARTED);
        this.loteParcelamentoReajusteService.save((EloEntity)loteParcelamentoReajuste, null);
        Optional notificacaoId = this.notificaInicio(idLoteReajusteParcela, jobExecution);
        notificacaoId.ifPresent(id -> jobExecution.getExecutionContext().put("notificacaoId", id));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idLoteReajusteParcela = jobExecution.getJobParameters().getLong("idLoteReajusteParcela");
        LoteParcelamentoReajuste loteParcelamentoReajuste = this.findLoteParcelamentoReajust(idLoteReajusteParcela);
        Boolean allSucceed = loteParcelamentoReajuste.getItens().stream().allMatch(i -> SituacaoReajusteParcelamentoLoteItem.SUCCESS.equals((Object)i.getSituacaoReajusteParcelamentoLote()));
        if (allSucceed.booleanValue()) {
            loteParcelamentoReajuste.setSituacao(SituacaoReajusteParcelamentoLote.SUCCESS);
        } else {
            loteParcelamentoReajuste.setSituacao(SituacaoReajusteParcelamentoLote.UNFINISHED);
        }
        this.loteParcelamentoReajusteService.save((EloEntity)loteParcelamentoReajuste, null);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificaFinalSuccess(idLoteReajusteParcela, jobExecution);
        } else {
            this.notificaFinalFailed(idLoteReajusteParcela, jobExecution);
        }
    }

    private Optional<UUID> notificaInicio(Long idLoteReajusteParcela, JobExecution jobExecution) {
        return this.notificar(idLoteReajusteParcela, jobExecution, NotificationStatus.STARTED);
    }

    private void notificaFinalSuccess(Long idLoteReajusteParcela, JobExecution jobExecution) {
        this.notificar(idLoteReajusteParcela, jobExecution, NotificationStatus.COMPLETED);
    }

    private void notificaFinalFailed(Long idLoteReajusteParcela, JobExecution jobExecution) {
        this.notificar(idLoteReajusteParcela, jobExecution, NotificationStatus.FAILED);
    }

    private Optional<UUID> notificar(Long idLoteReajusteParcela, JobExecution jobExecution, NotificationStatus status) {
        String message = String.format((String)notificationMessage.get(status), idLoteReajusteParcela);
        Optional<UUID> notificacaoId = Optional.ofNullable(jobExecution.getExecutionContext().get("notificacaoId")).map(id -> UUID.fromString(String.valueOf(id)));
        return this.notificacaoService.send("Processamento do lote de Atualiza\u00e7\u00e3o Monet\u00e1ria de Parcelamento", message, jobExecution, notificacaoId, status);
    }

    private LoteParcelamentoReajuste findLoteParcelamentoReajust(Long id) {
        return (LoteParcelamentoReajuste)this.loteParcelamentoReajusteService.findById((Serializable)id).orElseThrow(() -> new LoteParcelamentoReajusteNotFoundException(id));
    }

    @Generated
    public LoteReajusteParcelamentoJobListener(LoteParcelamentoReajusteService loteParcelamentoReajusteService, NotificacaoService notificacaoService) {
        this.loteParcelamentoReajusteService = loteParcelamentoReajusteService;
        this.notificacaoService = notificacaoService;
    }
}

